/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util.intern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DOMHelper {
    private static final Comparator<? super Node> ATTRIBUTE_NODE_COMPARATOR = new Comparator<Node>(){

        private int compareMaybeNull(Comparable<Object> a, Object b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.compareTo(b);
        }

        @Override
        public int compare(Node o1, Node o2) {
            Comparable[] c1 = DOMHelper.getNodeAttributes(o1);
            Comparable[] c2 = DOMHelper.getNodeAttributes(o2);
            assert (c1.length == c2.length);
            for (int i = 0; i < c1.length; ++i) {
                int result = this.compareMaybeNull(c1[i], c2[i]);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    };

    public static Map<String, String> getNamespaceMapping(Document document) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("xmlns", "http://www.w3.org/2000/xmlns/");
        map.put("xml", "http://www.w3.org/XML/1998/namespace");
        Element root = document.getDocumentElement();
        if (root == null) {
            return map;
        }
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!"xmlns".equals(attribute.getPrefix()) && !"xmlns".equals(attribute.getLocalName())) continue;
            if ("xmlns".equals(attribute.getLocalName())) {
                map.put("xbdefaultns", attribute.getNodeValue());
                continue;
            }
            map.put(attribute.getLocalName(), attribute.getNodeValue());
        }
        return map;
    }

    public static void setDocumentElement(Document document, Element element) {
        Element documentElement = document.getDocumentElement();
        if (documentElement != null) {
            document.removeChild(documentElement);
        }
        if (element != null) {
            if (element.getOwnerDocument().equals(document)) {
                document.appendChild(element);
                return;
            }
            Node node = document.adoptNode(element);
            document.appendChild(node);
        }
    }

    public static boolean nodesAreEqual(Node a, Node b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!Arrays.equals(DOMHelper.getNodeAttributes(a), DOMHelper.getNodeAttributes(b))) {
            return false;
        }
        if (!DOMHelper.namedNodeMapsAreEqual(a.getAttributes(), b.getAttributes())) {
            return false;
        }
        return DOMHelper.nodeListsAreEqual(a.getChildNodes(), b.getChildNodes());
    }

    private static boolean nodeListsAreEqual(NodeList a, NodeList b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getLength() != b.getLength()) {
            return false;
        }
        for (int i = 0; i < a.getLength(); ++i) {
            if (DOMHelper.nodesAreEqual(a.item(i), b.item(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean namedNodeMapsAreEqual(NamedNodeMap a, NamedNodeMap b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getLength() != b.getLength()) {
            return false;
        }
        ArrayList<Node> listA = new ArrayList<Node>(a.getLength());
        ArrayList<Node> listB = new ArrayList<Node>(a.getLength());
        for (int i = 0; i < a.getLength(); ++i) {
            listA.add(a.item(i));
            listB.add(b.item(i));
        }
        Collections.sort(listA, ATTRIBUTE_NODE_COMPARATOR);
        Collections.sort(listB, ATTRIBUTE_NODE_COMPARATOR);
        for (Node n1 : listA) {
            if (DOMHelper.nodesAreEqual(n1, (Node)listB.remove(0))) continue;
            return false;
        }
        return true;
    }

    private static Comparable<Object>[] getNodeAttributes(Node node) {
        return new Comparable[]{Short.valueOf(node.getNodeType()), node.getNodeName(), node.getLocalName(), node.getNamespaceURI(), node.getPrefix(), node.getNodeValue()};
    }

    public static int nodeHashCode(Node node) {
        int i;
        assert (node != null);
        int hash = 1 + node.getNodeType();
        hash = hash * 17 + Arrays.hashCode(DOMHelper.getNodeAttributes(node));
        if (node.hasAttributes()) {
            NamedNodeMap nodeMap = node.getAttributes();
            for (i = 0; i < nodeMap.getLength(); ++i) {
                hash = 31 * hash + DOMHelper.nodeHashCode(nodeMap.item(i));
            }
        }
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            for (i = 0; i < childNodes.getLength(); ++i) {
                hash = hash * 47 + DOMHelper.nodeHashCode(childNodes.item(i));
            }
        }
        return hash;
    }

    public static void setOrRemoveAttribute(Element element, String attributeName, String value) {
        if (value == null) {
            element.removeAttribute(attributeName);
            return;
        }
        element.setAttribute(attributeName, value);
    }

    public static Element renameElement(Element element, String newName) {
        Document document = element.getOwnerDocument();
        Element newElement = DOMHelper.createElement(document, newName);
        NodeList nodeList = element.getChildNodes();
        LinkedList<Node> toBeMoved = new LinkedList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            toBeMoved.add(nodeList.item(i));
        }
        for (Node e : toBeMoved) {
            element.removeChild(e);
            newElement.appendChild(e);
        }
        return newElement;
    }

    public static void ensureOwnership(Document ownerDocument, Node node) {
        if (ownerDocument != node.getOwnerDocument()) {
            ownerDocument.adoptNode(node);
        }
    }

    public static Document getOwnerDocumentFor(Node documentOrElement) {
        if (9 == documentOrElement.getNodeType()) {
            return (Document)documentOrElement;
        }
        return documentOrElement.getOwnerDocument();
    }

    private static Element createElement(Document document, String elementName) {
        String prefix = DOMHelper.getPrefixOfQName(elementName);
        String namespaceURI = prefix.isEmpty() ? null : document.lookupNamespaceURI(prefix);
        Element element = namespaceURI == null ? document.createElement(elementName) : document.createElementNS(namespaceURI, elementName);
        return element;
    }

    private static String getPrefixOfQName(String elementName) {
        if (elementName.contains(":")) {
            return elementName.replaceAll(":.*", "");
        }
        return "";
    }

    public static void trim(Node domNode) {
        assert (domNode != null);
        assert (3 != domNode.getNodeType());
        LinkedList<Text> removeMe = new LinkedList<Text>();
        NodeList childNodes = domNode.getChildNodes();
        for (Node child : DOMHelper.nodeListToIterator(childNodes)) {
            if (3 == child.getNodeType()) {
                if (child.getNodeValue() != null && !child.getNodeValue().trim().isEmpty()) continue;
                removeMe.add((Text)child);
                continue;
            }
            DOMHelper.trim(child);
        }
        for (Text node : removeMe) {
            Node parent = node.getParentNode();
            if (parent == null) continue;
            parent.removeChild(node);
        }
    }

    private static Iterable<Node> nodeListToIterator(final NodeList nodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return nodeList.getLength() > this.pos;
                    }

                    @Override
                    public Node next() {
                        return nodeList.item(this.pos++);
                    }

                    @Override
                    public void remove() {
                        throw new IllegalStateException();
                    }
                };
            }
        };
    }

    public static <T> List<T> asList(T node) {
        if (node == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(node);
    }

    public static void replaceElement(Element previous, Element newNode) {
        assert (previous.getParentNode() != null);
        Element parent = (Element)previous.getParentNode();
        Document document = DOMHelper.getOwnerDocumentFor(parent);
        DOMHelper.ensureOwnership(document, newNode);
        parent.replaceChild(newNode, previous);
    }

    public static void setStringValue(Node newNode, String value) {
        assert (newNode.getNodeType() != 9);
        newNode.setTextContent(value);
    }

    public static void removeAllChildren(Element element) {
        Node n = element.getFirstChild();
        while (n != null) {
            element.removeChild(n);
            n = element.getFirstChild();
        }
    }

    public static void removeAttribute(Attr attributeNode) {
        if (attributeNode == null) {
            return;
        }
        Element owner = attributeNode.getOwnerElement();
        if (owner == null) {
            return;
        }
        owner.removeAttributeNode(attributeNode);
    }

    public static void removeNode(Node node) {
        if (node == null) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        parent.removeChild(node);
    }

    public static void appendClone(Element parentElement, Node o) {
        Node clone = o.cloneNode(true);
        DOMHelper.ensureOwnership(DOMHelper.getOwnerDocumentFor(parentElement), clone);
        parentElement.appendChild(clone);
    }

    public static void removeNodes(List<? extends Node> existingNodes) {
        for (Node node : existingNodes) {
            DOMHelper.removeNode(node);
        }
    }
}

