/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.xmlbeam.XBProjector;
import org.xmlbeam.evaluation.CanEvaluate;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.DocumentResolver;
import org.xmlbeam.evaluation.XPathEvaluator;
import org.xmlbeam.util.IOHelper;
import org.xmlbeam.util.intern.ReflectionHelper;

public class XBUrlIO
implements CanEvaluate {
    private final XBProjector projector;
    private final Map<String, String> requestProperties = new HashMap<String, String>();
    private final String url;

    public XBUrlIO(XBProjector projector, String url) {
        this.projector = projector;
        this.url = url;
        this.requestProperties.put("Content-Type", "text/xml");
    }

    public <T> T read(Class<T> projectionInterface) throws IOException {
        Class<?> callerClass = null;
        if (IOHelper.isResourceProtocol(this.url)) {
            callerClass = ReflectionHelper.getDirectCallerClass();
        }
        Document document = IOHelper.getDocumentFromURL(this.projector.config().createDocumentBuilder(), this.url, this.requestProperties, projectionInterface, callerClass);
        return this.projector.projectDOMNode(document, projectionInterface);
    }

    public String write(Object projection) throws IOException {
        return IOHelper.inputStreamToString(IOHelper.httpPost(this.url, projection.toString(), this.requestProperties), new String[0]);
    }

    public XBUrlIO addRequestProperties(Map<String, String> params) {
        this.requestProperties.putAll(params);
        return this;
    }

    public XBUrlIO addRequestProperty(String name, String value) {
        this.requestProperties.put(name, value);
        return this;
    }

    @Override
    public XPathEvaluator evalXPath(String xpath) {
        return new DefaultXPathEvaluator(this.projector, new DocumentResolver(){

            @Override
            public Document resolve(Class<?> ... resourceAwareClasses) throws IOException {
                return IOHelper.getDocumentFromURL(XBUrlIO.this.projector.config().createDocumentBuilder(), XBUrlIO.this.url, XBUrlIO.this.requestProperties, resourceAwareClasses);
            }
        }, xpath);
    }
}

