/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xmlbeam.XBProjector;
import org.xmlbeam.evaluation.CanEvaluate;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.DocumentResolver;
import org.xmlbeam.evaluation.XPathEvaluator;
import org.xmlbeam.io.XBStreamOutput;
import org.xmlbeam.util.IOHelper;

public class XBFileIO
implements CanEvaluate {
    private final XBProjector projector;
    private boolean append = false;
    private final File file;

    public XBFileIO(XBProjector xmlProjector, File file) {
        if (xmlProjector == null) {
            throw new NullPointerException("Parameter xmlProjector must not be null.");
        }
        if (file == null) {
            throw new NullPointerException("Parameter file must not be null.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File " + file + " is a directory.");
        }
        this.projector = xmlProjector;
        this.file = file;
    }

    public XBFileIO(XBProjector xmlProjector, String fileName) {
        this(xmlProjector, new File(fileName));
    }

    public <T> T read(Class<T> projectionInterface) throws IOException {
        try {
            Document document = this.projector.config().createDocumentBuilder().parse(this.file);
            return this.projector.projectDOMNode(document, projectionInterface);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public XBFileIO write(Object projection) throws IOException {
        FileOutputStream os = new FileOutputStream(this.file, this.append);
        new XBStreamOutput(this.projector, os).write(projection);
        os.close();
        return this;
    }

    public XBFileIO setAppend(boolean append) {
        this.append = append;
        return this;
    }

    @Override
    public XPathEvaluator evalXPath(String xpath) {
        return new DefaultXPathEvaluator(this.projector, new DocumentResolver(){

            @Override
            public Document resolve(Class<?> ... resourceAwareClass) throws IOException {
                FileInputStream fileInputStream = new FileInputStream(XBFileIO.this.file);
                Document doc = IOHelper.loadDocument(XBFileIO.this.projector, fileInputStream);
                fileInputStream.close();
                return doc;
            }
        }, xpath);
    }
}

