/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlbeam.DefaultDOMAccessInvoker;
import org.xmlbeam.MethodSignature;
import org.xmlbeam.XBDataNotFoundException;
import org.xmlbeam.XBPathException;
import org.xmlbeam.XBProjector;
import org.xmlbeam.annotation.XBDelete;
import org.xmlbeam.annotation.XBDocURL;
import org.xmlbeam.annotation.XBOverride;
import org.xmlbeam.annotation.XBRead;
import org.xmlbeam.annotation.XBUpdate;
import org.xmlbeam.annotation.XBValue;
import org.xmlbeam.annotation.XBWrite;
import org.xmlbeam.dom.DOMAccess;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.InvocationContext;
import org.xmlbeam.util.IOHelper;
import org.xmlbeam.util.intern.DOMHelper;
import org.xmlbeam.util.intern.MethodParamVariableResolver;
import org.xmlbeam.util.intern.Preprocessor;
import org.xmlbeam.util.intern.ReflectionHelper;
import org.xmlbeam.util.intern.duplex.DuplexExpression;
import org.xmlbeam.util.intern.duplex.DuplexXPathParser;
import org.xmlbeam.util.intern.duplex.ExpressionType;
import org.xmlbeam.util.intern.duplex.XBPathParsingException;

final class ProjectionInvocationHandler
implements InvocationHandler,
Serializable {
    private static final InvocationHandler DEFAULT_METHOD_INVOCATION_HANDLER = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return ReflectionHelper.invokeDefaultMethod(method, args, proxy);
        }
    };
    private final Map<MethodSignature, InvocationHandler> handlers = new HashMap<MethodSignature, InvocationHandler>();
    private final Map<MethodSignature, InvocationHandler> mixinHandlers = new HashMap<MethodSignature, InvocationHandler>();

    private Map<MethodSignature, InvocationHandler> getDefaultInvokers(Object defaultInvokerObject) {
        ReflectionInvoker reflectionInvoker = new ReflectionInvoker(defaultInvokerObject);
        HashMap<MethodSignature, InvocationHandler> invokers = new HashMap<MethodSignature, InvocationHandler>();
        for (Method m : DOMAccess.class.getMethods()) {
            if (m.getAnnotation(XBWrite.class) != null) continue;
            invokers.put(MethodSignature.forMethod(m), reflectionInvoker);
        }
        invokers.put(MethodSignature.forVoidMethod("toString"), reflectionInvoker);
        invokers.put(MethodSignature.forSingleParam("equals", Object.class), reflectionInvoker);
        invokers.put(MethodSignature.forVoidMethod("hashCode"), reflectionInvoker);
        return invokers;
    }

    ProjectionInvocationHandler(XBProjector projector, Node node, Class<?> projectionInterface, Map<Class<?>, Object> mixins, boolean toStringRendersXML, boolean absentIsEmpty) {
        DefaultDOMAccessInvoker defaultInvokerObject = DefaultDOMAccessInvoker.create(projectionInterface, node, projector, toStringRendersXML);
        Map<MethodSignature, InvocationHandler> defaultInvocationHandlers = this.getDefaultInvokers(defaultInvokerObject);
        for (Map.Entry<Class<?>, Object> e : mixins.entrySet()) {
            for (Method m : e.getKey().getMethods()) {
                this.mixinHandlers.put(MethodSignature.forMethod(m), new MixinInvoker(e.getValue(), projectionInterface));
            }
        }
        this.handlers.putAll(defaultInvocationHandlers);
        List<Class<?>> allSuperInterfaces = ReflectionHelper.findAllSuperInterfaces(projectionInterface);
        for (Class<?> i7e : allSuperInterfaces) {
            for (Method m : i7e.getDeclaredMethods()) {
                MethodSignature methodSignature = MethodSignature.forMethod(m);
                if (ReflectionHelper.isDefaultMethod(m)) {
                    this.handlers.put(methodSignature, DEFAULT_METHOD_INVOCATION_HANDLER);
                    XBOverride xbOverride = m.getAnnotation(XBOverride.class);
                    if (xbOverride == null) continue;
                    this.handlers.put(methodSignature.overridenBy(xbOverride.value()), new OverrideByDefaultMethodInvocationHandler(m));
                    continue;
                }
                if (defaultInvocationHandlers.containsKey(methodSignature)) continue;
                XBRead readAnnotation = m.getAnnotation(XBRead.class);
                if (readAnnotation != null) {
                    this.handlers.put(methodSignature, new ReadInvocationHandler(node, m, readAnnotation.value(), projector, absentIsEmpty));
                    continue;
                }
                XBUpdate updateAnnotation = m.getAnnotation(XBUpdate.class);
                if (updateAnnotation != null) {
                    this.handlers.put(methodSignature, new UpdateInvocationHandler(node, m, updateAnnotation.value(), projector));
                    continue;
                }
                XBWrite writeAnnotation = m.getAnnotation(XBWrite.class);
                if (writeAnnotation != null) {
                    this.handlers.put(methodSignature, new WriteInvocationHandler(node, m, writeAnnotation.value(), projector));
                    continue;
                }
                XBDelete delAnnotation = m.getAnnotation(XBDelete.class);
                if (delAnnotation != null) {
                    this.handlers.put(methodSignature, new DeleteInvocationHandler(node, m, delAnnotation.value(), projector));
                    continue;
                }
                if (this.mixinHandlers.containsKey(methodSignature)) continue;
                throw new IllegalArgumentException("I don't known how to handle method " + m + ". Did you forget to add a XB*-annotation or to register a mixin?");
            }
        }
    }

    private static boolean isStructureChangingValue(Object o) {
        return o instanceof XBProjector.InternalProjection || o instanceof Node;
    }

    private static int findIndexOfValue(Method method) {
        int index = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation a : annotations = annotationArray[i]) {
                if (!XBValue.class.equals(a.annotationType())) continue;
                return index;
            }
            ++index;
        }
        return 0;
    }

    private static void injectMeAttribute(XBProjector.InternalProjection me, Object target, Class<?> projectionInterface) {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (!ProjectionInvocationHandler.isValidMeField(field, projectionInterface)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                field.set(target, me);
                return;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Mixin " + target.getClass().getSimpleName() + " needs an attribute \"private " + projectionInterface.getSimpleName() + " me;\" to be able to access the projection.");
    }

    private static boolean isValidMeField(Field field, Class<?> projInterface) {
        if (field == null) {
            return false;
        }
        if (!"me".equalsIgnoreCase(field.getName())) {
            return false;
        }
        if (DOMAccess.class.equals(field.getType())) {
            return true;
        }
        return field.getType().isAssignableFrom(projInterface);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodSignature methodSignature;
        ProjectionInvocationHandler.unwrapArgs(method.getParameterTypes(), args);
        if (!this.mixinHandlers.isEmpty() && this.mixinHandlers.containsKey(methodSignature = MethodSignature.forMethod(method))) {
            return this.mixinHandlers.get(methodSignature).invoke(proxy, method, args);
        }
        InvocationHandler invocationHandler = this.handlers.get(MethodSignature.forMethod(method));
        if (invocationHandler != null) {
            try {
                return invocationHandler.invoke(proxy, method, args);
            }
            catch (XPathExpressionException e) {
                throw new XBPathException(e, method, "??");
            }
        }
        throw new IllegalArgumentException("I don't known how to invoke method " + method + ". Did you forget to add a XB*-annotation or to register a mixin?");
    }

    private static void unwrapArgs(Class<?>[] types, Object[] args) {
        if (args == null) {
            return;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                args[i] = ReflectionHelper.unwrap(types[i], args[i]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static boolean isMultiValue(Class<?> type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    private static Class<?> findTargetComponentType(Method method) {
        if (method.getReturnType().isArray()) {
            return method.getReturnType().getComponentType();
        }
        if (!List.class.equals(method.getReturnType())) {
            return null;
        }
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getActualTypeArguments() == null || ((ParameterizedType)type).getActualTypeArguments().length < 1) {
            throw new IllegalArgumentException("When using List as return type for method " + method + ", please specify a generic type for the List. Otherwise I do not know which type I should fill the List with.");
        }
        assert (((ParameterizedType)type).getActualTypeArguments().length == 1) : "";
        Type componentType = ((ParameterizedType)type).getActualTypeArguments()[0];
        if (!(componentType instanceof Class)) {
            throw new IllegalArgumentException("I don't know how to instantiate the generic type for the return type of method " + method);
        }
        return (Class)componentType;
    }

    private static final class OverrideByDefaultMethodInvocationHandler
    implements InvocationHandler {
        private final Method defaultMethod;

        OverrideByDefaultMethodInvocationHandler(Method defaultMethod) {
            this.defaultMethod = defaultMethod;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return DEFAULT_METHOD_INVOCATION_HANDLER.invoke(proxy, this.defaultMethod, args);
        }
    }

    private static class WriteInvocationHandler
    extends ProjectionMethodInvocationHandler {
        private final int findIndexOfValue;

        public WriteInvocationHandler(Node node, Method m, String value, XBProjector projector) {
            super(node, m, value, projector);
            this.findIndexOfValue = ProjectionInvocationHandler.findIndexOfValue(m);
        }

        private Object handeRootElementReplacement(Object proxy, Method method, Document document, Object valueToSet) {
            int count;
            int n = count = document.getDocumentElement() == null ? 0 : 1;
            if (valueToSet == null) {
                DOMHelper.setDocumentElement(document, null);
                return this.getProxyReturnValueForMethod(proxy, method, count);
            }
            if (valueToSet instanceof Element) {
                Element clone = (Element)((Element)valueToSet).cloneNode(true);
                document.adoptNode(clone);
                if (document.getDocumentElement() == null) {
                    document.appendChild(clone);
                    return this.getProxyReturnValueForMethod(proxy, method, 1);
                }
                document.replaceChild(document.getDocumentElement(), clone);
                return this.getProxyReturnValueForMethod(proxy, method, 1);
            }
            if (!(valueToSet instanceof XBProjector.InternalProjection)) {
                throw new IllegalArgumentException("Method " + method + " was invoked as setter changing the document root element. Expected value type was a projection so I can determine a element name. But you provided a " + valueToSet);
            }
            XBProjector.InternalProjection projection = (XBProjector.InternalProjection)valueToSet;
            Element element = projection.getDOMBaseElement();
            assert (element != null);
            DOMHelper.setDocumentElement(document, element);
            return this.getProxyReturnValueForMethod(proxy, method, count);
        }

        private int applyCollectionSetOnElement(Collection<?> collection, Element parentElement, DuplexExpression duplexExpression) {
            for (Object o : collection) {
                Element elementToAdd;
                if (o == null) continue;
                if (!ProjectionInvocationHandler.isStructureChangingValue(o)) {
                    Node newElement = duplexExpression.createChildWithPredicate(parentElement);
                    String asString = this.projector.config().getStringRenderer().render(o.getClass(), o, duplexExpression.getExpressionFormatPattern());
                    newElement.setTextContent(asString);
                    continue;
                }
                if (o instanceof Node) {
                    Node n = (Node)o;
                    elementToAdd = (Element)(9 != n.getNodeType() ? n : (n.getOwnerDocument() == null ? null : n.getOwnerDocument().getDocumentElement()));
                } else {
                    XBProjector.InternalProjection p = (XBProjector.InternalProjection)o;
                    elementToAdd = p.getDOMBaseElement();
                }
                if (elementToAdd == null) continue;
                Element clone = (Element)elementToAdd.cloneNode(true);
                Element childWithPredicate = (Element)duplexExpression.createChildWithPredicate(parentElement);
                String elementName = childWithPredicate.getNodeName();
                if (!elementName.equals(clone.getNodeName()) && !"*".equals(elementName)) {
                    clone = DOMHelper.renameElement(clone, elementName);
                }
                DOMHelper.replaceElement(childWithPredicate, clone);
            }
            return collection.size();
        }

        @Override
        public Object invokeProjection(String resolvedXpath, Object proxy, Object[] args) throws Throwable {
            this.lastInvocationContext.updateMethodArgs(args);
            Document document = DOMHelper.getOwnerDocumentFor(this.node);
            assert (document != null);
            Object valueToSet = args[this.findIndexOfValue];
            boolean isMultiValue = ProjectionInvocationHandler.isMultiValue(this.method.getParameterTypes()[this.findIndexOfValue]);
            if ("/*".equals(resolvedXpath)) {
                if (isMultiValue) {
                    throw new IllegalArgumentException("Method " + this.method + " was invoked as setter changing the document root element, but tries to set multiple values.");
                }
                return this.handeRootElementReplacement(proxy, this.method, document, valueToSet);
            }
            boolean wildCardTarget = resolvedXpath.endsWith("/*");
            try {
                DuplexExpression duplexExpression;
                if (!this.lastInvocationContext.isStillValid(resolvedXpath)) {
                    duplexExpression = wildCardTarget ? new DuplexXPathParser().compile(resolvedXpath.substring(0, resolvedXpath.length() - 2)) : new DuplexXPathParser().compile(resolvedXpath);
                    MethodParamVariableResolver resolver = null;
                    if (duplexExpression.isUsingVariables()) {
                        resolver = new MethodParamVariableResolver(this.method, args, duplexExpression, this.projector.config().getStringRenderer(), null);
                        duplexExpression.setXPathVariableResolver(resolver);
                    }
                    Class targetComponentType = ProjectionInvocationHandler.findTargetComponentType(this.method);
                    this.lastInvocationContext = new InvocationContext(resolvedXpath, null, null, duplexExpression, resolver, targetComponentType, this.projector);
                }
                if ((duplexExpression = this.lastInvocationContext.getDuplexExpression()).getExpressionType().isMustEvalAsString()) {
                    throw new XBPathException("Unwriteable xpath selector used ", this.method, resolvedXpath);
                }
                if (isMultiValue) {
                    Element parentElement;
                    List collection2Set;
                    if (duplexExpression.getExpressionType().equals((Object)ExpressionType.ATTRIBUTE)) {
                        throw new IllegalArgumentException("Method " + this.method + " was invoked as setter changing some attribute, but was declared to set multiple values. I can not create multiple attributes for one path.");
                    }
                    Collection<Object> collection = valueToSet == null ? Collections.emptyList() : (collection2Set = valueToSet.getClass().isArray() ? ReflectionHelper.array2ObjectList(valueToSet) : (Collection)valueToSet);
                    if (wildCardTarget) {
                        parentElement = (Element)duplexExpression.ensureExistence(this.node);
                        DOMHelper.removeAllChildren(parentElement);
                        int count = 0;
                        for (Object o : collection2Set) {
                            if (o == null) continue;
                            ++count;
                            if (o instanceof Node) {
                                DOMHelper.appendClone(parentElement, (Node)o);
                                continue;
                            }
                            if (o instanceof XBProjector.InternalProjection) {
                                DOMHelper.appendClone(parentElement, ((XBProjector.InternalProjection)o).getDOMBaseElement());
                                continue;
                            }
                            throw new XBPathException("When using a wildcard target, the type to set must be a DOM Node or another projection. Otherwise I can not determine the element name.", this.method, resolvedXpath);
                        }
                        return this.getProxyReturnValueForMethod(proxy, this.method, count);
                    }
                    parentElement = duplexExpression.ensureParentExistence(this.node);
                    duplexExpression.deleteAllMatchingChildren(parentElement);
                    int count = this.applyCollectionSetOnElement(collection2Set, parentElement, duplexExpression);
                    return this.getProxyReturnValueForMethod(proxy, this.method, count);
                }
                if (duplexExpression.getExpressionType().equals((Object)ExpressionType.ATTRIBUTE)) {
                    if (wildCardTarget) {
                        throw new XBPathException("Wildcards are not allowed when writing to an attribute. I need to know to which Element I should set the attribute", this.method, resolvedXpath);
                    }
                    Attr attribute = (Attr)duplexExpression.ensureExistence(this.node);
                    if (valueToSet == null) {
                        attribute.getOwnerElement().removeAttributeNode(attribute);
                        return this.getProxyReturnValueForMethod(proxy, this.method, 1);
                    }
                    DOMHelper.setStringValue(attribute, valueToSet.toString());
                    return this.getProxyReturnValueForMethod(proxy, this.method, 1);
                }
                if (valueToSet instanceof Node || valueToSet instanceof XBProjector.InternalProjection) {
                    if (valueToSet instanceof Attr) {
                        if (wildCardTarget) {
                            throw new XBPathException("Wildcards are not allowed when writing an attribute. I need to know to which Element I should set the attribute", this.method, resolvedXpath);
                        }
                        Element parentNode = duplexExpression.ensureParentExistence(this.node);
                        if (((Attr)valueToSet).getNamespaceURI() != null) {
                            parentNode.setAttributeNodeNS((Attr)valueToSet);
                            return this.getProxyReturnValueForMethod(proxy, this.method, 1);
                        }
                        parentNode.setAttributeNode((Attr)valueToSet);
                        return this.getProxyReturnValueForMethod(proxy, this.method, 1);
                    }
                    Element newNodeOrigin = valueToSet instanceof XBProjector.InternalProjection ? ((XBProjector.InternalProjection)valueToSet).getDOMBaseElement() : (Element)valueToSet;
                    Element newNode = (Element)newNodeOrigin.cloneNode(true);
                    DOMHelper.ensureOwnership(document, newNode);
                    if (wildCardTarget) {
                        Element parentElement = (Element)duplexExpression.ensureExistence(this.node);
                        DOMHelper.removeAllChildren(parentElement);
                        parentElement.appendChild(newNode);
                        return this.getProxyReturnValueForMethod(proxy, this.method, 1);
                    }
                    Element previousElement = (Element)duplexExpression.ensureExistence(this.node);
                    DOMHelper.replaceElement(previousElement, newNode);
                    return this.getProxyReturnValueForMethod(proxy, this.method, 1);
                }
                Element elementToChange = (Element)duplexExpression.ensureExistence(this.node);
                if (valueToSet == null) {
                    DOMHelper.removeAllChildren(elementToChange);
                } else {
                    String asString = this.projector.config().getStringRenderer().render(valueToSet.getClass(), valueToSet, duplexExpression.getExpressionFormatPattern());
                    elementToChange.setTextContent(asString);
                }
                return this.getProxyReturnValueForMethod(proxy, this.method, 1);
            }
            catch (XBPathParsingException e) {
                throw new XBPathException(e, this.method, resolvedXpath);
            }
        }
    }

    private static class DeleteInvocationHandler
    extends XPathInvocationHandler {
        public DeleteInvocationHandler(Node node, Method m, String value, XBProjector projector) {
            super(node, m, value, projector);
        }

        @Override
        public Object invokeXpathProjection(InvocationContext invocationContext, Object proxy, Object[] args) throws Throwable {
            XPathExpression expression = invocationContext.getxPathExpression();
            NodeList nodes = (NodeList)expression.evaluate(this.node, XPathConstants.NODESET);
            int count = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (2 == nodes.item(i).getNodeType()) {
                    Attr attr = (Attr)nodes.item(i);
                    attr.getOwnerElement().removeAttributeNode(attr);
                    ++count;
                    continue;
                }
                Node parentNode = nodes.item(i).getParentNode();
                if (parentNode == null) continue;
                parentNode.removeChild(nodes.item(i));
                ++count;
            }
            return this.getProxyReturnValueForMethod(proxy, this.method, count);
        }
    }

    private static class UpdateInvocationHandler
    extends XPathInvocationHandler {
        private final int findIndexOfValue;

        public UpdateInvocationHandler(Node node, Method m, String value, XBProjector projector) {
            super(node, m, value, projector);
            this.findIndexOfValue = ProjectionInvocationHandler.findIndexOfValue(m);
            if (ProjectionInvocationHandler.isMultiValue(m.getParameterTypes()[this.findIndexOfValue])) {
                throw new IllegalArgumentException("Method " + m + " was declated as updater but with multiple values. Update is possible for single values only. Consider using @XBWrite.");
            }
        }

        @Override
        public Object invokeXpathProjection(InvocationContext invocationContext, Object proxy, Object[] args) throws Throwable {
            assert (ReflectionHelper.hasParameters(this.method));
            Node node = this.getNodeForMethod(this.method, args);
            XPathExpression expression = invocationContext.getxPathExpression();
            Object valueToSet = args[this.findIndexOfValue];
            NodeList nodes = (NodeList)expression.evaluate(node, XPathConstants.NODESET);
            int count = nodes.getLength();
            for (int i = 0; i < count; ++i) {
                Node n = nodes.item(i);
                if (n == null) continue;
                if (2 == n.getNodeType()) {
                    Element e = ((Attr)n).getOwnerElement();
                    if (e == null) continue;
                    DOMHelper.setOrRemoveAttribute(e, n.getNodeName(), valueToSet == null ? null : valueToSet.toString());
                    continue;
                }
                if (valueToSet instanceof Element) {
                    if (!(n instanceof Element)) {
                        throw new IllegalArgumentException("XPath for element update need to select elements only");
                    }
                    DOMHelper.replaceElement((Element)n, (Element)((Element)valueToSet).cloneNode(true));
                    continue;
                }
                n.setTextContent(valueToSet == null ? null : valueToSet.toString());
            }
            return this.getProxyReturnValueForMethod(proxy, this.method, count);
        }
    }

    private static class ReadInvocationHandler
    extends XPathInvocationHandler {
        private final boolean absentIsEmpty;
        private final boolean wrappedInOptional;
        private final Class<?> returnType;
        private final Class<?> exceptionType;
        private final boolean isConvertable;
        private final boolean isReturnAsNode;
        private final boolean isEvaluateAsList;
        private final boolean isEvaluateAsArray;
        private final boolean isEvaluateAsSubProjection;
        private final boolean isThrowIfAbsent;

        ReadInvocationHandler(Node node, Method method, String annotationValue, XBProjector projector, boolean absentIsEmpty) {
            super(node, method, annotationValue, projector);
            this.wrappedInOptional = ReflectionHelper.isOptional(method.getGenericReturnType());
            this.returnType = this.wrappedInOptional ? ReflectionHelper.getParameterType(method.getGenericReturnType()) : method.getReturnType();
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            this.exceptionType = exceptionTypes.length > 0 ? exceptionTypes[0] : null;
            this.isConvertable = projector.config().getTypeConverter().isConvertable(this.returnType);
            this.isReturnAsNode = Node.class.isAssignableFrom(this.returnType);
            this.isEvaluateAsList = List.class.equals(this.returnType);
            this.isEvaluateAsArray = this.returnType.isArray();
            if (this.wrappedInOptional && (this.isEvaluateAsArray || this.isEvaluateAsList)) {
                throw new IllegalArgumentException("Method " + method + " must not declare an optional return type of list or array. Lists and arrays may be empty but will never be null.");
            }
            this.isEvaluateAsSubProjection = this.returnType.isInterface();
            this.isThrowIfAbsent = this.exceptionType != null;
            this.absentIsEmpty = absentIsEmpty && !this.isThrowIfAbsent;
        }

        @Override
        public Object invokeXpathProjection(InvocationContext invocationContext, Object proxy, Object[] args) throws Throwable {
            Object result = this.invokeReadProjection(invocationContext, proxy, args);
            if (result == null && this.isThrowIfAbsent) {
                XBDataNotFoundException dataNotFoundException = new XBDataNotFoundException(invocationContext.getResolvedXPath());
                if (XBDataNotFoundException.class.equals(this.exceptionType)) {
                    throw dataNotFoundException;
                }
                ReflectionHelper.throwThrowable(this.exceptionType, args, dataNotFoundException);
            }
            return result;
        }

        private Object invokeReadProjection(InvocationContext invocationContext, Object proxy, Object[] args) throws Throwable {
            Node node = this.getNodeForMethod(this.method, args);
            ExpressionType expressionType = invocationContext.getDuplexExpression().getExpressionType();
            XPathExpression expression = invocationContext.getxPathExpression();
            if (this.isConvertable) {
                String data;
                if (expressionType.isMustEvalAsString()) {
                    data = (String)expression.evaluate(node, XPathConstants.STRING);
                } else {
                    Node dataNode = (Node)expression.evaluate(node, XPathConstants.NODE);
                    String string = data = dataNode == null ? null : dataNode.getTextContent();
                }
                if (data == null && this.absentIsEmpty) {
                    data = "";
                }
                try {
                    Object result = this.projector.config().getTypeConverter().convertTo(this.returnType, data, invocationContext.getExpressionFormatPattern());
                    return this.wrappedInOptional ? ReflectionHelper.createOptional(result) : result;
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException(e.getMessage() + " XPath was:" + invocationContext.getResolvedXPath());
                }
            }
            if (this.isReturnAsNode) {
                Object result = expression.evaluate(node, XPathConstants.NODE);
                return this.wrappedInOptional ? ReflectionHelper.createOptional(result) : result;
            }
            if (this.isEvaluateAsList) {
                assert (!this.wrappedInOptional) : "Projection methods returning list will never return null";
                List<?> result = DefaultXPathEvaluator.evaluateAsList(expression, node, this.method, invocationContext);
                return result;
            }
            if (this.isEvaluateAsArray) {
                assert (!this.wrappedInOptional) : "Projection methods returning array will never return null";
                List<?> list = DefaultXPathEvaluator.evaluateAsList(expression, node, this.method, invocationContext);
                return list.toArray((Object[])Array.newInstance(this.returnType.getComponentType(), list.size()));
            }
            if (this.isEvaluateAsSubProjection) {
                Node newNode = (Node)expression.evaluate(node, XPathConstants.NODE);
                if (newNode == null) {
                    return this.wrappedInOptional ? ReflectionHelper.createOptional(null) : null;
                }
                XBProjector.InternalProjection subprojection = (XBProjector.InternalProjection)this.projector.projectDOMNode(newNode, this.returnType);
                return this.wrappedInOptional ? ReflectionHelper.createOptional(subprojection) : subprojection;
            }
            throw new IllegalArgumentException("Return type " + this.returnType + " of method " + this.method + " is not supported. Please change to an projection interface, a List, an Array or one of current type converters types:" + this.projector.config().getTypeConverter());
        }
    }

    private static abstract class XPathInvocationHandler
    extends ProjectionMethodInvocationHandler {
        private XPathInvocationHandler(Node node, Method method, String annotationValue, XBProjector projector) {
            super(node, method, annotationValue, projector);
        }

        @Override
        protected final Object invokeProjection(String resolvedXpath, Object proxy, Object[] args) throws Throwable {
            XPath xPath = this.projector.config().createXPath(DOMHelper.getOwnerDocumentFor(this.node));
            if (!this.lastInvocationContext.isStillValid(resolvedXpath)) {
                DuplexExpression duplexExpression = new DuplexXPathParser().compile(resolvedXpath);
                String strippedXPath = duplexExpression.getExpressionAsStringWithoutFormatPatterns();
                MethodParamVariableResolver resolver = null;
                if (duplexExpression.isUsingVariables()) {
                    XPathVariableResolver peviousResolver = xPath.getXPathVariableResolver();
                    resolver = new MethodParamVariableResolver(this.method, args, duplexExpression, this.projector.config().getStringRenderer(), peviousResolver);
                    xPath.setXPathVariableResolver(resolver);
                }
                XPathExpression xPathExpression = xPath.compile(strippedXPath);
                Class targetComponentType = ProjectionInvocationHandler.findTargetComponentType(this.method);
                this.lastInvocationContext = new InvocationContext(resolvedXpath, xPath, xPathExpression, duplexExpression, resolver, targetComponentType, this.projector);
            }
            this.lastInvocationContext.updateMethodArgs(args);
            return this.invokeXpathProjection(this.lastInvocationContext, proxy, args);
        }

        protected abstract Object invokeXpathProjection(InvocationContext var1, Object var2, Object[] var3) throws Throwable;
    }

    private static abstract class ProjectionMethodInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final InvocationContext EMPTY_INVOCATION_CONTEXT = new InvocationContext(null, null, null, null, null, null, null);
        protected final Method method;
        protected final String annotationValue;
        protected final XBProjector projector;
        protected final Node node;
        private final String docAnnotationValue;
        private final boolean isVoidMethod;
        protected InvocationContext lastInvocationContext = EMPTY_INVOCATION_CONTEXT;
        protected final Map<String, Integer> methodParameterIndexes;

        ProjectionMethodInvocationHandler(Node node, Method method, String annotationValue, XBProjector projector) {
            this.method = method;
            this.annotationValue = annotationValue;
            this.projector = projector;
            this.node = node;
            XBDocURL annotation = method.getAnnotation(XBDocURL.class);
            this.docAnnotationValue = annotation == null ? null : annotation.value();
            this.isVoidMethod = !ReflectionHelper.hasReturnType(method);
            this.methodParameterIndexes = ReflectionHelper.getMethodParameterIndexes(method);
        }

        protected Node getNodeForMethod(Method method, Object[] args) throws SAXException, IOException, ParserConfigurationException {
            if (this.docAnnotationValue != null) {
                String uri = this.projector.config().getExternalizer().resolveURL(this.docAnnotationValue, method, args);
                Map<String, String> requestParams = ((XBProjector.IOBuilder)this.projector.io()).filterRequestParamsFromParams(uri, args);
                uri = Preprocessor.applyParams(uri, this.methodParameterIndexes, args);
                Class<?> callerClass = null;
                if (IOHelper.isResourceProtocol(uri)) {
                    callerClass = ReflectionHelper.getCallerClass(8);
                }
                return IOHelper.getDocumentFromURL(this.projector.config().createDocumentBuilder(), uri, requestParams, method.getDeclaringClass(), callerClass);
            }
            return this.node;
        }

        protected String resolveXPath(Object[] args) {
            return Preprocessor.applyParams(this.projector.config().getExternalizer().resolveXPath(this.annotationValue, this.method, args), this.methodParameterIndexes, args);
        }

        protected Object getProxyReturnValueForMethod(Object proxy, Method method, Integer numberOfChanges) {
            if (this.isVoidMethod) {
                return null;
            }
            if (method.getReturnType().equals(method.getDeclaringClass())) {
                return proxy;
            }
            if (numberOfChanges != null && (method.getReturnType().isAssignableFrom(Integer.class) || method.getReturnType().isAssignableFrom(Integer.TYPE))) {
                return numberOfChanges;
            }
            throw new IllegalArgumentException("Method " + method + " has illegal return type \"" + method.getReturnType() + "\". I don't know what to return. I expected void or " + method.getDeclaringClass().getSimpleName());
        }

        protected abstract Object invokeProjection(String var1, Object var2, Object[] var3) throws Throwable;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String xPath = this.resolveXPath(args);
            String resolvedXpath = Preprocessor.applyParams(xPath, this.methodParameterIndexes, args);
            return this.invokeProjection(resolvedXpath, proxy, args);
        }
    }

    private static class MixinInvoker
    extends ReflectionInvoker {
        private final Class<?> projectionInterface;

        MixinInvoker(Object obj, Class<?> projectionInterface) {
            super(obj);
            this.projectionInterface = projectionInterface;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ProjectionInvocationHandler.injectMeAttribute((XBProjector.InternalProjection)proxy, this.obj, this.projectionInterface);
            try {
                return super.invoke(proxy, method, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause() == null ? e : e.getCause();
            }
        }
    }

    private static class ReflectionInvoker
    implements InvocationHandler,
    Serializable {
        protected final Object obj;

        ReflectionInvoker(Object obj) {
            this.obj = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.obj, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause() == null ? e : e.getCause();
            }
        }
    }
}

