/**
 *  Copyright 2014 Sven Ewald
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.xmlbeam.util.intern.duplex;

import org.xmlbeam.XBException;

/**
 * @author sven
 */
public class XBPathParsingException extends XBException {

    private static final long serialVersionUID = -4923686442969043087L;

    /** TODO:Refactor to absolute begin and end
     * @param string
     * @param beginLine
     * @param beginColumn
     * @param endColumn
     * @param endLine
     */
    public XBPathParsingException(final String string, final int beginLine, final int beginColumn, final int endColumn, final int endLine) {
        super(string + " in line " + beginLine + " col " + beginColumn + " to " + endColumn, null);
    }

}
