/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.types;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xmlbeam.exceptions.XBException;
import org.xmlbeam.types.DefaultTypeConverter;

class StringFactoryConversion<T>
extends DefaultTypeConverter.Conversion<T> {
    private static final long serialVersionUID = 5720231829193321892L;
    private final Method factory;

    StringFactoryConversion(Method factory, T defaultValue) {
        super(defaultValue);
        this.factory = factory;
    }

    @Override
    public T convert(String data) {
        try {
            return (T)this.factory.invoke(null, data);
        }
        catch (IllegalArgumentException e) {
            assert (false) : "Unreachable code";
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            assert (false) : "Unreachable code";
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new XBException("Exception while trying to invoke factory method " + this.factory.toGenericString(), e.getCause());
        }
    }

    @Override
    public T getDefaultValue(String value) {
        return this.convert(value);
    }
}

