/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.config;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlbeam.config.XMLFactoriesConfig;
import org.xmlbeam.exceptions.XBException;
import org.xmlbeam.util.UnionIterator;
import org.xmlbeam.util.intern.DOMHelper;

public class DefaultXMLFactoriesConfig
implements XMLFactoriesConfig {
    private static final String NON_EXISTING_URL = "http://xmlbeam.org/nonexisting_namespace";
    private boolean isExpandEntityReferences = false;
    private boolean isNoEntityResolving = true;
    private boolean isOmitXMLDeclaration = true;
    private boolean isPrettyPrinting = true;
    private boolean isXIncludeAware = false;
    private NamespacePhilosophy namespacePhilosophy = NamespacePhilosophy.HEDONISTIC;
    private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new StringReader(""));
    private static final EntityResolver NONRESOLVING_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return EMPTY_INPUT_SOURCE;
        }
    };
    private final Map<String, String> USER_DEFINED_MAPPING = new TreeMap<String, String>();

    @Override
    public DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilder documentBuilder = this.createDocumentBuilderFactory().newDocumentBuilder();
            if (this.isNoEntityResolving) {
                documentBuilder.setEntityResolver(NONRESOLVING_RESOLVER);
            }
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new XBException("Error on creating document builder", e);
        }
    }

    @Override
    public DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory instance = DocumentBuilderFactory.newInstance();
        instance.setXIncludeAware(this.isXIncludeAware);
        instance.setExpandEntityReferences(this.isExpandEntityReferences);
        if (!NamespacePhilosophy.AGNOSTIC.equals((Object)this.namespacePhilosophy)) {
            instance.setNamespaceAware(NamespacePhilosophy.HEDONISTIC.equals((Object)this.namespacePhilosophy));
        }
        return instance;
    }

    public NSMapping createNameSpaceMapping() {
        if (!NamespacePhilosophy.HEDONISTIC.equals((Object)this.namespacePhilosophy)) {
            throw new IllegalStateException("To use a namespace mapping, you need to use the HEDONISTIC NamespacePhilosophy.");
        }
        return new NSMapping(){

            @Override
            public NSMapping add(String prefix, String uri) {
                if (prefix == null || prefix.isEmpty()) {
                    throw new IllegalArgumentException("prefix must not be empty");
                }
                if (uri == null || uri.isEmpty()) {
                    throw new IllegalArgumentException("uri must not be empty");
                }
                if (DefaultXMLFactoriesConfig.this.USER_DEFINED_MAPPING.containsKey(prefix) && !uri.equals(DefaultXMLFactoriesConfig.this.USER_DEFINED_MAPPING.get(prefix))) {
                    throw new IllegalArgumentException("The prefix '" + prefix + "' is bound to namespace '" + (String)DefaultXMLFactoriesConfig.this.USER_DEFINED_MAPPING.get(prefix) + " already.");
                }
                DefaultXMLFactoriesConfig.this.USER_DEFINED_MAPPING.put(prefix, uri);
                return this;
            }

            @Override
            public NSMapping addDefaultNamespace(String uri) {
                return this.add("xbdefaultns", uri);
            }
        };
    }

    @Override
    public Transformer createTransformer(Document ... document) {
        try {
            Transformer transformer = this.createTransformerFactory().newTransformer();
            if (this.isPrettyPrinting()) {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.setOutputProperty("indent", "yes");
            }
            if (this.isOmitXMLDeclaration()) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new XBException("Error on creating transformer", e);
        }
    }

    @Override
    public TransformerFactory createTransformerFactory() {
        return TransformerFactory.newInstance();
    }

    @Override
    public XPath createXPath(Document ... document) {
        XPath xPath = this.createXPathFactory().newXPath();
        if (document == null || document.length == 0 || !NamespacePhilosophy.HEDONISTIC.equals((Object)this.namespacePhilosophy)) {
            return xPath;
        }
        final Map<String, String> nameSpaceMapping = DOMHelper.getNamespaceMapping(document[0]);
        NamespaceContext ctx = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new IllegalArgumentException("null not allowed as prefix");
                }
                if (nameSpaceMapping.containsKey(prefix)) {
                    return (String)nameSpaceMapping.get(prefix);
                }
                if (DefaultXMLFactoriesConfig.this.USER_DEFINED_MAPPING.containsKey(prefix)) {
                    return (String)DefaultXMLFactoriesConfig.this.USER_DEFINED_MAPPING.get(prefix);
                }
                return DefaultXMLFactoriesConfig.NON_EXISTING_URL;
            }

            @Override
            public String getPrefix(String uri) {
                for (Map.Entry e : nameSpaceMapping.entrySet()) {
                    if (!((String)e.getValue()).equals(uri)) continue;
                    return (String)e.getKey();
                }
                for (Map.Entry e : DefaultXMLFactoriesConfig.this.USER_DEFINED_MAPPING.entrySet()) {
                    if (!((String)e.getValue()).equals(uri)) continue;
                    return (String)e.getKey();
                }
                return null;
            }

            @Override
            public Iterator<String> getPrefixes(String val) {
                return new UnionIterator<String>(nameSpaceMapping.keySet().iterator(), DefaultXMLFactoriesConfig.this.USER_DEFINED_MAPPING.keySet().iterator());
            }
        };
        xPath.setNamespaceContext(ctx);
        return xPath;
    }

    @Override
    public XPathFactory createXPathFactory() {
        return XPathFactory.newInstance();
    }

    public NamespacePhilosophy getNamespacePhilosophy() {
        return this.namespacePhilosophy;
    }

    @Override
    public Map<String, String> getUserDefinedNamespaceMapping() {
        return Collections.unmodifiableMap(this.USER_DEFINED_MAPPING);
    }

    public boolean isExpandEntityReferences() {
        return this.isExpandEntityReferences;
    }

    public boolean isNoEntityResolving() {
        return this.isNoEntityResolving;
    }

    public boolean isOmitXMLDeclaration() {
        return this.isOmitXMLDeclaration;
    }

    public boolean isPrettyPrinting() {
        return this.isPrettyPrinting;
    }

    public boolean isXIncludeAware() {
        return this.isXIncludeAware;
    }

    public void setExpandEntityReferences(boolean isExpandEntityReferences) {
        this.isExpandEntityReferences = isExpandEntityReferences;
    }

    public XMLFactoriesConfig setNamespacePhilosophy(NamespacePhilosophy namespacePhilosophy) {
        this.namespacePhilosophy = namespacePhilosophy;
        return this;
    }

    public void setNoEntityResolving(boolean isNoEntityResolving) {
        this.isNoEntityResolving = isNoEntityResolving;
    }

    public DefaultXMLFactoriesConfig setOmitXMLDeclaration(boolean isOmitXMLDeclaration) {
        this.isOmitXMLDeclaration = isOmitXMLDeclaration;
        return this;
    }

    public DefaultXMLFactoriesConfig setPrettyPrinting(boolean on) {
        this.isPrettyPrinting = on;
        return this;
    }

    public void setXIncludeAware(boolean isXIncludeAware) {
        this.isXIncludeAware = isXIncludeAware;
    }

    public static interface NSMapping {
        public NSMapping add(String var1, String var2);

        public NSMapping addDefaultNamespace(String var1);
    }

    public static enum NamespacePhilosophy {
        AGNOSTIC,
        HEDONISTIC,
        NIHILISTIC;

    }
}

