/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;

class MethodSignature
implements Serializable {
    private final Class<?>[] paramTypes;
    private final String name;

    public String toString() {
        return "MethodSignature [name=" + this.name + ", paramTypes=" + Arrays.toString(this.paramTypes) + "]";
    }

    public static MethodSignature forVoidMethod(String name) {
        return new MethodSignature(name, new Class[0]);
    }

    public static MethodSignature forSingleParam(String name, Class<?> singleParam) {
        return new MethodSignature(name, new Class[]{singleParam});
    }

    private MethodSignature(Method method) {
        this.name = method.getName();
        this.paramTypes = method.getParameterTypes();
    }

    private MethodSignature(String name, Class<?>[] paramTypes) {
        this.paramTypes = paramTypes;
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.paramTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignature other = (MethodSignature)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Arrays.equals(this.paramTypes, other.paramTypes);
    }

    public static MethodSignature forMethod(Method m) {
        return new MethodSignature(m);
    }

    public MethodSignature overridenBy(String name) {
        return new MethodSignature(name, this.paramTypes);
    }
}

