/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.evaluation;

import java.awt.geom.IllegalPathStateException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlbeam.AutoMap;
import org.xmlbeam.XBProjector;
import org.xmlbeam.evaluation.DocumentResolver;
import org.xmlbeam.evaluation.InvocationContext;
import org.xmlbeam.evaluation.XPathEvaluator;
import org.xmlbeam.exceptions.XBPathException;
import org.xmlbeam.types.TypeConverter;
import org.xmlbeam.types.XBAutoMap;
import org.xmlbeam.util.intern.DOMHelper;
import org.xmlbeam.util.intern.ReflectionHelper;
import org.xmlbeam.util.intern.duplex.DuplexExpression;
import org.xmlbeam.util.intern.duplex.DuplexXPathParser;

public final class DefaultXPathEvaluator
implements XPathEvaluator {
    private final DocumentResolver documentProvider;
    private final DuplexExpression duplexExpression;
    private final XBProjector projector;

    public DefaultXPathEvaluator(XBProjector projector, DocumentResolver documentProvider, String xpath) {
        this.projector = projector;
        this.documentProvider = documentProvider;
        this.duplexExpression = new DuplexXPathParser(projector.config().getUserDefinedNamespaceMapping()).compile(xpath);
    }

    @Override
    public boolean asBoolean() {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.evaluateSingeValue(Boolean.TYPE, callerClass);
    }

    @Override
    public int asInt() {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.evaluateSingeValue(Integer.TYPE, callerClass);
    }

    @Override
    public String asString() {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.evaluateSingeValue(String.class, callerClass);
    }

    @Override
    public Date asDate() {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.evaluateSingeValue(Date.class, callerClass);
    }

    @Override
    public <T> T as(Class<T> returnType) {
        this.validateEvaluationType(returnType);
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.evaluateSingeValue(returnType, callerClass);
    }

    private <T> T evaluateSingeValue(Class<T> returnType, Class<?> callerClass) {
        try {
            Document document = this.documentProvider.resolve(returnType, callerClass);
            XPathExpression expression = this.projector.config().createXPath(document).compile(this.duplexExpression.getExpressionAsStringWithoutFormatPatterns());
            if (this.projector.config().getTypeConverter().isConvertable(returnType)) {
                String data;
                if (this.duplexExpression.getExpressionType().isMustEvalAsString()) {
                    data = (String)expression.evaluate(document, XPathConstants.STRING);
                } else {
                    Node dataNode = (Node)expression.evaluate(document, XPathConstants.NODE);
                    String string = data = dataNode == null ? null : dataNode.getTextContent();
                }
                if (data == null && this.projector.getFlags().contains((Object)XBProjector.Flags.ABSENT_IS_EMPTY)) {
                    data = "";
                }
                T result = this.projector.config().getTypeConverter().convertTo(returnType, data, this.duplexExpression.getExpressionFormatPattern());
                return result;
            }
            if (Node.class.isAssignableFrom(returnType)) {
                Object result = expression.evaluate(document, XPathConstants.NODE);
                return (T)result;
            }
            if (returnType.isInterface()) {
                Node node = (Node)expression.evaluate(document, XPathConstants.NODE);
                if (node == null) {
                    return null;
                }
                return this.projector.projectDOMNode(node, returnType);
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalPathStateException();
    }

    private <T> void validateEvaluationType(Class<T> returnType) {
        if (ReflectionHelper.isOptional(returnType)) {
            throw new IllegalArgumentException("Type Optional is only allowed as a method return type.");
        }
        if (Collection.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("A collection type can not be component type.");
        }
    }

    @Override
    public <T> T[] asArrayOf(Class<T> componentType) {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        List<Object> list = this.evaluateMultiValues(componentType, callerClass);
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    @Override
    public <T> List<T> asListOf(Class<T> componentType) {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.evaluateMultiValues(componentType, callerClass);
    }

    private <T> List<T> evaluateMultiValues(Class<T> componentType, Class<?> callerClass) {
        this.validateEvaluationType(componentType);
        try {
            Document document = this.documentProvider.resolve(componentType, callerClass);
            XPathExpression expression = this.projector.config().createXPath(document).compile(this.duplexExpression.getExpressionAsStringWithoutFormatPatterns());
            InvocationContext invocationContext = new InvocationContext(null, null, expression, this.duplexExpression, null, componentType, this.projector);
            return DefaultXPathEvaluator.evaluateAsList(expression, document, null, invocationContext);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<?> evaluateAsList(XPathExpression expression, Node node, Method method, InvocationContext invocationContext) throws XPathExpressionException {
        Class<?> targetComponentType = invocationContext.getTargetComponentType();
        NodeList nodes = (NodeList)expression.evaluate(node, XPathConstants.NODESET);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        TypeConverter typeConverter = invocationContext.getProjector().config().getTypeConverter();
        if (typeConverter.isConvertable(targetComponentType)) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                linkedList.add(typeConverter.convertTo(targetComponentType, nodes.item(i).getTextContent(), invocationContext.getExpressionFormatPattern()));
            }
            return linkedList;
        }
        if (Node.class.equals(targetComponentType)) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                linkedList.add(nodes.item(i));
            }
            return linkedList;
        }
        if (targetComponentType.isInterface()) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Object subprojection = invocationContext.getProjector().projectDOMNode(nodes.item(i), targetComponentType);
                linkedList.add(subprojection);
            }
            return linkedList;
        }
        throw new IllegalArgumentException("Return type " + targetComponentType + " is not valid for list or array component type returning from method " + method + " using the current type converter:" + invocationContext.getProjector().config().getTypeConverter() + ". Please change the return type to a sub projection or add a conversion to the type converter.");
    }

    public static <E> E convertToComponentType(InvocationContext invocationContext, Node item, Class<?> targetComponentType) {
        TypeConverter typeConverter = invocationContext.getProjector().config().getTypeConverter();
        if (typeConverter.isConvertable(invocationContext.getTargetComponentType())) {
            return (E)typeConverter.convertTo(targetComponentType, item != null ? DOMHelper.directTextContent(item) : null, invocationContext.getExpressionFormatPattern());
        }
        if (Node.class.equals(targetComponentType)) {
            return (E)item;
        }
        if (targetComponentType.isInterface()) {
            if (item == null) {
                return null;
            }
            Object subprojection = invocationContext.getProjector().projectDOMNode(item, targetComponentType);
            return (E)subprojection;
        }
        throw new IllegalArgumentException("Return type " + targetComponentType + " is not valid for a ProjectedList using the current type converter:" + invocationContext.getProjector().config().getTypeConverter() + ". Please change the return type to a sub projection or add a conversion to the type converter.");
    }

    @Override
    public <T> XBAutoMap<T> asMapOf(Class<T> componentType) {
        try {
            Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
            Document document = this.documentProvider.resolve(componentType, callerClass);
            String resolvedXPath = this.duplexExpression.getExpressionAsStringWithoutFormatPatterns();
            XPath xpath = this.projector.config().createXPath(document);
            XPathExpression expression = xpath.compile(resolvedXPath);
            InvocationContext invocationContext = new InvocationContext(resolvedXPath, xpath, expression, this.duplexExpression, null, componentType, this.projector);
            return new AutoMap(document, invocationContext, componentType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XPathExpressionException e) {
            throw new XBPathException(e, this.duplexExpression.getExpressionAsStringWithoutFormatPatterns());
        }
    }
}

