/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.http.servlet;

import java.util.LinkedHashMap;
import java.util.Map;

class SimpleLruCache<K, V> {
    private final LinkedHashMap<K, V> map;
    private int size;
    private int maxSize;
    private int putCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    SimpleLruCache(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("maxSize must not be less than 1");
        }
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V get(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        SimpleLruCache simpleLruCache = this;
        synchronized (simpleLruCache) {
            V mapValue = this.map.get(key);
            if (mapValue != null) {
                ++this.hitCount;
                return mapValue;
            }
            ++this.missCount;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V put(K key, V value) {
        V previous;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        SimpleLruCache simpleLruCache = this;
        synchronized (simpleLruCache) {
            ++this.putCount;
            ++this.size;
            previous = this.map.put(key, value);
            if (previous != null) {
                --this.size;
            }
        }
        this.trimToSize(this.maxSize);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int maxSize) {
        while (true) {
            SimpleLruCache simpleLruCache = this;
            synchronized (simpleLruCache) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.map.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> toEvict = this.map.entrySet().iterator().next();
                K key = toEvict.getKey();
                this.map.remove(key);
                --this.size;
                ++this.evictionCount;
            }
        }
    }

    public final synchronized String toString() {
        int accesses = this.hitCount + this.missCount;
        int hitPercent = accesses == 0 ? 0 : 100 * this.hitCount / accesses;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.maxSize, this.hitCount, this.missCount, hitPercent);
    }
}

