/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.security.exception.BadAsn1ObjectException;

public class Asn1Util {
    private Asn1Util() {
    }

    public static void requireRange(ASN1Sequence seq, int minSize, int maxSize) throws BadAsn1ObjectException {
        int size = seq.size();
        if (size < minSize || size > maxSize) {
            String msg = String.format("seq.size() must not be out of the range [%d, %d]: %d", minSize, maxSize, size);
            throw new IllegalArgumentException(msg);
        }
    }

    public static ASN1Sequence getSequence(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return ASN1Sequence.getInstance((Object)object);
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object Sequence: " + ex.getMessage(), ex);
        }
    }

    public static Certificate getCertificate(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return Certificate.getInstance((Object)object);
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object Certificate: " + ex.getMessage(), ex);
        }
    }

    public static BigInteger getInteger(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return ASN1Integer.getInstance((Object)object).getValue();
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object ASN1Integer: " + ex.getMessage(), ex);
        }
    }

    public static String getUtf8String(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return DERUTF8String.getInstance((Object)object).getString();
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object UTF8String: " + ex.getMessage(), ex);
        }
    }

    public static byte[] getOctetStringBytes(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return DEROctetString.getInstance((Object)object).getOctets();
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object OctetString: " + ex.getMessage(), ex);
        }
    }

    public static ASN1ObjectIdentifier getObjectIdentifier(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return ASN1ObjectIdentifier.getInstance((Object)object);
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object ObjectIdentifier: " + ex.getMessage(), ex);
        }
    }
}

