/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11RSAPkcsPssParams;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1RSAPkcsPssParams
extends ASN1Object {
    private final P11RSAPkcsPssParams pkcsPssParams;

    public Asn1RSAPkcsPssParams(P11RSAPkcsPssParams pkcsPssParams) {
        this.pkcsPssParams = (P11RSAPkcsPssParams)ParamUtil.requireNonNull((String)"pkcsPssParams", (Object)pkcsPssParams);
    }

    private Asn1RSAPkcsPssParams(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 3, 3);
        int idx = 0;
        long contentHash = Asn1Util.getInteger(seq.getObjectAt(idx++)).longValue();
        long mgfHash = Asn1Util.getInteger(seq.getObjectAt(idx++)).longValue();
        int saltLength = Asn1Util.getInteger(seq.getObjectAt(idx++)).intValue();
        this.pkcsPssParams = new P11RSAPkcsPssParams(contentHash, mgfHash, saltLength);
    }

    public static Asn1RSAPkcsPssParams getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1RSAPkcsPssParams) {
            return (Asn1RSAPkcsPssParams)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1RSAPkcsPssParams((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1RSAPkcsPssParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(this.pkcsPssParams.hashAlgorithm()));
        vector.add((ASN1Encodable)new ASN1Integer(this.pkcsPssParams.maskGenerationFunction()));
        vector.add((ASN1Encodable)new ASN1Integer(this.pkcsPssParams.saltLength()));
        return new DERSequence(vector);
    }

    public P11RSAPkcsPssParams pkcsPssParams() {
        return this.pkcsPssParams;
    }
}

