/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11Params;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1Mechanism
extends ASN1Object {
    private final long mechanism;
    private final Asn1P11Params params;

    public Asn1Mechanism(long mechanism, Asn1P11Params params) {
        this.mechanism = mechanism;
        this.params = params;
    }

    private Asn1Mechanism(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 1, 2);
        int size = seq.size();
        int idx = 0;
        this.mechanism = Asn1Util.getInteger(seq.getObjectAt(idx++)).longValue();
        this.params = size > 1 ? Asn1P11Params.getInstance(seq.getObjectAt(idx++)) : null;
    }

    public static Asn1Mechanism getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1Mechanism) {
            return (Asn1Mechanism)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1Mechanism((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1Mechanism.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(this.mechanism));
        if (this.params != null) {
            vector.add((ASN1Encodable)this.params);
        }
        return new DERSequence(vector);
    }

    public long mechanism() {
        return this.mechanism;
    }

    public Asn1P11Params params() {
        return this.params;
    }
}

