/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11NewKeyControl;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1NewKeyControl;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1GenECKeypairParams
extends ASN1Object {
    private final P11SlotIdentifier slotId;
    private final String label;
    private final P11NewKeyControl control;
    private final ASN1ObjectIdentifier curveId;

    public Asn1GenECKeypairParams(P11SlotIdentifier slotId, String label, P11NewKeyControl control, ASN1ObjectIdentifier curveId) {
        this.slotId = (P11SlotIdentifier)ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        this.label = ParamUtil.requireNonBlank((String)"label", (String)label);
        this.control = (P11NewKeyControl)ParamUtil.requireNonNull((String)"control", (Object)control);
        this.curveId = (ASN1ObjectIdentifier)ParamUtil.requireNonNull((String)"curveId", (Object)curveId);
    }

    private Asn1GenECKeypairParams(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 4, 4);
        int idx = 0;
        this.slotId = Asn1P11SlotIdentifier.getInstance(seq.getObjectAt(idx++)).slotId();
        this.label = Asn1Util.getUtf8String(seq.getObjectAt(idx++));
        this.control = Asn1NewKeyControl.getInstance(seq.getObjectAt(idx++)).control();
        this.curveId = Asn1Util.getObjectIdentifier(seq.getObjectAt(idx++));
    }

    public static Asn1GenECKeypairParams getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1GenECKeypairParams) {
            return (Asn1GenECKeypairParams)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1GenECKeypairParams((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1GenECKeypairParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new Asn1P11SlotIdentifier(this.slotId));
        vector.add((ASN1Encodable)new DERUTF8String(this.label));
        vector.add((ASN1Encodable)this.curveId);
        return new DERSequence(vector);
    }

    public P11SlotIdentifier slotId() {
        return this.slotId;
    }

    public String label() {
        return this.label;
    }

    public P11NewKeyControl control() {
        return this.control;
    }

    public ASN1ObjectIdentifier curveId() {
        return this.curveId;
    }
}

