/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.proxy.msg.Asn1Mechanism;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11EntityIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1DigestSecretKeyTemplate
extends ASN1Object {
    private final Asn1P11EntityIdentifier identityId;
    private final Asn1Mechanism mechanism;

    private Asn1DigestSecretKeyTemplate(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 2, 2);
        int idx = 0;
        this.identityId = Asn1P11EntityIdentifier.getInstance(seq.getObjectAt(idx++));
        this.mechanism = Asn1Mechanism.getInstance(seq.getObjectAt(idx++));
    }

    public Asn1DigestSecretKeyTemplate(Asn1P11EntityIdentifier identityId, long mechanism) {
        this.identityId = (Asn1P11EntityIdentifier)((Object)ParamUtil.requireNonNull((String)"identityId", (Object)((Object)identityId)));
        this.mechanism = new Asn1Mechanism(mechanism, null);
    }

    public static Asn1DigestSecretKeyTemplate getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1DigestSecretKeyTemplate) {
            return (Asn1DigestSecretKeyTemplate)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1DigestSecretKeyTemplate((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1DigestSecretKeyTemplate.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.identityId);
        vector.add((ASN1Encodable)this.mechanism);
        return new DERSequence(vector);
    }

    public Asn1P11EntityIdentifier identityId() {
        return this.identityId;
    }

    public Asn1Mechanism mechanism() {
        return this.mechanism;
    }
}

