/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.util.Arrays;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11NewKeyControl;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1NewKeyControl;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1CreateSecretKeyParams
extends ASN1Object {
    private final P11SlotIdentifier slotId;
    private final String label;
    private final P11NewKeyControl control;
    private final long keyType;
    private final byte[] keyValue;

    public Asn1CreateSecretKeyParams(P11SlotIdentifier slotId, String label, P11NewKeyControl control, long keyType, byte[] keyValue) {
        this.slotId = (P11SlotIdentifier)ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        this.label = ParamUtil.requireNonBlank((String)"label", (String)label);
        this.control = (P11NewKeyControl)ParamUtil.requireNonNull((String)"control", (Object)control);
        this.keyType = keyType;
        this.keyValue = (byte[])ParamUtil.requireNonNull((String)"keyValue", (Object)keyValue);
    }

    private Asn1CreateSecretKeyParams(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 5, 5);
        int idx = 0;
        this.slotId = Asn1P11SlotIdentifier.getInstance(seq.getObjectAt(idx++)).slotId();
        this.label = Asn1Util.getUtf8String(seq.getObjectAt(idx++));
        this.control = Asn1NewKeyControl.getInstance(seq.getObjectAt(idx++)).control();
        this.keyType = Asn1Util.getInteger(seq.getObjectAt(idx++)).longValue();
        this.keyValue = ASN1OctetString.getInstance((Object)seq.getObjectAt(idx++)).getOctets();
    }

    public static Asn1CreateSecretKeyParams getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1CreateSecretKeyParams) {
            return (Asn1CreateSecretKeyParams)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1CreateSecretKeyParams((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1CreateSecretKeyParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new Asn1P11SlotIdentifier(this.slotId));
        vector.add((ASN1Encodable)new DERUTF8String(this.label));
        vector.add((ASN1Encodable)new ASN1Integer(this.keyType));
        vector.add((ASN1Encodable)new DEROctetString(this.keyValue));
        return new DERSequence(vector);
    }

    public P11SlotIdentifier slotId() {
        return this.slotId;
    }

    public String label() {
        return this.label;
    }

    public P11NewKeyControl control() {
        return this.control;
    }

    public long keyType() {
        return this.keyType;
    }

    public byte[] keyValue() {
        return Arrays.copyOf((byte[])this.keyValue, (int)this.keyValue.length);
    }
}

