/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import org.xipki.security.pkcs11.provider.P11DSASignatureSpi;
import org.xipki.security.pkcs11.provider.P11ECDSASignatureSpi;
import org.xipki.security.pkcs11.provider.P11PlainECDSASignatureSpi;
import org.xipki.security.pkcs11.provider.P11RSADigestSignatureSpi;
import org.xipki.security.pkcs11.provider.P11RSAPSSSignatureSpi;
import org.xipki.security.pkcs11.provider.XipkiKeyStoreSpi;

public class XipkiProvider
extends Provider {
    public static final String PROVIDER_NAME = "XiPKI";
    public static final double PROVIDER_VERSION = 1.0;
    private static final String PROVIDER_INFO = "XiPKI JCA/JCE provider";
    private static final long serialVersionUID = 1L;

    public XipkiProvider() {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        AccessController.doPrivileged(new MyPrivilegedAction(this));
    }

    private static class MyPrivilegedAction
    implements PrivilegedAction {
        private final XipkiProvider provider;

        MyPrivilegedAction(XipkiProvider provider) {
            this.provider = provider;
        }

        public Object run() {
            this.provider.put("KeyStore.PKCS11", XipkiKeyStoreSpi.class.getName());
            this.provider.put("Signature.NONEwithRSA", P11RSADigestSignatureSpi.NoneRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithNONE", "NONEwithRSA");
            this.provider.put("Signature.SHA1withRSA", P11RSADigestSignatureSpi.SHA1.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithSHA1", "SHA1withRSA");
            this.provider.put("Signature.SHA224withRSA", P11RSADigestSignatureSpi.SHA224.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithSHA224", "SHA224withRSA");
            this.provider.put("Signature.SHA256withRSA", P11RSADigestSignatureSpi.SHA256.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithSHA256", "SHA256withRSA");
            this.provider.put("Signature.SHA384withRSA", P11RSADigestSignatureSpi.SHA384.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithSHA384", "SHA384withRSA");
            this.provider.put("Signature.SHA512withRSA", P11RSADigestSignatureSpi.SHA512.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithSHA512", "SHA512withRSA");
            this.provider.put("Signature.SHA3-224withRSA", P11RSADigestSignatureSpi.SHA3_224.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithSHA3-224", "SHA3-224withRSA");
            this.provider.put("Signature.SHA3-256withRSA", P11RSADigestSignatureSpi.SHA3_256.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithSHA3-256", "SHA3-256withRSA");
            this.provider.put("Signature.SHA3-384withRSA", P11RSADigestSignatureSpi.SHA3_384.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithSHA3-384", "SHA3-384withRSA");
            this.provider.put("Signature.SHA3-512withRSA", P11RSADigestSignatureSpi.SHA3_512.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAwithSHA3-512", "SHA3-512withRSA");
            this.provider.put("Signature.NONEwithDSA", P11DSASignatureSpi.NONE.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithNONE", "NONEwithDSA");
            this.provider.put("Signature.SHA1withDSA", P11DSASignatureSpi.SHA1.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithSHA1", "SHA1withDSA");
            this.provider.put("Signature.SHA224withDSA", P11DSASignatureSpi.SHA224.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithSHA224", "SHA224withDSA");
            this.provider.put("Signature.SHA256withDSA", P11DSASignatureSpi.SHA256.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithSHA256", "SHA256withDSA");
            this.provider.put("Signature.SHA384withDSA", P11DSASignatureSpi.SHA384.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithSHA384", "SHA384withDSA");
            this.provider.put("Signature.SHA512withDSA", P11DSASignatureSpi.SHA512.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithSHA512", "SHA512withDSA");
            this.provider.put("Signature.SHA3-224withDSA", P11DSASignatureSpi.SHA3_224.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithSHA3-224", "SHA3-224withDSA");
            this.provider.put("Signature.SHA3-256withDSA", P11DSASignatureSpi.SHA3_256.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithSHA3-256", "SHA3-256withDSA");
            this.provider.put("Signature.SHA3-384withDSA", P11DSASignatureSpi.SHA3_384.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithSHA3-384", "SHA3-384withDSA");
            this.provider.put("Signature.SHA3-512withDSA", P11DSASignatureSpi.SHA3_512.class.getName());
            this.provider.put("Alg.Alias.Signature.DSAwithSHA3-512", "SHA3-512withDSA");
            this.provider.put("Signature.NONEwithECDSA", P11ECDSASignatureSpi.NONE.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithNONE", "NONEwithECDSA");
            this.provider.put("Signature.SHA1withECDSA", P11ECDSASignatureSpi.SHA1.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithSHA1", "SHA1withECDSA");
            this.provider.put("Signature.SHA224withECDSA", P11ECDSASignatureSpi.SHA224.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithSHA224", "SHA224withECDSA");
            this.provider.put("Signature.SHA256withECDSA", P11ECDSASignatureSpi.SHA256.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithSHA256", "SHA256withECDSA");
            this.provider.put("Signature.SHA384withECDSA", P11ECDSASignatureSpi.SHA384.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithSHA384", "SHA384withECDSA");
            this.provider.put("Signature.SHA512withECDSA", P11ECDSASignatureSpi.SHA512.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithSHA512", "SHA512withECDSA");
            this.provider.put("Signature.SHA3-224withECDSA", P11ECDSASignatureSpi.SHA3_224.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithSHA3-224", "SHA3-224withECDSA");
            this.provider.put("Signature.SHA3-256withECDSA", P11ECDSASignatureSpi.SHA3_256.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithSHA3-256", "SHA3-256withECDSA");
            this.provider.put("Signature.SHA3-384withECDSA", P11ECDSASignatureSpi.SHA3_384.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithSHA3-384", "SHA3-384withECDSA");
            this.provider.put("Signature.SHA3-512withECDSA", P11ECDSASignatureSpi.SHA3_512.class.getName());
            this.provider.put("Alg.Alias.Signature.ECDSAwithSHA3-512", "SHA3-512withECDSA");
            this.provider.put("Signature.NONEwithPlain-ECDSA", P11PlainECDSASignatureSpi.NONE.class.getName());
            this.provider.put("Alg.Alias.Signature.Plain-ECDSAwithNONE", "NONEwithPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.NONEwithPlainECDSA", "NONEwithPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.PlainECDSAwithNONE", "NONEwithPlain-ECDSA");
            this.provider.put("Signature.SHA1withPlain-ECDSA", P11PlainECDSASignatureSpi.SHA1.class.getName());
            this.provider.put("Alg.Alias.Signature.Plain-ECDSAwithSHA1", "SHA1withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.SHAwithPlainECDSA1", "SHA1withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.PlainECDSAwithSHA1", "SHA1withPlain-ECDSA");
            this.provider.put("Signature.SHA224withPlain-ECDSA", P11PlainECDSASignatureSpi.SHA224.class.getName());
            this.provider.put("Alg.Alias.Signature.Plain-ECDSAwithSHA224", "SHA224withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.SHA224withPlainECDSA", "SHA224withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.PlainECDSAwithSHA224", "SHA224withPlain-ECDSA");
            this.provider.put("Signature.SHA256withPlain-ECDSA", P11PlainECDSASignatureSpi.SHA256.class.getName());
            this.provider.put("Alg.Alias.Signature.Plain-ECDSAwithSHA256", "SHA256withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.SHA256withPlainECDSA", "SHA256withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.PlainECDSAwithSHA256", "SHA256withPlain-ECDSA");
            this.provider.put("Signature.SHA384withPlain-ECDSA", P11PlainECDSASignatureSpi.SHA384.class.getName());
            this.provider.put("Alg.Alias.Signature.Plain-ECDSAwithSHA384", "SHA384withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.SHA384withPlainECDSA", "SHA384withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.PlainECDSAwithSHA384", "SHA384withPlain-ECDSA");
            this.provider.put("Signature.SHA512withPlain-ECDSA", P11PlainECDSASignatureSpi.SHA512.class.getName());
            this.provider.put("Alg.Alias.Signature.Plain-ECDSAwithSHA512", "SHA512withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.SHA512withPlainECDSA", "SHA512withPlain-ECDSA");
            this.provider.put("Alg.Alias.Signature.PlainECDSAwithSHA512", "SHA512withPlain-ECDSA");
            this.provider.put("Signature.SHA1withRSAandMGF1", P11RSAPSSSignatureSpi.SHA1withRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAandMGF1withSHA1", "SHA1withRSAandMGF1");
            this.provider.put("Signature.SHA224withRSAandMGF1", P11RSAPSSSignatureSpi.SHA224withRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAandMGF1withSHA224", "SHA224withRSAandMGF1");
            this.provider.put("Signature.SHA256withRSAandMGF1", P11RSAPSSSignatureSpi.SHA256withRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAandMGF1withSHA256", "SHA256withRSAandMGF1");
            this.provider.put("Signature.SHA384withRSAandMGF1", P11RSAPSSSignatureSpi.SHA384withRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAandMGF1withSHA384", "SHA384withRSAandMGF1");
            this.provider.put("Signature.SHA512withRSAandMGF1", P11RSAPSSSignatureSpi.SHA512withRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAandMGF1withSHA512", "SHA512withRSAandMGF1");
            this.provider.put("Signature.SHA3-224withRSAandMGF1", P11RSAPSSSignatureSpi.SHA3_224withRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAandMGF1withSHA3-224", "SHA3-224withRSAandMGF1");
            this.provider.put("Signature.SHA3-256withRSAandMGF1", P11RSAPSSSignatureSpi.SHA3_256withRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAandMGF1withSHA3-256", "SHA3-256withRSAandMGF1");
            this.provider.put("Signature.SHA3-384withRSAandMGF1", P11RSAPSSSignatureSpi.SHA3_384withRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAandMGF1withSHA3-384", "SHA3-384withRSAandMGF1");
            this.provider.put("Signature.SHA3-512withRSAandMGF1", P11RSAPSSSignatureSpi.SHA3_512withRSA.class.getName());
            this.provider.put("Alg.Alias.Signature.RSAandMGF1withSHA3-512", "SHA3-512withRSAandMGF1");
            return null;
        }
    }
}

