/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.provider.P11PrivateKey;

public class XipkiKeyStoreSpi
extends KeyStoreSpi {
    private static final Logger LOG = LoggerFactory.getLogger(XipkiKeyStoreSpi.class);
    private static P11CryptServiceFactory p11CryptServiceFactory;
    private Date creationDate;
    private Map<String, KeyCertEntry> keyCerts = new HashMap<String, KeyCertEntry>();

    public static void setP11CryptServiceFactory(P11CryptServiceFactory service) {
        p11CryptServiceFactory = service;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.creationDate = new Date();
        Set<String> moduleNames = p11CryptServiceFactory.moduleNames();
        for (String moduleName : moduleNames) {
            try {
                this.engineLoad(moduleName);
            }
            catch (P11TokenException | XiSecurityException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not load PKCS#11 module " + moduleName));
            }
        }
        if (LOG.isErrorEnabled()) {
            LOG.info("loaded key entries {}", this.keyCerts.keySet());
        }
    }

    private void engineLoad(String moduleName) throws P11TokenException, XiSecurityException {
        P11CryptService p11Service = p11CryptServiceFactory.getP11CryptService(moduleName);
        P11Module module = p11Service.module();
        List<P11SlotIdentifier> slotIds = module.slotIdentifiers();
        for (P11SlotIdentifier slotId : slotIds) {
            P11Slot slot = module.getSlot(slotId);
            Set<P11ObjectIdentifier> identityIds = slot.identityIdentifiers();
            for (P11ObjectIdentifier objId : identityIds) {
                P11Identity identity = slot.getIdentity(objId);
                Certificate[] chain = identity.certificateChain();
                if (chain == null || chain.length == 0) continue;
                P11PrivateKey key = new P11PrivateKey(p11Service, identity.identityId());
                KeyCertEntry keyCertEntry = new KeyCertEntry(key, chain);
                this.keyCerts.put(moduleName + "#slotid-" + slotId.id() + "#keyid-" + objId.idHex(), keyCertEntry);
                this.keyCerts.put(moduleName + "#slotid-" + slotId.id() + "#keylabel-" + objId.label(), keyCertEntry);
                this.keyCerts.put(moduleName + "#slotindex-" + slotId.index() + "#keyid-" + objId.idHex(), keyCertEntry);
                this.keyCerts.put(moduleName + "#slotindex-" + slotId.index() + "#keylabel-" + objId.label(), keyCertEntry);
            }
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.keyCerts.containsKey(alias)) {
            return null;
        }
        return this.keyCerts.get(alias).getKey();
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (!this.keyCerts.containsKey(alias)) {
            return null;
        }
        return this.keyCerts.get(alias).getCertificateChain();
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (!this.keyCerts.containsKey(alias)) {
            return null;
        }
        return this.keyCerts.get(alias).getCertificate();
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (!this.keyCerts.containsKey(alias)) {
            return null;
        }
        return this.creationDate;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("keystore is read only");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("keystore is read only");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("keystore is read only");
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException("keystore is read only");
    }

    @Override
    public Enumeration<String> engineAliases() {
        return new MyEnumeration<String>(this.keyCerts.keySet().iterator());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.keyCerts.containsKey(alias);
    }

    @Override
    public int engineSize() {
        return this.keyCerts.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        if (!this.keyCerts.containsKey(alias)) {
            return false;
        }
        return this.keyCerts.get(alias).key != null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        if (!this.keyCerts.containsKey(alias)) {
            return false;
        }
        return this.keyCerts.get(alias).key == null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        for (String alias : this.keyCerts.keySet()) {
            if (!this.keyCerts.get(alias).getCertificate().equals(cert)) continue;
            return alias;
        }
        return null;
    }

    private static class KeyCertEntry {
        private PrivateKey key;
        private Certificate[] chain;

        KeyCertEntry(PrivateKey key, Certificate[] chain) {
            this.key = (PrivateKey)ParamUtil.requireNonNull((String)"key", (Object)key);
            this.chain = (Certificate[])ParamUtil.requireNonNull((String)"chain", (Object)chain);
            if (chain.length < 1) {
                throw new IllegalArgumentException("chain does not contain any certificate");
            }
        }

        PrivateKey getKey() {
            return this.key;
        }

        Certificate[] getCertificateChain() {
            return Arrays.copyOf(this.chain, this.chain.length);
        }

        Certificate getCertificate() {
            return this.chain[0];
        }
    }

    private static class MyEnumeration<E>
    implements Enumeration<E> {
        private Iterator<E> iter;

        MyEnumeration(Iterator<E> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iter.next();
        }
    }
}

