/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.iaik;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericSecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RSAPkcsPssParameters;
import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.concurrent.ConcurrentBag;
import org.xipki.common.concurrent.ConcurrentBagEntry;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.security.X509Cert;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.AbstractP11Slot;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11MechanismFilter;
import org.xipki.security.pkcs11.P11NewKeyControl;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11RSAPkcsPssParams;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11SlotRefreshResult;
import org.xipki.security.pkcs11.Pkcs11Functions;
import org.xipki.security.pkcs11.iaik.IaikP11Identity;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;

class IaikP11Slot
extends AbstractP11Slot {
    private static final Logger LOG = LoggerFactory.getLogger(IaikP11Slot.class);
    private static final long DEFAULT_MAX_COUNT_SESSION = 32L;
    private final int maxMessageSize;
    private Slot slot;
    private final long userType;
    private List<char[]> password;
    private int maxSessionCount;
    private long timeOutWaitNewSession = 10000L;
    private final AtomicLong countSessions = new AtomicLong(0L);
    private final ConcurrentBag<ConcurrentBagEntry<Session>> sessions = new ConcurrentBag();
    private boolean writableSessionInUse;
    private Session writableSession;

    IaikP11Slot(String moduleName, P11SlotIdentifier slotId, Slot slot, boolean readOnly, long userType, List<char[]> password, int maxMessageSize, P11MechanismFilter mechanismFilter) throws P11TokenException {
        super(moduleName, slotId, readOnly, mechanismFilter);
        long maxSessionCount2;
        Token token;
        Session session;
        this.slot = (Slot)ParamUtil.requireNonNull((String)"slot", (java.lang.Object)slot);
        this.maxMessageSize = ParamUtil.requireMin((String)"maxMessageSize", (int)maxMessageSize, (int)1);
        this.userType = ParamUtil.requireMin((String)"userType", (long)userType, (long)0L);
        this.password = password;
        try {
            session = this.openSession(false);
        }
        catch (P11TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"openSession");
            this.close();
            throw ex;
        }
        try {
            this.firstLogin(session, password);
        }
        catch (P11TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"firstLogin");
            this.close();
            throw ex;
        }
        try {
            token = this.slot.getToken();
        }
        catch (TokenException ex) {
            throw new P11TokenException("could not getToken: " + ex.getMessage(), ex);
        }
        try {
            maxSessionCount2 = token.getTokenInfo().getMaxSessionCount();
        }
        catch (TokenException ex) {
            throw new P11TokenException("could not get tokenInfo: " + ex.getMessage(), ex);
        }
        maxSessionCount2 = maxSessionCount2 == 0L ? 32L : (maxSessionCount2 < 3L ? 1L : maxSessionCount2 - 2L);
        this.maxSessionCount = (int)maxSessionCount2;
        LOG.info("maxSessionCount: {}", (java.lang.Object)this.maxSessionCount);
        this.sessions.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((java.lang.Object)session));
        this.refresh();
    }

    Slot getSlot() {
        return this.slot;
    }

    @Override
    protected P11SlotRefreshResult refresh0() throws P11TokenException {
        PrivateKey privKey;
        byte[] keyId;
        Mechanism[] mechanisms;
        try {
            mechanisms = this.slot.getToken().getMechanismList();
        }
        catch (TokenException ex) {
            throw new P11TokenException("could not getMechanismList: " + ex.getMessage(), ex);
        }
        P11SlotRefreshResult ret = new P11SlotRefreshResult();
        if (mechanisms != null) {
            for (Mechanism mech : mechanisms) {
                ret.addMechanism(mech.getMechanismCode());
            }
        }
        List<SecretKey> secretKeys = this.getAllSecretKeyObjects();
        for (SecretKey secKey : secretKeys) {
            byte[] keyId2 = secKey.getId().getByteArrayValue();
            if (keyId2 == null || keyId2.length == 0) continue;
            this.analyseSingleKey(secKey, ret);
        }
        List<X509PublicKeyCertificate> p11Certs = this.getAllCertificateObjects();
        for (X509PublicKeyCertificate p11Cert : p11Certs) {
            P11ObjectIdentifier objId = new P11ObjectIdentifier(p11Cert.getId().getByteArrayValue(), IaikP11Slot.toString(p11Cert.getLabel()));
            ret.addCertificate(objId, IaikP11Slot.parseCert(p11Cert));
        }
        List<PrivateKey> privKeys = this.getAllPrivateObjects();
        Iterator<PrivateKey> iterator = privKeys.iterator();
        while (iterator.hasNext() && (keyId = (privKey = iterator.next()).getId().getByteArrayValue()) != null && keyId.length != 0) {
            try {
                this.analyseSingleKey(privKey, ret);
            }
            catch (XiSecurityException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("XiSecurityException while initializing private key with id " + IaikP11Slot.hex(keyId)));
            }
            catch (Throwable th) {
                String label = "";
                if (privKey.getLabel() != null) {
                    label = new String(privKey.getLabel().getCharArrayValue());
                }
                LOG.error("unexpected exception while initializing private key with id " + IaikP11Slot.hex(keyId) + " and label " + label, th);
            }
        }
        return ret;
    }

    @Override
    public void close() {
        if (this.slot != null) {
            try {
                LOG.info("close all sessions on token: {}", (java.lang.Object)this.slot.getSlotID());
                if (this.writableSession != null) {
                    this.writableSession.closeSession();
                }
                for (ConcurrentBagEntry session : this.sessions.values()) {
                    ((Session)session.value()).closeSession();
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not slot.getToken().closeAllSessions()");
            }
            this.slot = null;
        }
        this.sessions.close();
        this.countSessions.lazySet(0L);
    }

    private void analyseSingleKey(SecretKey secretKey, P11SlotRefreshResult refreshResult) {
        byte[] id = secretKey.getId().getByteArrayValue();
        P11ObjectIdentifier objectId = new P11ObjectIdentifier(id, IaikP11Slot.toString(secretKey.getLabel()));
        IaikP11Identity identity = new IaikP11Identity(this, new P11EntityIdentifier(this.slotId, objectId), secretKey);
        refreshResult.addIdentity(identity);
    }

    private void analyseSingleKey(PrivateKey privKey, P11SlotRefreshResult refreshResult) throws P11TokenException, XiSecurityException {
        X509Certificate[] x509CertificateArray;
        byte[] id = privKey.getId().getByteArrayValue();
        PublicKey pubKey = null;
        X509Cert cert = refreshResult.getCertForId(id);
        if (cert != null) {
            pubKey = cert.cert().getPublicKey();
        } else {
            iaik.pkcs.pkcs11.objects.PublicKey p11PublicKey = this.getPublicKeyObject(id, null);
            if (p11PublicKey == null) {
                LOG.info("neither certificate nor public key for the key (" + Hex.toHexString((byte[])id) + " is available");
                return;
            }
            pubKey = IaikP11Slot.generatePublicKey(p11PublicKey);
        }
        P11ObjectIdentifier objectId = new P11ObjectIdentifier(id, IaikP11Slot.toString(privKey.getLabel()));
        if (cert == null) {
            x509CertificateArray = null;
        } else {
            X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
            x509CertificateArray = x509CertificateArray2;
            x509CertificateArray2[0] = cert.cert();
        }
        X509Certificate[] certs = x509CertificateArray;
        IaikP11Identity identity = new IaikP11Identity(this, new P11EntityIdentifier(this.slotId, objectId), privKey, pubKey, certs);
        refreshResult.addIdentity(identity);
    }

    byte[] digestKey(long mechanism, IaikP11Identity identity) throws P11TokenException {
        int digestLen;
        ConcurrentBagEntry<Session> session0;
        ParamUtil.requireNonNull((String)"identity", (java.lang.Object)identity);
        this.assertMechanismSupported(mechanism);
        Key signingKey = identity.signingKey();
        if (!(signingKey instanceof SecretKey)) {
            throw new P11TokenException("digestSecretKey could not be applied to non-SecretKey");
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("digest (init, digestKey, then finish)\n{}", (java.lang.Object)signingKey);
        }
        if ((session0 = this.borrowSession()) == null) {
            throw new P11TokenException("no idle session available");
        }
        if (544L == mechanism) {
            digestLen = 20;
        } else if (597L == mechanism || 693L == mechanism) {
            digestLen = 28;
        } else if (592L == mechanism || 688L == mechanism) {
            digestLen = 32;
        } else if (608L == mechanism || 704L == mechanism) {
            digestLen = 48;
        } else if (624L == mechanism || 720L == mechanism) {
            digestLen = 64;
        } else {
            throw new P11TokenException("unsupported mechnism " + mechanism);
        }
        try {
            Session session = (Session)session0.value();
            session.digestInit(Mechanism.get((long)mechanism));
            session.digestKey((SecretKey)signingKey);
            byte[] digest = new byte[digestLen];
            session.digestFinal(digest, 0, digestLen);
            byte[] byArray = digest;
            return byArray;
        }
        catch (TokenException e) {
            throw new P11TokenException(e);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    byte[] sign(long mechanism, P11Params parameters, byte[] content, IaikP11Identity identity) throws P11TokenException {
        ConcurrentBagEntry<Session> session0;
        ParamUtil.requireNonNull((String)"content", (java.lang.Object)content);
        this.assertMechanismSupported(mechanism);
        int len = content.length;
        if (len <= this.maxMessageSize) {
            return this.singleSign(mechanism, parameters, content, identity);
        }
        Key signingKey = identity.signingKey();
        Mechanism mechanismObj = IaikP11Slot.getMechanism(mechanism, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.debug("sign (init, update, then finish) with private key:\n{}", (java.lang.Object)signingKey);
        }
        if ((session0 = this.borrowSession()) == null) {
            throw new P11TokenException("no idle session available");
        }
        try {
            Session session = (Session)session0.value();
            session.signInit(mechanismObj, signingKey);
            for (int i = 0; i < len; i += this.maxMessageSize) {
                int blockLen = Math.min(this.maxMessageSize, len - i);
                session.signUpdate(content, i, blockLen);
            }
            int expectedSignatureLen = identity.expectedSignatureLen();
            if (mechanism == 545L) {
                expectedSignatureLen = 20;
            } else if (mechanism == 598L || mechanism == 693L) {
                expectedSignatureLen = 28;
            } else if (mechanism == 593L || mechanism == 688L) {
                expectedSignatureLen = 32;
            } else if (mechanism == 609L || mechanism == 704L) {
                expectedSignatureLen = 48;
            } else if (mechanism == 625L || mechanism == 720L) {
                expectedSignatureLen = 64;
            }
            byte[] byArray = session.signFinal(expectedSignatureLen);
            return byArray;
        }
        catch (TokenException e) {
            throw new P11TokenException(e);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] singleSign(long mechanism, P11Params parameters, byte[] content, IaikP11Identity identity) throws P11TokenException {
        byte[] signature;
        ConcurrentBagEntry<Session> session0;
        Key signingKey = identity.signingKey();
        Mechanism mechanismObj = IaikP11Slot.getMechanism(mechanism, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.debug("sign with signing key:\n{}", (java.lang.Object)signingKey);
        }
        if ((session0 = this.borrowSession()) == null) {
            throw new P11TokenException("no idle session available");
        }
        try {
            Session session;
            Session session2 = session = (Session)session0.value();
            synchronized (session2) {
                session.signInit(mechanismObj, signingKey);
                signature = session.sign(content);
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            this.sessions.requite(session0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("signature:\n{}", (java.lang.Object)Hex.toHexString((byte[])signature));
        }
        return signature;
    }

    private static Mechanism getMechanism(long mechanism, P11Params parameters) throws P11TokenException {
        Mechanism ret = Mechanism.get((long)mechanism);
        if (parameters == null) {
            return ret;
        }
        if (!(parameters instanceof P11RSAPkcsPssParams)) {
            throw new P11TokenException("unknown P11Parameters " + parameters.getClass().getName());
        }
        P11RSAPkcsPssParams param = (P11RSAPkcsPssParams)parameters;
        RSAPkcsPssParameters paramObj = new RSAPkcsPssParameters(Mechanism.get((long)param.hashAlgorithm()), param.maskGenerationFunction(), param.saltLength());
        ret.setParameters((Parameters)paramObj);
        return ret;
    }

    private Session openSession(boolean rwSession) throws P11TokenException {
        Session session;
        try {
            session = this.slot.getToken().openSession(true, rwSession, null, null);
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        this.countSessions.incrementAndGet();
        return session;
    }

    private ConcurrentBagEntry<Session> borrowSession() throws P11TokenException {
        ConcurrentBagEntry session = null;
        if (this.countSessions.get() < (long)this.maxSessionCount) {
            try {
                session = (ConcurrentBagEntry)this.sessions.borrow(1L, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (session == null) {
                session = new ConcurrentBagEntry((java.lang.Object)this.openSession(false));
                this.sessions.add((ConcurrentBag.IConcurrentBagEntry)session);
            }
        }
        if (session == null) {
            try {
                session = (ConcurrentBagEntry)this.sessions.borrow(this.timeOutWaitNewSession, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (session == null) {
            throw new P11TokenException("no idle session");
        }
        this.login((Session)session.value());
        return session;
    }

    private void firstLogin(Session session, List<char[]> password) throws P11TokenException {
        try {
            boolean isProtectedAuthenticationPath = session.getToken().getTokenInfo().isProtectedAuthenticationPath();
            if (isProtectedAuthenticationPath || CollectionUtil.isEmpty(password)) {
                LOG.info("verify on PKCS11Module with PROTECTED_AUTHENTICATION_PATH");
                this.singleLogin(session, null);
            } else {
                LOG.info("verify on PKCS11Module with PIN");
                for (char[] singlePwd : password) {
                    this.singleLogin(session, singlePwd);
                }
                this.password = password;
            }
        }
        catch (PKCS11Exception ex) {
            if (ex.getErrorCode() != 256L) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    private void login(Session session) throws P11TokenException {
        boolean loginRequired;
        boolean isSessionLoggedIn = IaikP11Slot.checkSessionLoggedIn(session);
        if (isSessionLoggedIn) {
            return;
        }
        try {
            loginRequired = session.getToken().getTokenInfo().isLoginRequired();
        }
        catch (TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not check whether LoginRequired of token");
            loginRequired = true;
        }
        LOG.debug("loginRequired: {}", (java.lang.Object)loginRequired);
        if (!loginRequired) {
            return;
        }
        if (CollectionUtil.isEmpty(this.password)) {
            this.singleLogin(session, null);
        } else {
            for (char[] singlePwd : this.password) {
                this.singleLogin(session, singlePwd);
            }
        }
    }

    private void singleLogin(Session session, char[] pin) throws P11TokenException {
        char[] tmpPin = pin;
        if (pin == null) {
            tmpPin = new char[]{};
        }
        try {
            if (this.userType == 1L) {
                session.login(true, tmpPin);
            } else if (this.userType == 0L) {
                session.login(false, tmpPin);
            } else {
                session.login(this.userType, tmpPin);
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PrivateKey> getAllPrivateObjects() throws P11TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            Session session = (Session)session0.value();
            PrivateKey template = new PrivateKey();
            List<Storage> tmpObjects = IaikP11Slot.getObjects(session, (Storage)template);
            if (CollectionUtil.isEmpty(tmpObjects)) {
                List<PrivateKey> list = Collections.emptyList();
                return list;
            }
            int n = tmpObjects.size();
            LOG.info("found {} private keys", (java.lang.Object)n);
            ArrayList<PrivateKey> privateKeys = new ArrayList<PrivateKey>(n);
            for (Storage tmpObject : tmpObjects) {
                PrivateKey privateKey = (PrivateKey)tmpObject;
                privateKeys.add(privateKey);
            }
            ArrayList<PrivateKey> arrayList = privateKeys;
            return arrayList;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SecretKey> getAllSecretKeyObjects() throws P11TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            Session session = (Session)session0.value();
            SecretKey template = new SecretKey();
            List<Storage> tmpObjects = IaikP11Slot.getObjects(session, (Storage)template);
            if (CollectionUtil.isEmpty(tmpObjects)) {
                List<SecretKey> list = Collections.emptyList();
                return list;
            }
            int n = tmpObjects.size();
            LOG.info("found {} private keys", (java.lang.Object)n);
            ArrayList<SecretKey> keys = new ArrayList<SecretKey>(n);
            for (Storage tmpObject : tmpObjects) {
                SecretKey key = (SecretKey)tmpObject;
                keys.add(key);
            }
            ArrayList<SecretKey> arrayList = keys;
            return arrayList;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    private SecretKey getSecretKeyObject(byte[] keyId, char[] keyLabel) throws P11TokenException {
        return (SecretKey)this.getKeyObject((Key)new SecretKey(), keyId, keyLabel);
    }

    private PrivateKey getPrivateKeyObject(byte[] keyId, char[] keyLabel) throws P11TokenException {
        return (PrivateKey)this.getKeyObject((Key)new PrivateKey(), keyId, keyLabel);
    }

    private iaik.pkcs.pkcs11.objects.PublicKey getPublicKeyObject(byte[] keyId, char[] keyLabel) throws P11TokenException {
        return (iaik.pkcs.pkcs11.objects.PublicKey)this.getKeyObject((Key)new iaik.pkcs.pkcs11.objects.PublicKey(), keyId, keyLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getKeyObject(Key template, byte[] keyId, char[] keyLabel) throws P11TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            Session session;
            List<Storage> tmpObjects;
            if (keyId != null) {
                template.getId().setByteArrayValue(keyId);
            }
            if (keyLabel != null) {
                template.getLabel().setCharArrayValue(keyLabel);
            }
            if (CollectionUtil.isEmpty(tmpObjects = IaikP11Slot.getObjects(session = (Session)session0.value(), (Storage)template, 2))) {
                Key key = null;
                return key;
            }
            int size = tmpObjects.size();
            if (size > 1) {
                LOG.warn("found {} public key identified by {}, use the first one", (java.lang.Object)size, (java.lang.Object)IaikP11Slot.getDescription(keyId, keyLabel));
            }
            Key key = (Key)tmpObjects.get(0);
            return key;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    private static boolean checkSessionLoggedIn(Session session) throws P11TokenException {
        SessionInfo info;
        try {
            info = session.getSessionInfo();
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("SessionInfo: {}", (java.lang.Object)info);
        }
        State state = info.getState();
        long deviceError = info.getDeviceError();
        LOG.debug("to be verified PKCS11Module: state = {}, deviceError: {}", (java.lang.Object)state, (java.lang.Object)deviceError);
        boolean isRwSessionLoggedIn = state.equals((java.lang.Object)State.RW_USER_FUNCTIONS);
        boolean isRoSessionLoggedIn = state.equals((java.lang.Object)State.RO_USER_FUNCTIONS);
        boolean sessionLoggedIn = (isRoSessionLoggedIn || isRwSessionLoggedIn) && deviceError == 0L;
        LOG.debug("sessionLoggedIn: {}", (java.lang.Object)sessionLoggedIn);
        return sessionLoggedIn;
    }

    private static List<Storage> getObjects(Session session, Storage template) throws P11TokenException {
        return IaikP11Slot.getObjects(session, template, 9999);
    }

    private static List<Storage> getObjects(Session session, Storage template, int maxNo) throws P11TokenException {
        LinkedList<Storage> objList = new LinkedList<Storage>();
        try {
            Object[] foundObjects;
            session.findObjectsInit((Object)template);
            while (objList.size() < maxNo && (foundObjects = session.findObjects(1)) != null) {
                if (foundObjects.length == 0) {
                    break;
                }
                for (Object object : foundObjects) {
                    if (LOG.isTraceEnabled()) {
                        LOG.debug("found object: {}", (java.lang.Object)object);
                    }
                    objList.add((Storage)object);
                }
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            try {
                session.findObjectsFinal();
            }
            catch (Exception exception) {}
        }
        return objList;
    }

    private static PublicKey generatePublicKey(iaik.pkcs.pkcs11.objects.PublicKey p11Key) throws XiSecurityException {
        if (p11Key instanceof RSAPublicKey) {
            RSAPublicKey rsaP11Key = (RSAPublicKey)p11Key;
            byte[] expBytes = rsaP11Key.getPublicExponent().getByteArrayValue();
            BigInteger exp = new BigInteger(1, expBytes);
            byte[] modBytes = rsaP11Key.getModulus().getByteArrayValue();
            BigInteger mod = new BigInteger(1, modBytes);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
            try {
                return KeyUtil.generateRSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
        }
        if (p11Key instanceof DSAPublicKey) {
            DSAPublicKey dsaP11Key = (DSAPublicKey)p11Key;
            BigInteger prime = new BigInteger(1, dsaP11Key.getPrime().getByteArrayValue());
            BigInteger subPrime = new BigInteger(1, dsaP11Key.getSubprime().getByteArrayValue());
            BigInteger base = new BigInteger(1, dsaP11Key.getBase().getByteArrayValue());
            BigInteger value = new BigInteger(1, dsaP11Key.getValue().getByteArrayValue());
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(value, prime, subPrime, base);
            try {
                return KeyUtil.generateDSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
        }
        if (p11Key instanceof ECDSAPublicKey) {
            ECDSAPublicKey ecP11Key = (ECDSAPublicKey)p11Key;
            byte[] encodedAlgorithmIdParameters = ecP11Key.getEcdsaParams().getByteArrayValue();
            byte[] encodedPoint = DEROctetString.getInstance((java.lang.Object)ecP11Key.getEcPoint().getByteArrayValue()).getOctets();
            try {
                return KeyUtil.createECPublicKey(encodedAlgorithmIdParameters, encodedPoint);
            }
            catch (InvalidKeySpecException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
        }
        throw new XiSecurityException("unknown publicKey class " + p11Key.getClass().getName());
    }

    private static String toString(CharArrayAttribute charArrayAttr) {
        char[] chars;
        String labelStr = "";
        if (charArrayAttr != null && (chars = charArrayAttr.getCharArrayValue()) != null) {
            labelStr = new String(chars);
        }
        return labelStr;
    }

    private static X509Cert parseCert(X509PublicKeyCertificate p11Cert) throws P11TokenException {
        try {
            byte[] encoded = p11Cert.getValue().getByteArrayValue();
            return new X509Cert(X509Util.parseCert(encoded), encoded);
        }
        catch (CertificateException ex) {
            throw new P11TokenException("could not parse certificate: " + ex.getMessage(), ex);
        }
    }

    private synchronized Session borrowWritableSession() throws P11TokenException {
        if (this.writableSession == null) {
            this.writableSession = this.openSession(true);
        }
        if (this.writableSessionInUse) {
            throw new P11TokenException("no idle writable session available");
        }
        this.writableSessionInUse = true;
        this.login(this.writableSession);
        return this.writableSession;
    }

    private synchronized void returnWritableSession(Session session) throws P11TokenException {
        if (session != this.writableSession) {
            throw new P11TokenException("the returned session does not belong to me");
        }
        this.writableSessionInUse = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<X509PublicKeyCertificate> getAllCertificateObjects() throws P11TokenException {
        List<Storage> tmpObjects;
        X509PublicKeyCertificate template = new X509PublicKeyCertificate();
        ConcurrentBagEntry<Session> session = this.borrowSession();
        try {
            tmpObjects = IaikP11Slot.getObjects((Session)session.value(), (Storage)template);
        }
        finally {
            this.sessions.requite(session);
        }
        ArrayList<X509PublicKeyCertificate> certs = new ArrayList<X509PublicKeyCertificate>(tmpObjects.size());
        for (Object object : tmpObjects) {
            X509PublicKeyCertificate cert = (X509PublicKeyCertificate)object;
            certs.add(cert);
        }
        return certs;
    }

    @Override
    public int removeObjects(byte[] id, String label) throws P11TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            throw new IllegalArgumentException("at least one of id and label must not be null");
        }
        Key keyTemplate = new Key();
        if (id != null && id.length > 0) {
            keyTemplate.getId().setByteArrayValue(id);
        }
        if (StringUtil.isNotBlank((String)label)) {
            keyTemplate.getLabel().setCharArrayValue(label.toCharArray());
        }
        String objIdDesc = IaikP11Slot.getDescription(id, label);
        int num = this.removeObjects((Storage)keyTemplate, "keys " + objIdDesc);
        X509PublicKeyCertificate certTemplate = new X509PublicKeyCertificate();
        if (id != null && id.length > 0) {
            certTemplate.getId().setByteArrayValue(id);
        }
        if (StringUtil.isNotBlank((String)label)) {
            certTemplate.getLabel().setCharArrayValue(label.toCharArray());
        }
        return num += this.removeObjects((Storage)certTemplate, "certificates" + objIdDesc);
    }

    private int removeObjects(Storage template, String desc) throws P11TokenException {
        Session session = this.borrowWritableSession();
        try {
            List<Storage> objects = IaikP11Slot.getObjects(session, template);
            for (Storage obj : objects) {
                session.destroyObject((Object)obj);
            }
            int n = objects.size();
            return n;
        }
        catch (TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not remove " + desc));
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            this.returnWritableSession(session);
        }
    }

    @Override
    protected void removeCerts0(P11ObjectIdentifier objectId) throws P11TokenException {
        X509PublicKeyCertificate[] existingCerts = this.getCertificateObjects(objectId.id(), objectId.labelChars());
        if (existingCerts == null || existingCerts.length == 0) {
            LOG.warn("could not find certificates " + objectId);
            return;
        }
        Session session = this.borrowWritableSession();
        try {
            for (X509PublicKeyCertificate cert : existingCerts) {
                session.destroyObject((Object)cert);
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            this.returnWritableSession(session);
        }
    }

    @Override
    protected void addCert0(P11ObjectIdentifier objectId, X509Certificate cert) throws P11TokenException {
        X509PublicKeyCertificate newCaCertTemp = IaikP11Slot.createPkcs11Template(new X509Cert(cert), objectId.id(), objectId.labelChars());
        Session session = this.borrowWritableSession();
        try {
            session.createObject((Object)newCaCertTemp);
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            this.returnWritableSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11Identity generateSecretKey0(long keyType, int keysize, String label, P11NewKeyControl control) throws P11TokenException {
        long mechanism;
        if (keysize % 8 != 0) {
            throw new IllegalArgumentException("keysize is not multiple of 8: " + keysize);
        }
        GenericSecretKey template = new GenericSecretKey();
        template.getKeyType().setLongValue(Long.valueOf(keyType));
        template.getToken().setBooleanValue(Boolean.valueOf(true));
        template.getLabel().setCharArrayValue(label.toCharArray());
        template.getSign().setBooleanValue(Boolean.valueOf(true));
        template.getSensitive().setBooleanValue(Boolean.valueOf(true));
        template.getExtractable().setBooleanValue(Boolean.valueOf(control.isExtractable()));
        template.getValueLen().setLongValue(Long.valueOf(keysize / 8));
        if (31L == keyType) {
            mechanism = 4224L;
        } else if (21L == keyType) {
            mechanism = 305L;
        } else if (16L == keyType) {
            mechanism = 848L;
        } else if (40L == keyType || 46L == keyType || 43L == keyType || 44L == keyType || 45L == keyType || 51L == keyType || 52L == keyType || 53L == keyType || 54L == keyType) {
            mechanism = 848L;
        } else {
            throw new IllegalArgumentException("unsupported key type " + Functions.toFullHexString((int)((int)keyType)));
        }
        Mechanism mech = Mechanism.get((long)mechanism);
        Session session = this.borrowWritableSession();
        try {
            SecretKey key;
            if (IaikP11Slot.labelExists(session, label)) {
                throw new IllegalArgumentException("label " + label + " exists, please specify another one");
            }
            byte[] id = IaikP11Slot.generateKeyId(session);
            template.getId().setByteArrayValue(id);
            try {
                key = (SecretKey)session.generateKey(mech, (Object)template);
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not generate generic secret key using " + mech.getName(), ex);
            }
            P11ObjectIdentifier objId = new P11ObjectIdentifier(id, label);
            P11EntityIdentifier entityId = new P11EntityIdentifier(this.slotId, objId);
            IaikP11Identity iaikP11Identity = new IaikP11Identity(this, entityId, key);
            return iaikP11Identity;
        }
        finally {
            this.returnWritableSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11Identity createSecretKey0(long keyType, byte[] keyValue, String label, P11NewKeyControl control) throws P11TokenException {
        GenericSecretKey template = new GenericSecretKey();
        template.getKeyType().setLongValue(Long.valueOf(keyType));
        template.getToken().setBooleanValue(Boolean.valueOf(true));
        template.getLabel().setCharArrayValue(label.toCharArray());
        template.getSign().setBooleanValue(Boolean.valueOf(true));
        template.getSensitive().setBooleanValue(Boolean.valueOf(true));
        template.getExtractable().setBooleanValue(Boolean.valueOf(control.isExtractable()));
        template.getValue().setByteArrayValue(keyValue);
        Session session = this.borrowWritableSession();
        try {
            SecretKey key;
            if (IaikP11Slot.labelExists(session, label)) {
                throw new IllegalArgumentException("label " + label + " exists, please specify another one");
            }
            byte[] id = IaikP11Slot.generateKeyId(session);
            template.getId().setByteArrayValue(id);
            try {
                key = (SecretKey)session.createObject((Object)template);
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not create secret key", ex);
            }
            P11ObjectIdentifier objId = new P11ObjectIdentifier(id, label);
            P11EntityIdentifier entityId = new P11EntityIdentifier(this.slotId, objId);
            IaikP11Identity iaikP11Identity = new IaikP11Identity(this, entityId, key);
            return iaikP11Identity;
        }
        finally {
            this.returnWritableSession(session);
        }
    }

    @Override
    protected P11Identity generateRSAKeypair0(int keysize, BigInteger publicExponent, String label, P11NewKeyControl control) throws P11TokenException {
        RSAPrivateKey privateKey = new RSAPrivateKey();
        RSAPublicKey publicKey = new RSAPublicKey();
        IaikP11Slot.setKeyAttributes(label, 0L, control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey);
        publicKey.getModulusBits().setLongValue(Long.valueOf(keysize));
        if (publicExponent != null) {
            publicKey.getPublicExponent().setByteArrayValue(publicExponent.toByteArray());
        }
        return this.generateKeyPair(0L, (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    @Override
    protected P11Identity generateDSAKeypair0(BigInteger p, BigInteger q, BigInteger g, String label, P11NewKeyControl control) throws P11TokenException {
        DSAPrivateKey privateKey = new DSAPrivateKey();
        DSAPublicKey publicKey = new DSAPublicKey();
        IaikP11Slot.setKeyAttributes(label, 1L, control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey);
        publicKey.getPrime().setByteArrayValue(p.toByteArray());
        publicKey.getSubprime().setByteArrayValue(q.toByteArray());
        publicKey.getBase().setByteArrayValue(g.toByteArray());
        return this.generateKeyPair(16L, (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    @Override
    protected P11Identity generateECKeypair0(ASN1ObjectIdentifier curveId, String label, P11NewKeyControl control) throws P11TokenException {
        byte[] encodedCurveId;
        ECDSAPrivateKey privateKey = new ECDSAPrivateKey();
        ECDSAPublicKey publicKey = new ECDSAPublicKey();
        IaikP11Slot.setKeyAttributes(label, 3L, control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        try {
            publicKey.getEcdsaParams().setByteArrayValue(encodedCurveId);
            return this.generateKeyPair(4160L, (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
        }
        catch (P11TokenException ex) {
            X9ECParameters ecParams = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveId);
            if (ecParams == null) {
                throw new IllegalArgumentException("could not get X9ECParameters for curve " + curveId.getId());
            }
            try {
                publicKey.getEcdsaParams().setByteArrayValue(ecParams.getEncoded());
            }
            catch (IOException ex2) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
            return this.generateKeyPair(4160L, (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P11Identity generateKeyPair(long mech, PrivateKey privateKey, iaik.pkcs.pkcs11.objects.PublicKey publicKey) throws P11TokenException {
        String label = IaikP11Slot.toString(privateKey.getLabel());
        byte[] id = null;
        try {
            PublicKey jcePublicKey;
            KeyPair keypair;
            Session session = this.borrowWritableSession();
            try {
                if (IaikP11Slot.labelExists(session, label)) {
                    throw new IllegalArgumentException("label " + label + " exists, please specify another one");
                }
                id = IaikP11Slot.generateKeyId(session);
                privateKey.getId().setByteArrayValue(id);
                publicKey.getId().setByteArrayValue(id);
                try {
                    keypair = session.generateKeyPair(Mechanism.get((long)mech), (Object)publicKey, (Object)privateKey);
                }
                catch (TokenException ex) {
                    throw new P11TokenException("could not generate keypair " + Pkcs11Functions.mechanismCodeToString(mech), ex);
                }
            }
            finally {
                this.returnWritableSession(session);
            }
            P11ObjectIdentifier objId = new P11ObjectIdentifier(id, label);
            P11EntityIdentifier entityId = new P11EntityIdentifier(this.slotId, objId);
            try {
                jcePublicKey = IaikP11Slot.generatePublicKey(keypair.getPublicKey());
            }
            catch (XiSecurityException ex) {
                throw new P11TokenException("could not generate public key " + objId, ex);
            }
            PrivateKey privateKey2 = this.getPrivateKeyObject(id, label.toCharArray());
            if (privateKey2 == null) {
                throw new P11TokenException("could not read the generated private key");
            }
            return new IaikP11Identity(this, entityId, privateKey2, jcePublicKey, null);
        }
        catch (RuntimeException | P11TokenException ex) {
            try {
                this.removeObjects(id, label);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not remove objects");
            }
            throw ex;
        }
    }

    private static X509PublicKeyCertificate createPkcs11Template(X509Cert cert, byte[] keyId, char[] label) {
        if (label == null || label.length == 0) {
            throw new IllegalArgumentException("label must not be null or empty");
        }
        X509PublicKeyCertificate newCertTemp = new X509PublicKeyCertificate();
        newCertTemp.getId().setByteArrayValue(keyId);
        newCertTemp.getLabel().setCharArrayValue(label);
        newCertTemp.getToken().setBooleanValue(Boolean.valueOf(true));
        newCertTemp.getCertificateType().setLongValue(Certificate.CertificateType.X_509_PUBLIC_KEY);
        newCertTemp.getSubject().setByteArrayValue(cert.cert().getSubjectX500Principal().getEncoded());
        newCertTemp.getIssuer().setByteArrayValue(cert.cert().getIssuerX500Principal().getEncoded());
        newCertTemp.getSerialNumber().setByteArrayValue(cert.cert().getSerialNumber().toByteArray());
        newCertTemp.getValue().setByteArrayValue(cert.encodedCert());
        return newCertTemp;
    }

    private static void setKeyAttributes(String label, long keyType, P11NewKeyControl control, iaik.pkcs.pkcs11.objects.PublicKey publicKey, PrivateKey privateKey) {
        if (privateKey != null) {
            privateKey.getToken().setBooleanValue(Boolean.valueOf(true));
            privateKey.getLabel().setCharArrayValue(label.toCharArray());
            privateKey.getKeyType().setLongValue(Long.valueOf(keyType));
            privateKey.getSign().setBooleanValue(Boolean.valueOf(true));
            privateKey.getPrivate().setBooleanValue(Boolean.valueOf(true));
            privateKey.getSensitive().setBooleanValue(Boolean.valueOf(true));
            privateKey.getExtractable().setBooleanValue(Boolean.valueOf(control.isExtractable()));
        }
        if (publicKey != null) {
            publicKey.getToken().setBooleanValue(Boolean.valueOf(true));
            publicKey.getLabel().setCharArrayValue(label.toCharArray());
            publicKey.getKeyType().setLongValue(Long.valueOf(keyType));
            publicKey.getVerify().setBooleanValue(Boolean.valueOf(true));
            publicKey.getModifiable().setBooleanValue(Boolean.TRUE);
        }
    }

    @Override
    protected void updateCertificate0(P11ObjectIdentifier objectId, X509Certificate newCert) throws P11TokenException {
        this.removeCerts(objectId);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        X509PublicKeyCertificate newCertTemp = IaikP11Slot.createPkcs11Template(new X509Cert(newCert), objectId.id(), objectId.labelChars());
        Session session = this.borrowWritableSession();
        try {
            session.createObject((Object)newCertTemp);
        }
        catch (TokenException ex) {
            throw new P11TokenException("could not createObject: " + ex.getMessage(), ex);
        }
        finally {
            this.returnWritableSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509PublicKeyCertificate[] getCertificateObjects(byte[] keyId, char[] keyLabel) throws P11TokenException {
        List<Storage> tmpObjects;
        X509PublicKeyCertificate template = new X509PublicKeyCertificate();
        if (keyId != null) {
            template.getId().setByteArrayValue(keyId);
        }
        if (keyLabel != null) {
            template.getLabel().setCharArrayValue(keyLabel);
        }
        ConcurrentBagEntry<Session> session = this.borrowSession();
        try {
            tmpObjects = IaikP11Slot.getObjects((Session)session.value(), (Storage)template);
        }
        finally {
            this.sessions.requite(session);
        }
        if (CollectionUtil.isEmpty(tmpObjects)) {
            LOG.info("found no certificate identified by {}", (java.lang.Object)IaikP11Slot.getDescription(keyId, keyLabel));
            return null;
        }
        int size = tmpObjects.size();
        X509PublicKeyCertificate[] certs = new X509PublicKeyCertificate[size];
        for (int i = 0; i < size; ++i) {
            certs[i] = (X509PublicKeyCertificate)tmpObjects.get(i);
        }
        return certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeIdentity0(P11ObjectIdentifier objectId) throws P11TokenException {
        Session session = this.borrowWritableSession();
        try {
            X509PublicKeyCertificate[] certs;
            iaik.pkcs.pkcs11.objects.PublicKey pubKey;
            PrivateKey privKey;
            byte[] id = objectId.id();
            char[] label = objectId.labelChars();
            SecretKey secretKey = this.getSecretKeyObject(id, label);
            if (secretKey != null) {
                try {
                    session.destroyObject((Object)secretKey);
                }
                catch (TokenException ex) {
                    String msg = "could not delete secret key " + objectId;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                    throw new P11TokenException(msg);
                }
            }
            if ((privKey = this.getPrivateKeyObject(id, label)) != null) {
                try {
                    session.destroyObject((Object)privKey);
                }
                catch (TokenException ex) {
                    String msg = "could not delete private key " + objectId;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                    throw new P11TokenException(msg);
                }
            }
            if ((pubKey = this.getPublicKeyObject(id, label)) != null) {
                try {
                    session.destroyObject((Object)pubKey);
                }
                catch (TokenException ex) {
                    String msg = "could not delete public key " + objectId;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                    throw new P11TokenException(msg);
                }
            }
            if ((certs = this.getCertificateObjects(id, label)) != null && certs.length > 0) {
                for (int i = 0; i < certs.length; ++i) {
                    try {
                        session.destroyObject((Object)certs[i]);
                        continue;
                    }
                    catch (TokenException ex) {
                        String msg = "could not delete certificate " + objectId;
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new P11TokenException(msg);
                    }
                }
            }
        }
        finally {
            this.returnWritableSession(session);
        }
    }

    private static byte[] generateKeyId(Session session) throws P11TokenException {
        SecureRandom random = new SecureRandom();
        byte[] keyId = null;
        do {
            keyId = new byte[8];
            random.nextBytes(keyId);
        } while (IaikP11Slot.idExists(session, keyId));
        return keyId;
    }

    private static boolean idExists(Session session, byte[] keyId) throws P11TokenException {
        Object[] objects;
        Key key = new Key();
        key.getId().setByteArrayValue(keyId);
        try {
            session.findObjectsInit((Object)key);
            objects = session.findObjects(1);
            session.findObjectsFinal();
            if (objects.length > 0) {
                return true;
            }
            X509PublicKeyCertificate cert = new X509PublicKeyCertificate();
            cert.getId().setByteArrayValue(keyId);
            session.findObjectsInit((Object)cert);
            objects = session.findObjects(1);
            session.findObjectsFinal();
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return objects.length > 0;
    }

    private static boolean labelExists(Session session, String keyLabel) throws P11TokenException {
        Object[] objects;
        ParamUtil.requireNonBlank((String)"keyLabel", (String)keyLabel);
        Key key = new Key();
        key.getLabel().setCharArrayValue(keyLabel.toCharArray());
        try {
            session.findObjectsInit((Object)key);
            objects = session.findObjects(1);
            session.findObjectsFinal();
            if (objects.length > 0) {
                return true;
            }
            X509PublicKeyCertificate cert = new X509PublicKeyCertificate();
            cert.getLabel().setCharArrayValue(keyLabel.toCharArray());
            session.findObjectsInit((Object)cert);
            objects = session.findObjects(1);
            session.findObjectsFinal();
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return objects.length > 0;
    }
}

