/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.security.HashAlgoType;
import org.xipki.security.X509Cert;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.P11UnknownEntityException;
import org.xipki.security.pkcs11.AbstractP11Slot;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11MechanismFilter;
import org.xipki.security.pkcs11.P11NewKeyControl;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11SlotRefreshResult;
import org.xipki.security.pkcs11.emulator.EmulatorP11Identity;
import org.xipki.security.pkcs11.emulator.PrivateKeyCryptor;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;

class EmulatorP11Slot
extends AbstractP11Slot {
    private static final String FILE_SLOTINFO = "slot.info";
    private static final String PROP_NAMED_CURVE_SUPPORTED = "namedCurveSupported";
    private static final String DIR_PRIV_KEY = "privkey";
    private static final String DIR_PUB_KEY = "pubkey";
    private static final String DIR_SEC_KEY = "seckey";
    private static final String DIR_CERT = "cert";
    private static final String INFO_FILE_SUFFIX = ".info";
    private static final String VALUE_FILE_SUFFIX = ".value";
    private static final String PROP_ID = "id";
    private static final String PROP_LABEL = "label";
    private static final String PROP_SHA1SUM = "sha1";
    private static final String PROP_ALGORITHM = "algorithm";
    private static final String PROP_RSA_MODUS = "modus";
    private static final String PROP_RSA_PUBLIC_EXPONENT = "publicExponent";
    private static final String PROP_DSA_PRIME = "prime";
    private static final String PROP_DSA_SUBPRIME = "subprime";
    private static final String PROP_DSA_BASE = "base";
    private static final String PROP_DSA_VALUE = "value";
    private static final String PROP_EC_ECDSA_PARAMS = "ecdsaParams";
    private static final String PROP_EC_EC_POINT = "ecPoint";
    private static final long[] supportedMechs = new long[]{16L, 0L, 4160L, 848L, 544L, 597L, 592L, 608L, 624L, 693L, 688L, 704L, 720L, 545L, 598L, 593L, 609L, 625L, 694L, 689L, 705L, 721L, 3L, 1L, 6L, 70L, 64L, 65L, 66L, 102L, 96L, 97L, 98L, 13L, 14L, 71L, 67L, 68L, 69L, 103L, 99L, 100L, 101L, 17L, 18L, 19L, 20L, 21L, 22L, 24L, 25L, 26L, 27L, 4161L, 4162L, 4163L, 4164L, 4165L, 4166L, 4168L, 4169L, 4170L, 4171L};
    private static final FilenameFilter INFO_FILENAME_FILTER = new InfoFilenameFilter();
    private final boolean namedCurveSupported;
    private final File slotDir;
    private final File privKeyDir;
    private final File pubKeyDir;
    private final File secKeyDir;
    private final File certDir;
    private final char[] password;
    private final PrivateKeyCryptor privateKeyCryptor;
    private final SecureRandom random = new SecureRandom();
    private final int maxSessions;
    private static final Logger LOG = LoggerFactory.getLogger(EmulatorP11Slot.class);

    EmulatorP11Slot(String moduleName, File slotDir, P11SlotIdentifier slotId, boolean readOnly, char[] password, PrivateKeyCryptor privateKeyCryptor, P11MechanismFilter mechanismFilter, int maxSessions) throws P11TokenException {
        super(moduleName, slotId, readOnly, mechanismFilter);
        File slotInfoFile;
        this.slotDir = (File)ParamUtil.requireNonNull((String)"slotDir", (Object)slotDir);
        this.password = (char[])ParamUtil.requireNonNull((String)"password", (Object)password);
        this.privateKeyCryptor = (PrivateKeyCryptor)ParamUtil.requireNonNull((String)"privateKeyCryptor", (Object)privateKeyCryptor);
        this.maxSessions = ParamUtil.requireMin((String)"maxSessions", (int)maxSessions, (int)1);
        this.privKeyDir = new File(slotDir, DIR_PRIV_KEY);
        if (!this.privKeyDir.exists()) {
            this.privKeyDir.mkdirs();
        }
        this.pubKeyDir = new File(slotDir, DIR_PUB_KEY);
        if (!this.pubKeyDir.exists()) {
            this.pubKeyDir.mkdirs();
        }
        this.secKeyDir = new File(slotDir, DIR_SEC_KEY);
        if (!this.secKeyDir.exists()) {
            this.secKeyDir.mkdirs();
        }
        this.certDir = new File(slotDir, DIR_CERT);
        if (!this.certDir.exists()) {
            this.certDir.mkdirs();
        }
        if ((slotInfoFile = new File(slotDir, FILE_SLOTINFO)).exists()) {
            Properties props = this.loadProperties(slotInfoFile);
            this.namedCurveSupported = Boolean.parseBoolean(props.getProperty(PROP_NAMED_CURVE_SUPPORTED, "true"));
        } else {
            this.namedCurveSupported = true;
        }
        this.refresh();
    }

    @Override
    protected P11SlotRefreshResult refresh0() throws P11TokenException {
        File[] privKeyInfoFiles;
        File[] certInfoFiles;
        String label;
        Properties props;
        P11SlotRefreshResult ret = new P11SlotRefreshResult();
        for (long mech : supportedMechs) {
            ret.addMechanism(mech);
        }
        File[] secKeyInfoFiles = this.secKeyDir.listFiles(INFO_FILENAME_FILTER);
        if (secKeyInfoFiles != null && secKeyInfoFiles.length != 0) {
            for (File secKeyInfoFile : secKeyInfoFiles) {
                byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(secKeyInfoFile.getName());
                String hexId = Hex.toHexString((byte[])id);
                try {
                    props = this.loadProperties(secKeyInfoFile);
                    label = props.getProperty(PROP_LABEL);
                    P11ObjectIdentifier p11ObjId = new P11ObjectIdentifier(id, label);
                    byte[] encodedValue = IoUtil.read((File)new File(this.secKeyDir, hexId + VALUE_FILE_SUFFIX));
                    KeyStore ks = KeyStore.getInstance("JCEKS");
                    ks.load(new ByteArrayInputStream(encodedValue), this.password);
                    SecretKey key = null;
                    Enumeration<String> aliases = ks.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!ks.isKeyEntry(alias)) continue;
                        key = (SecretKey)ks.getKey(alias, this.password);
                        break;
                    }
                    EmulatorP11Identity identity = new EmulatorP11Identity(this, new P11EntityIdentifier(this.slotId, p11ObjId), key, this.maxSessions, this.random);
                    LOG.info("added PKCS#11 secret key {}", (Object)p11ObjId);
                    ret.addIdentity(identity);
                }
                catch (ClassCastException | InvalidKeyException ex) {
                    LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("InvalidKeyException while initializing key with key-id " + hexId));
                }
                catch (Throwable th) {
                    LOG.error("unexpected exception while initializing key with key-id " + hexId, th);
                }
            }
        }
        if ((certInfoFiles = this.certDir.listFiles(INFO_FILENAME_FILTER)) != null) {
            for (File infoFile : certInfoFiles) {
                byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName());
                props = this.loadProperties(infoFile);
                label = props.getProperty(PROP_LABEL);
                P11ObjectIdentifier objId = new P11ObjectIdentifier(id, label);
                try {
                    X509Cert cert = this.readCertificate(id);
                    ret.addCertificate(objId, cert);
                }
                catch (IOException | CertificateException ex) {
                    LOG.warn("could not parse certificate " + objId);
                }
            }
        }
        if ((privKeyInfoFiles = this.privKeyDir.listFiles(INFO_FILENAME_FILTER)) != null && privKeyInfoFiles.length != 0) {
            for (File privKeyInfoFile : privKeyInfoFiles) {
                byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(privKeyInfoFile.getName());
                String hexId = Hex.toHexString((byte[])id);
                try {
                    X509Certificate[] x509CertificateArray;
                    PublicKey publicKey;
                    Properties props2 = this.loadProperties(privKeyInfoFile);
                    String label2 = props2.getProperty(PROP_LABEL);
                    P11ObjectIdentifier p11ObjId = new P11ObjectIdentifier(id, label2);
                    X509Cert cert = ret.getCertForId(id);
                    PublicKey publicKey2 = publicKey = cert == null ? this.readPublicKey(id) : cert.cert().getPublicKey();
                    if (publicKey == null) {
                        LOG.warn("Neither public key nor certificate is associated with private key {}", (Object)p11ObjId);
                        continue;
                    }
                    byte[] encodedValue = IoUtil.read((File)new File(this.privKeyDir, hexId + VALUE_FILE_SUFFIX));
                    PKCS8EncryptedPrivateKeyInfo epki = new PKCS8EncryptedPrivateKeyInfo(encodedValue);
                    PrivateKey privateKey = this.privateKeyCryptor.decrypt(epki);
                    if (cert == null) {
                        x509CertificateArray = null;
                    } else {
                        X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                        x509CertificateArray = x509CertificateArray2;
                        x509CertificateArray2[0] = cert.cert();
                    }
                    X509Certificate[] certs = x509CertificateArray;
                    EmulatorP11Identity identity = new EmulatorP11Identity(this, new P11EntityIdentifier(this.slotId, p11ObjId), privateKey, publicKey, certs, this.maxSessions, this.random);
                    LOG.info("added PKCS#11 key {}", (Object)p11ObjId);
                    ret.addIdentity(identity);
                }
                catch (InvalidKeyException ex) {
                    LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("InvalidKeyException while initializing key with key-id " + hexId));
                }
                catch (Throwable th) {
                    LOG.error("unexpected exception while initializing key with key-id " + hexId, th);
                }
            }
        }
        return ret;
    }

    File slotDir() {
        return this.slotDir;
    }

    private PublicKey readPublicKey(byte[] keyId) throws P11TokenException {
        String hexKeyId = Hex.toHexString((byte[])keyId);
        File pubKeyFile = new File(this.pubKeyDir, hexKeyId + INFO_FILE_SUFFIX);
        Properties props = this.loadProperties(pubKeyFile);
        String algorithm = props.getProperty(PROP_ALGORITHM);
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(algorithm)) {
            BigInteger exp = new BigInteger(1, Hex.decode((String)props.getProperty(PROP_RSA_PUBLIC_EXPONENT)));
            BigInteger mod = new BigInteger(1, Hex.decode((String)props.getProperty(PROP_RSA_MODUS)));
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
            try {
                return KeyUtil.generateRSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        if (X9ObjectIdentifiers.id_dsa.getId().equals(algorithm)) {
            BigInteger prime = new BigInteger(1, Hex.decode((String)props.getProperty(PROP_DSA_PRIME)));
            BigInteger subPrime = new BigInteger(1, Hex.decode((String)props.getProperty(PROP_DSA_SUBPRIME)));
            BigInteger base = new BigInteger(1, Hex.decode((String)props.getProperty(PROP_DSA_BASE)));
            BigInteger value = new BigInteger(1, Hex.decode((String)props.getProperty(PROP_DSA_VALUE)));
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(value, prime, subPrime, base);
            try {
                return KeyUtil.generateDSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(algorithm)) {
            byte[] ecdsaParams = Hex.decode((String)props.getProperty(PROP_EC_ECDSA_PARAMS));
            byte[] asn1EncodedPoint = Hex.decode((String)props.getProperty(PROP_EC_EC_POINT));
            byte[] ecPoint = DEROctetString.getInstance((Object)asn1EncodedPoint).getOctets();
            try {
                return KeyUtil.createECPublicKey(ecdsaParams, ecPoint);
            }
            catch (InvalidKeySpecException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        throw new P11TokenException("unknown key algorithm " + algorithm);
    }

    private X509Cert readCertificate(byte[] keyId) throws CertificateException, IOException {
        byte[] encoded = IoUtil.read((File)new File(this.certDir, Hex.toHexString((byte[])keyId) + VALUE_FILE_SUFFIX));
        X509Certificate cert = X509Util.parseCert(encoded);
        return new X509Cert(cert, encoded);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties(File file) throws P11TokenException {
        try (FileInputStream stream = new FileInputStream(file);){
            Properties props = new Properties();
            props.load(stream);
            Properties properties = props;
            return properties;
        }
        catch (IOException ex) {
            throw new P11TokenException("could not load properties from the file " + file.getPath(), ex);
        }
    }

    private static byte[] getKeyIdFromInfoFilename(String fileName) {
        return Hex.decode((String)fileName.substring(0, fileName.length() - INFO_FILE_SUFFIX.length()));
    }

    @Override
    public void close() {
        LOG.info("close slot " + this.slotId);
    }

    private boolean removePkcs11Cert(P11ObjectIdentifier objectId) throws P11TokenException {
        return this.removePkcs11Entry(this.certDir, objectId);
    }

    private boolean removePkcs11Entry(File dir, P11ObjectIdentifier objectId) throws P11TokenException {
        byte[] id = objectId.id();
        String label = objectId.label();
        if (id != null) {
            String hextId = Hex.toHexString((byte[])id);
            File infoFile = new File(dir, hextId + INFO_FILE_SUFFIX);
            if (!infoFile.exists()) {
                return false;
            }
            if (StringUtil.isBlank((String)label)) {
                return EmulatorP11Slot.deletePkcs11Entry(dir, id);
            }
            Properties props = this.loadProperties(infoFile);
            return label.equals(props.getProperty(PROP_LABEL)) ? EmulatorP11Slot.deletePkcs11Entry(dir, id) : false;
        }
        boolean deleted = false;
        File[] infoFiles = dir.listFiles(INFO_FILENAME_FILTER);
        if (infoFiles != null) {
            for (File infoFile : infoFiles) {
                Properties props;
                if (!infoFile.isFile() || !label.equals((props = this.loadProperties(infoFile)).getProperty(PROP_LABEL)) || !EmulatorP11Slot.deletePkcs11Entry(dir, EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName()))) continue;
                deleted = true;
            }
        }
        return deleted;
    }

    private static boolean deletePkcs11Entry(File dir, byte[] objectId) {
        String hextId = Hex.toHexString((byte[])objectId);
        File infoFile = new File(dir, hextId + INFO_FILE_SUFFIX);
        boolean b1 = true;
        if (infoFile.exists()) {
            b1 = infoFile.delete();
        }
        File valueFile = new File(dir, hextId + VALUE_FILE_SUFFIX);
        boolean b2 = true;
        if (valueFile.exists()) {
            b2 = valueFile.delete();
        }
        return b1 || b2;
    }

    private int deletePkcs11Entry(File dir, byte[] id, String label) throws P11TokenException {
        if (StringUtil.isBlank((String)label)) {
            return EmulatorP11Slot.deletePkcs11Entry(dir, id) ? 1 : 0;
        }
        if (id != null && id.length > 0) {
            String hextId = Hex.toHexString((byte[])id);
            File infoFile = new File(dir, hextId + INFO_FILE_SUFFIX);
            if (!infoFile.exists()) {
                return 0;
            }
            Properties props = this.loadProperties(infoFile);
            if (!label.equals(props.get(PROP_LABEL))) {
                return 0;
            }
            return EmulatorP11Slot.deletePkcs11Entry(dir, id) ? 1 : 0;
        }
        File[] infoFiles = dir.listFiles(INFO_FILENAME_FILTER);
        if (infoFiles == null || infoFiles.length == 0) {
            return 0;
        }
        LinkedList<byte[]> ids = new LinkedList<byte[]>();
        for (File infoFile : infoFiles) {
            Properties props = this.loadProperties(infoFile);
            if (!label.equals(props.getProperty(PROP_LABEL))) continue;
            ids.add(EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName()));
        }
        if (ids.isEmpty()) {
            return 0;
        }
        for (byte[] m : ids) {
            EmulatorP11Slot.deletePkcs11Entry(dir, m);
        }
        return ids.size();
    }

    private void savePkcs11SecretKey(byte[] id, String label, SecretKey secretKey) throws P11TokenException {
        byte[] encrytedValue;
        try {
            KeyStore ks = KeyStore.getInstance("JCEKS");
            ks.load(null, this.password);
            ks.setKeyEntry("main", secretKey, this.password, null);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ks.store(outStream, this.password);
            outStream.flush();
            encrytedValue = outStream.toByteArray();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new P11TokenException(ex.getClass().getName() + ": " + ex.getMessage(), ex);
        }
        EmulatorP11Slot.savePkcs11Entry(this.secKeyDir, id, label, encrytedValue);
    }

    private void savePkcs11PrivateKey(byte[] id, String label, PrivateKey privateKey) throws P11TokenException {
        byte[] encoded;
        PKCS8EncryptedPrivateKeyInfo encryptedPrivKeyInfo = this.privateKeyCryptor.encrypt(privateKey);
        try {
            encoded = encryptedPrivKeyInfo.getEncoded();
        }
        catch (IOException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            throw new P11TokenException("could not encode PrivateKey");
        }
        EmulatorP11Slot.savePkcs11Entry(this.privKeyDir, id, label, encoded);
    }

    private void savePkcs11PublicKey(byte[] id, String label, PublicKey publicKey) throws P11TokenException {
        String hexId = Hex.toHexString((byte[])id).toLowerCase();
        StringBuilder sb = new StringBuilder(100);
        sb.append(PROP_ID).append('=').append(hexId).append('\n');
        sb.append(PROP_LABEL).append('=').append(label).append('\n');
        if (publicKey instanceof RSAPublicKey) {
            sb.append(PROP_ALGORITHM).append('=');
            sb.append(PKCSObjectIdentifiers.rsaEncryption.getId());
            sb.append('\n');
            sb.append(PROP_RSA_MODUS).append('=');
            RSAPublicKey rsaKey = (RSAPublicKey)publicKey;
            sb.append(Hex.toHexString((byte[])rsaKey.getModulus().toByteArray()));
            sb.append('\n');
            sb.append(PROP_RSA_PUBLIC_EXPONENT).append('=');
            sb.append(Hex.toHexString((byte[])rsaKey.getPublicExponent().toByteArray()));
            sb.append('\n');
        } else if (publicKey instanceof DSAPublicKey) {
            sb.append(PROP_ALGORITHM).append('=');
            sb.append(X9ObjectIdentifiers.id_dsa.getId());
            sb.append('\n');
            sb.append(PROP_DSA_PRIME).append('=');
            DSAPublicKey dsaKey = (DSAPublicKey)publicKey;
            sb.append(Hex.toHexString((byte[])dsaKey.getParams().getP().toByteArray()));
            sb.append('\n');
            sb.append(PROP_DSA_SUBPRIME).append('=');
            sb.append(Hex.toHexString((byte[])dsaKey.getParams().getQ().toByteArray()));
            sb.append('\n');
            sb.append(PROP_DSA_BASE).append('=');
            sb.append(Hex.toHexString((byte[])dsaKey.getParams().getG().toByteArray()));
            sb.append('\n');
            sb.append(PROP_DSA_VALUE).append('=');
            sb.append(Hex.toHexString((byte[])dsaKey.getY().toByteArray()));
            sb.append('\n');
        } else if (publicKey instanceof ECPublicKey) {
            byte[] encodedEcPoint;
            byte[] encodedParams;
            sb.append(PROP_ALGORITHM).append('=');
            sb.append(X9ObjectIdentifiers.id_ecPublicKey.getId());
            sb.append('\n');
            ECPublicKey ecKey = (ECPublicKey)publicKey;
            ECParameterSpec paramSpec = ecKey.getParams();
            org.bouncycastle.jce.spec.ECParameterSpec bcParamSpec = EC5Util.convertSpec((ECParameterSpec)paramSpec, (boolean)false);
            ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid((org.bouncycastle.jce.spec.ECParameterSpec)bcParamSpec);
            if (curveOid == null) {
                throw new P11TokenException("EC public key is not of namedCurve");
            }
            try {
                encodedParams = this.namedCurveSupported ? curveOid.getEncoded() : ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveOid).getEncoded();
            }
            catch (IOException | NullPointerException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
            sb.append(PROP_EC_ECDSA_PARAMS).append('=');
            sb.append(Hex.toHexString((byte[])encodedParams));
            sb.append('\n');
            ECPoint pointW = ecKey.getW();
            int keysize = (paramSpec.getOrder().bitLength() + 7) / 8;
            byte[] ecPoint = new byte[1 + keysize * 2];
            ecPoint[0] = 4;
            EmulatorP11Slot.bigIntToBytes("Wx", pointW.getAffineX(), ecPoint, 1, keysize);
            EmulatorP11Slot.bigIntToBytes("Wy", pointW.getAffineY(), ecPoint, 1 + keysize, keysize);
            try {
                encodedEcPoint = new DEROctetString(ecPoint).getEncoded();
            }
            catch (IOException ex) {
                throw new P11TokenException("could not ASN.1 encode the ECPoint");
            }
            sb.append(PROP_EC_EC_POINT).append('=');
            sb.append(Hex.toHexString((byte[])encodedEcPoint));
            sb.append('\n');
        } else {
            throw new IllegalArgumentException("unsupported public key " + publicKey.getClass().getName());
        }
        try {
            IoUtil.save((File)new File(this.pubKeyDir, hexId + INFO_FILE_SUFFIX), (byte[])sb.toString().getBytes());
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    private static void bigIntToBytes(String numName, BigInteger num, byte[] dest, int destPos, int length) throws P11TokenException {
        if (num.signum() != 1) {
            throw new P11TokenException(numName + " is not positive");
        }
        byte[] bytes = num.toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, dest, destPos, length);
        } else if (bytes.length < length) {
            System.arraycopy(bytes, 0, dest, destPos + length - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, bytes.length - length, dest, destPos, length);
        }
    }

    private void savePkcs11Cert(byte[] id, String label, X509Certificate cert) throws P11TokenException, CertificateException {
        EmulatorP11Slot.savePkcs11Entry(this.certDir, id, label, cert.getEncoded());
    }

    private static void savePkcs11Entry(File dir, byte[] id, String label, byte[] value) throws P11TokenException {
        ParamUtil.requireNonNull((String)"dir", (Object)dir);
        ParamUtil.requireNonNull((String)PROP_ID, (Object)id);
        ParamUtil.requireNonBlank((String)PROP_LABEL, (String)label);
        ParamUtil.requireNonNull((String)PROP_DSA_VALUE, (Object)value);
        String hexId = Hex.toHexString((byte[])id).toLowerCase();
        StringBuilder sb = new StringBuilder(200);
        sb.append(PROP_ID).append('=').append(hexId).append('\n');
        sb.append(PROP_LABEL).append('=').append(label).append('\n');
        sb.append(PROP_SHA1SUM).append('=').append(HashAlgoType.SHA1.hexHash(value)).append('\n');
        try {
            IoUtil.save((File)new File(dir, hexId + INFO_FILE_SUFFIX), (byte[])sb.toString().getBytes());
            IoUtil.save((File)new File(dir, hexId + VALUE_FILE_SUFFIX), (byte[])value);
        }
        catch (IOException ex) {
            throw new P11TokenException("could not save certificate");
        }
    }

    @Override
    public int removeObjects(byte[] id, String label) throws P11TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            throw new IllegalArgumentException("at least one of id and label must not be null");
        }
        int num = this.deletePkcs11Entry(this.privKeyDir, id, label);
        num += this.deletePkcs11Entry(this.pubKeyDir, id, label);
        num += this.deletePkcs11Entry(this.certDir, id, label);
        return num += this.deletePkcs11Entry(this.secKeyDir, id, label);
    }

    @Override
    protected void removeIdentity0(P11ObjectIdentifier objectId) throws P11TokenException {
        boolean b1 = this.removePkcs11Entry(this.certDir, objectId);
        boolean b2 = this.removePkcs11Entry(this.privKeyDir, objectId);
        boolean b3 = this.removePkcs11Entry(this.pubKeyDir, objectId);
        boolean b4 = this.removePkcs11Entry(this.secKeyDir, objectId);
        if (!(b1 || b2 || b3 || b4)) {
            throw new P11UnknownEntityException(this.slotId, objectId);
        }
    }

    @Override
    protected void removeCerts0(P11ObjectIdentifier objectId) throws P11TokenException {
        EmulatorP11Slot.deletePkcs11Entry(this.certDir, objectId.id());
    }

    @Override
    protected void addCert0(P11ObjectIdentifier objectId, X509Certificate cert) throws P11TokenException, CertificateException {
        this.savePkcs11Cert(objectId.id(), objectId.label(), cert);
    }

    @Override
    protected P11Identity generateSecretKey0(long keyType, int keysize, String label, P11NewKeyControl control) throws P11TokenException {
        if (keysize % 8 != 0) {
            throw new IllegalArgumentException("keysize is not multiple of 8: " + keysize);
        }
        byte[] keyBytes = new byte[keysize / 8];
        this.random.nextBytes(keyBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, EmulatorP11Slot.getSecretKeyAlgorithm(keyType));
        return this.saveP11Entity(key, label);
    }

    @Override
    protected P11Identity createSecretKey0(long keyType, byte[] keyValue, String label, P11NewKeyControl control) throws P11TokenException {
        SecretKeySpec key = new SecretKeySpec(keyValue, EmulatorP11Slot.getSecretKeyAlgorithm(keyType));
        return this.saveP11Entity(key, label);
    }

    private static String getSecretKeyAlgorithm(long keyType) {
        String algorithm;
        if (16L == keyType) {
            algorithm = "generic";
        } else if (31L == keyType) {
            algorithm = "AES";
        } else if (40L == keyType) {
            algorithm = "HMACSHA1";
        } else if (46L == keyType) {
            algorithm = "HMACSHA224";
        } else if (43L == keyType) {
            algorithm = "HMACSHA256";
        } else if (44L == keyType) {
            algorithm = "HMACSHA384";
        } else if (45L == keyType) {
            algorithm = "HMACSHA512";
        } else if (51L == keyType) {
            algorithm = "HMACSHA3-224";
        } else if (52L == keyType) {
            algorithm = "HMACSHA3-256";
        } else if (53L == keyType) {
            algorithm = "HMACSHA3-384";
        } else if (54L == keyType) {
            algorithm = "HMACSHA3-512";
        } else {
            throw new IllegalArgumentException("unsupported keyType " + keyType);
        }
        return algorithm;
    }

    @Override
    protected P11Identity generateRSAKeypair0(int keysize, BigInteger publicExponent, String label, P11NewKeyControl control) throws P11TokenException {
        KeyPair keypair;
        try {
            keypair = KeyUtil.generateRSAKeypair(keysize, publicExponent, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return this.saveP11Entity(keypair, label);
    }

    @Override
    protected P11Identity generateDSAKeypair0(BigInteger p, BigInteger q, BigInteger g, String label, P11NewKeyControl control) throws P11TokenException {
        KeyPair keypair;
        DSAParameters dsaParams = new DSAParameters(p, q, g);
        try {
            keypair = KeyUtil.generateDSAKeypair(dsaParams, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return this.saveP11Entity(keypair, label);
    }

    @Override
    protected P11Identity generateECKeypair0(ASN1ObjectIdentifier curveId, String label, P11NewKeyControl control) throws P11TokenException {
        KeyPair keypair;
        try {
            keypair = KeyUtil.generateECKeypairForCurveNameOrOid(curveId.getId(), this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return this.saveP11Entity(keypair, label);
    }

    private P11Identity saveP11Entity(KeyPair keypair, String label) throws P11TokenException {
        byte[] id = this.generateId();
        this.savePkcs11PrivateKey(id, label, keypair.getPrivate());
        this.savePkcs11PublicKey(id, label, keypair.getPublic());
        P11EntityIdentifier identityId = new P11EntityIdentifier(this.slotId, new P11ObjectIdentifier(id, label));
        try {
            return new EmulatorP11Identity(this, identityId, keypair.getPrivate(), keypair.getPublic(), null, this.maxSessions, this.random);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException("could not construct KeyStoreP11Identity: " + ex.getMessage(), ex);
        }
    }

    private P11Identity saveP11Entity(SecretKey key, String label) throws P11TokenException {
        byte[] id = this.generateId();
        this.savePkcs11SecretKey(id, label, key);
        P11EntityIdentifier identityId = new P11EntityIdentifier(this.slotId, new P11ObjectIdentifier(id, label));
        try {
            return new EmulatorP11Identity(this, identityId, key, this.maxSessions, this.random);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException("could not construct KeyStoreP11Identity: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected void updateCertificate0(P11ObjectIdentifier objectId, X509Certificate newCert) throws P11TokenException, CertificateException {
        this.removePkcs11Cert(objectId);
        this.addCert0(objectId, newCert);
    }

    private static class InfoFilenameFilter
    implements FilenameFilter {
        private InfoFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(EmulatorP11Slot.INFO_FILE_SUFFIX);
        }
    }
}

