/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.xipki.common.util.ParamUtil;

public class P11SlotIdentifier
implements Comparable<P11SlotIdentifier> {
    private final int index;
    private final long id;

    public P11SlotIdentifier(int index, long id) {
        this.index = ParamUtil.requireMin((String)"index", (int)index, (int)0);
        this.id = ParamUtil.requireMin((String)"id", (long)id, (long)0L);
    }

    public int index() {
        return this.index;
    }

    public long id() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof P11SlotIdentifier)) {
            return false;
        }
        P11SlotIdentifier another = (P11SlotIdentifier)obj;
        return this.id == another.id && this.index == another.index;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append("(index = ").append(this.index).append(", id = ").append(this.id).append(")");
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = Long.hashCode(this.id);
        return hashCode += 31 * this.index;
    }

    @Override
    public int compareTo(P11SlotIdentifier obj) {
        ParamUtil.requireNonNull((String)"obj", (Object)obj);
        if (this == obj) {
            return 0;
        }
        int sign = this.index - obj.index;
        if (sign > 0) {
            return 1;
        }
        if (sign < 0) {
            return -1;
        }
        return 0;
    }
}

