/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.xipki.security.pkcs11.P11SlotIdentifier;

class P11SlotIdFilter {
    private final Integer index;
    private final Long id;

    P11SlotIdFilter(Integer index, Long id) {
        if (index == null && id == null) {
            throw new IllegalArgumentException("at least one of index and id must not be null");
        }
        this.index = index;
        this.id = id;
    }

    boolean match(P11SlotIdentifier slotId) {
        if (this.index != null && this.index.intValue() != slotId.index()) {
            return false;
        }
        return this.id == null || this.id.longValue() == slotId.id();
    }
}

