/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.HashAlgoType;
import org.xipki.security.HashCalculator;

public class IssuerHash {
    private final HashAlgoType hashAlgo;
    private final byte[] issuerNameHash;
    private final byte[] issuerKeyHash;

    public IssuerHash(HashAlgoType hashAlgo, byte[] issuerNameHash, byte[] issuerKeyHash) {
        this.hashAlgo = (HashAlgoType)((Object)ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo)));
        this.issuerNameHash = (byte[])ParamUtil.requireNonNull((String)"issuerNameHash", (Object)issuerNameHash);
        this.issuerKeyHash = (byte[])ParamUtil.requireNonNull((String)"issuerKeyHash", (Object)issuerKeyHash);
        int len = hashAlgo.length();
        ParamUtil.requireRange((String)"issuerNameHash.length", (int)issuerNameHash.length, (int)len, (int)len);
        ParamUtil.requireRange((String)"issuerKeyHash.length", (int)issuerKeyHash.length, (int)len, (int)len);
    }

    public IssuerHash(HashAlgoType hashAlgo, Certificate issuerCert) throws IOException {
        this.hashAlgo = (HashAlgoType)((Object)ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo)));
        ParamUtil.requireNonNull((String)"issuerCert", (Object)issuerCert);
        byte[] encodedName = issuerCert.getSubject().getEncoded();
        byte[] encodedKey = issuerCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        this.issuerNameHash = HashCalculator.hash(hashAlgo, encodedName);
        this.issuerKeyHash = HashCalculator.hash(hashAlgo, encodedKey);
    }

    public HashAlgoType hashAlgo() {
        return this.hashAlgo;
    }

    public byte[] issuerNameHash() {
        return Arrays.copyOf(this.issuerNameHash, this.issuerNameHash.length);
    }

    public byte[] issuerKeyHash() {
        return Arrays.copyOf(this.issuerKeyHash, this.issuerKeyHash.length);
    }

    public boolean match(HashAlgoType hashAlgo, byte[] issuerNameHash, byte[] issuerKeyHash) {
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
        ParamUtil.requireNonNull((String)"issuerNameHash", (Object)issuerNameHash);
        ParamUtil.requireNonNull((String)"issuerKeyHash", (Object)issuerKeyHash);
        return this.hashAlgo == hashAlgo && Arrays.equals(this.issuerNameHash, issuerNameHash) && Arrays.equals(this.issuerKeyHash, issuerKeyHash);
    }
}

