/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.Key;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.xipki.password.PasswordResolver;
import org.xipki.security.AlgorithmCode;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.exception.NoIdleSignerException;
import org.xipki.security.exception.XiSecurityException;

public interface ConcurrentContentSigner {
    public String getName();

    public String getAlgorithmName();

    public AlgorithmCode algorithmCode();

    public boolean isMac();

    public byte[] getSha1DigestOfMacKey();

    public Key getSigningKey();

    public void setPublicKey(PublicKey var1);

    public PublicKey getPublicKey();

    public X509Certificate getCertificate();

    public X509CertificateHolder getCertificateAsBcObject();

    public void setCertificateChain(X509Certificate[] var1);

    public X509Certificate[] getCertificateChain();

    public X509CertificateHolder[] getCertificateChainAsBcObjects();

    public void initialize(String var1, PasswordResolver var2) throws XiSecurityException;

    public byte[] sign(byte[] var1) throws NoIdleSignerException, SignatureException;

    public ConcurrentBagEntrySigner borrowContentSigner() throws NoIdleSignerException;

    public ConcurrentBagEntrySigner borrowContentSigner(int var1) throws NoIdleSignerException;

    public void requiteContentSigner(ConcurrentBagEntrySigner var1);

    public boolean isHealthy();

    public void shutdown();
}

