/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.util.Date;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.CrlReason;

public class CertRevocationInfo {
    private CrlReason reason;
    private Date revocationTime;
    private Date invalidityTime;

    public CertRevocationInfo(CrlReason reason) {
        this(reason, new Date(), null);
    }

    public CertRevocationInfo(int reasonCode) {
        this(reasonCode, new Date(), null);
    }

    public CertRevocationInfo(CrlReason reason, Date revocationTime, Date invalidityTime) {
        this.reason = (CrlReason)((Object)ParamUtil.requireNonNull((String)"reason", (Object)((Object)reason)));
        this.revocationTime = (Date)ParamUtil.requireNonNull((String)"revocationTime", (Object)revocationTime);
        this.invalidityTime = invalidityTime;
    }

    public CertRevocationInfo(int reasonCode, Date revocationTime, Date invalidityTime) {
        this.revocationTime = (Date)ParamUtil.requireNonNull((String)"revocationTime", (Object)revocationTime);
        this.reason = CrlReason.forReasonCode(reasonCode);
        this.invalidityTime = invalidityTime;
    }

    public void setReason(CrlReason reason) {
        this.reason = (CrlReason)((Object)ParamUtil.requireNonNull((String)"reason", (Object)((Object)reason)));
    }

    public CrlReason reason() {
        return this.reason;
    }

    public void setRevocationTime(Date revocationTime) {
        this.revocationTime = revocationTime;
    }

    public Date revocationTime() {
        if (this.revocationTime == null) {
            this.revocationTime = new Date();
        }
        return this.revocationTime;
    }

    public Date invalidityTime() {
        return this.invalidityTime;
    }

    public void setInvalidityTime(Date invalidityTime) {
        this.invalidityTime = invalidityTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("reason: ").append((Object)this.reason).append("\n");
        sb.append("revocationTime: ").append(this.revocationTime).append("\n");
        sb.append("invalidityTime: ").append(this.invalidityTime);
        return sb.toString();
    }
}

