/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.xipki.common.ObjectCreationException;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;

public abstract class AbstractSecurityFactory
implements SecurityFactory {
    @Override
    public ConcurrentContentSigner createSigner(String type, SignerConf conf, X509Certificate cert) throws ObjectCreationException {
        X509Certificate[] x509CertificateArray;
        if (cert == null) {
            x509CertificateArray = null;
        } else {
            X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
            x509CertificateArray = x509CertificateArray2;
            x509CertificateArray2[0] = cert;
        }
        X509Certificate[] certs = x509CertificateArray;
        return this.createSigner(type, conf, certs);
    }

    @Override
    public ContentVerifierProvider getContentVerifierProvider(X509Certificate cert) throws InvalidKeyException {
        ParamUtil.requireNonNull((String)"cert", (Object)cert);
        return this.getContentVerifierProvider(cert.getPublicKey());
    }

    @Override
    public ContentVerifierProvider getContentVerifierProvider(X509CertificateHolder cert) throws InvalidKeyException {
        ParamUtil.requireNonNull((String)"cert", (Object)cert);
        PublicKey publicKey = this.generatePublicKey(cert.getSubjectPublicKeyInfo());
        return this.getContentVerifierProvider(publicKey);
    }
}

