/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.cert.CRLReason;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xipki.util.ParamUtil;

public enum CrlReason {
    UNSPECIFIED(0, "unspecified"),
    KEY_COMPROMISE(1, "keyCompromise"),
    CA_COMPROMISE(2, "cACompromise"),
    AFFILIATION_CHANGED(3, "affiliationChanged"),
    SUPERSEDED(4, "superseded"),
    CESSATION_OF_OPERATION(5, "cessationOfOperation"),
    CERTIFICATE_HOLD(6, "certificateHold"),
    REMOVE_FROM_CRL(8, "removeFromCRL"),
    PRIVILEGE_WITHDRAWN(9, "privilegeWithdrawn"),
    AA_COMPROMISE(10, "aACompromise");

    public static final List<CrlReason> PERMITTED_CLIENT_CRLREASONS;
    private static final Map<Integer, CrlReason> REASONS;
    private final int code;
    private final String desription;

    private CrlReason(int code, String description) {
        this.code = code;
        this.desription = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.desription;
    }

    public static CrlReason forReasonCode(int reasonCode) {
        CrlReason ret = REASONS.get(reasonCode);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("invalid CrlReason code " + reasonCode);
    }

    public static CrlReason fromReason(CRLReason reason) {
        if (reason == CRLReason.AA_COMPROMISE) {
            return AA_COMPROMISE;
        }
        if (reason == CRLReason.AFFILIATION_CHANGED) {
            return AFFILIATION_CHANGED;
        }
        if (reason == CRLReason.CA_COMPROMISE) {
            return CA_COMPROMISE;
        }
        if (reason == CRLReason.CERTIFICATE_HOLD) {
            return CERTIFICATE_HOLD;
        }
        if (reason == CRLReason.CESSATION_OF_OPERATION) {
            return CESSATION_OF_OPERATION;
        }
        if (reason == CRLReason.KEY_COMPROMISE) {
            return KEY_COMPROMISE;
        }
        if (reason == CRLReason.PRIVILEGE_WITHDRAWN) {
            return PRIVILEGE_WITHDRAWN;
        }
        if (reason == CRLReason.REMOVE_FROM_CRL) {
            return REMOVE_FROM_CRL;
        }
        if (reason == CRLReason.SUPERSEDED) {
            return SUPERSEDED;
        }
        if (reason == CRLReason.UNSPECIFIED) {
            return UNSPECIFIED;
        }
        throw new IllegalArgumentException("invald CRLReason " + (Object)((Object)reason));
    }

    public static CrlReason forNameOrText(String text) {
        ParamUtil.requireNonNull((String)"text", (Object)text);
        for (CrlReason value : CrlReason.values()) {
            if (!value.desription.equalsIgnoreCase(text) && !value.name().equalsIgnoreCase(text) && !Integer.toString(value.code).equals(text)) continue;
            return value;
        }
        throw new IllegalArgumentException("invalid CrlReason " + text);
    }

    static {
        PERMITTED_CLIENT_CRLREASONS = Collections.unmodifiableList(Arrays.asList(UNSPECIFIED, KEY_COMPROMISE, AFFILIATION_CHANGED, SUPERSEDED, CESSATION_OF_OPERATION, CERTIFICATE_HOLD, PRIVILEGE_WITHDRAWN));
        REASONS = new HashMap<Integer, CrlReason>();
        for (CrlReason value : CrlReason.values()) {
            REASONS.put(value.code, value);
        }
    }
}

