/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.jscepclient.shell;

import java.io.File;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.jscep.client.Client;
import org.xipki.scep.jscepclient.shell.ClientAction;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.completer.DerPemCompleter;

@Command(scope="xi", name="jscep-getcrl", description="download CRL")
@Service
public class GetCrlAction
extends ClientAction {
    @Option(name="--cert", aliases={"-c"}, required=true, description="certificate")
    @Completion(value=FileCompleter.class)
    private String certFile;
    @Option(name="--outform", description="output format of the CRL")
    @Completion(value=DerPemCompleter.class)
    protected String outform = "der";
    @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CRL")
    @Completion(value=FileCompleter.class)
    private String outputFile;

    protected Object execute0() throws Exception {
        X509Certificate cert = X509Util.parseCert((File)new File(this.certFile));
        Client client = this.getScepClient();
        X509CRL crl = client.getRevocationList(this.getIdentityCert(), this.getIdentityKey(), cert.getIssuerX500Principal(), cert.getSerialNumber());
        if (crl == null) {
            throw new CmdFailure("received no CRL from server");
        }
        this.saveVerbose("saved CRL to file", new File(this.outputFile), this.derPemEncodeCrl(crl.getEncoded(), this.outform));
        return null;
    }
}

