/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.jscepclient.shell;

import java.io.File;
import java.security.cert.X509Certificate;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.jscep.client.Client;
import org.jscep.client.EnrollmentResponse;
import org.xipki.scep.jscepclient.shell.ClientAction;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.completer.DerPemCompleter;

@Command(scope="xi", name="jscep-enroll", description="enroll certificate via automatic selected messageType")
@Service
public class EnrollCertAction
extends ClientAction {
    @Option(name="--csr", required=true, description="CSR file")
    @Completion(value=FileCompleter.class)
    private String csrFile;
    @Option(name="--outform", description="output format of the certificate")
    @Completion(value=DerPemCompleter.class)
    protected String outform = "der";
    @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
    @Completion(value=FileCompleter.class)
    private String outputFile;

    protected Object execute0() throws Exception {
        Client client = this.getScepClient();
        PKCS10CertificationRequest csr = new PKCS10CertificationRequest(X509Util.parseCsr((File)new File(this.csrFile)));
        EnrollmentResponse resp = client.enrol(this.getIdentityCert(), this.getIdentityKey(), csr);
        if (resp.isFailure()) {
            throw new CmdFailure("server returned 'failure'");
        }
        if (resp.isPending()) {
            throw new CmdFailure("server returned 'pending'");
        }
        X509Certificate cert = this.extractEeCerts(resp.getCertStore());
        if (cert == null) {
            throw new Exception("received no certificate");
        }
        this.saveVerbose("saved enrolled certificate to file", new File(this.outputFile), this.derPemEncodeCert(cert.getEncoded(), this.outform));
        return null;
    }
}

