/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.jscepclient.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.jscep.client.Client;
import org.jscep.client.verification.CertificateVerifier;
import org.jscep.client.verification.PreProvisionedCertificateVerifier;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.XiAction;
import org.xipki.util.ParamUtil;

public abstract class ClientAction
extends XiAction {
    @Option(name="--url", required=true, description="URL of the SCEP server")
    private String url;
    @Option(name="--ca-id", description="CA identifier")
    private String caId;
    @Option(name="--ca-cert", required=true, description="CA certificate")
    @Completion(value=FileCompleter.class)
    private String caCertFile;
    @Option(name="--p12", required=true, description="PKCS#12 keystore file")
    @Completion(value=FileCompleter.class)
    private String p12File;
    @Option(name="--password", description="password of the PKCS#12 file")
    private String password;
    private Client scepClient;
    private PrivateKey identityKey;
    private X509Certificate identityCert;

    protected Client getScepClient() throws CertificateException, IOException {
        if (this.scepClient == null) {
            X509Certificate caCert = X509Util.parseCert((File)new File(this.caCertFile));
            this.scepClient = new Client(new URL(this.url), (CertificateVerifier)new PreProvisionedCertificateVerifier(caCert));
        }
        return this.scepClient;
    }

    protected PrivateKey getIdentityKey() throws Exception {
        if (this.identityKey == null) {
            this.readIdentity();
        }
        return this.identityKey;
    }

    protected X509Certificate getIdentityCert() throws Exception {
        if (this.identityCert == null) {
            this.readIdentity();
        }
        return this.identityCert;
    }

    private void readIdentity() throws Exception {
        char[] pwd = this.readPasswordIfNotSet(this.password);
        KeyStore ks = KeyUtil.getKeyStore((String)"PKCS12");
        ks.load(new FileInputStream(this.p12File), pwd);
        String keyname = null;
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            keyname = alias;
            break;
        }
        if (keyname == null) {
            throw new Exception("no key entry is contained in the keystore");
        }
        this.identityKey = (PrivateKey)ks.getKey(keyname, pwd);
        this.identityCert = (X509Certificate)ks.getCertificate(keyname);
    }

    protected X509Certificate extractEeCerts(CertStore certstore) throws CertStoreException {
        ParamUtil.requireNonNull((String)"certstore", (Object)certstore);
        for (X509Certificate x509Certificate : certstore.getCertificates(null)) {
            if (-1 != x509Certificate.getBasicConstraints()) continue;
            return x509Certificate;
        }
        return null;
    }
}

