/*
 * Decompiled with CFR 0.152.
 */
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.XHTMLPrintable;

public class SimplePrintable {
    public static void main(String[] args) throws MalformedURLException, URISyntaxException {
        if (args.length == 0) {
            System.err.println("Need file path");
            System.exit(-1);
        }
        if (args[0].startsWith("http:")) {
            new SimplePrintable().printURL(args[0]);
        } else {
            String path = args[0];
            URL url = new URL(path);
            File file = new File(url.toURI());
            if (!file.exists()) {
                System.err.println("File not found: " + args[0]);
                System.exit(-1);
            }
            new SimplePrintable().printURL(url.toExternalForm());
        }
    }

    private void printPanel(XHTMLPanel panel) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable((Printable)new XHTMLPrintable(panel));
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void printURL(String url) {
        XHTMLPanel panel = new XHTMLPanel();
        panel.getSharedContext().setPrint(true);
        panel.getSharedContext().setInteractive(false);
        try {
            panel.setDocument(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.printPanel(panel);
    }

    public void printFile(File file) {
        this.printURL(file.toURI().toString());
    }
}

