/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class VerifyGlyphExists {
    public static void main(String[] args) {
        if (args.length != 2) {
            VerifyGlyphExists.error("Need two arguments: code point (int) and either a font file name, or a path to a text file listing font paths");
        }
        int codePoint = 0;
        try {
            codePoint = Integer.valueOf(args[0]);
        }
        catch (NumberFormatException e) {
            VerifyGlyphExists.error("Value " + args[0] + " for codepoint is not an integer.");
        }
        File file = new File(args[1]);
        if (file.exists()) {
            if (file.getName().endsWith("txt")) {
                List lines = VerifyGlyphExists.readLines(file);
                for (String path : lines) {
                    VerifyGlyphExists.testForGlyph(codePoint, new File(path));
                }
                System.out.println("TODO: read list of fonts");
            } else {
                VerifyGlyphExists.testForGlyph(codePoint, file);
            }
        } else {
            VerifyGlyphExists.error("Second argument must be a font file path, or a path to a text file listing font file paths");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List readLines(File file) {
        ArrayList<String> l = new ArrayList<String>();
        BufferedReader r = null;
        try {
            String path;
            r = new LineNumberReader(new BufferedReader(new FileReader(file)));
            while ((path = ((LineNumberReader)r).readLine()) != null) {
                l.add(path);
            }
        }
        catch (IOException e) {
            VerifyGlyphExists.error("Can't read list of font paths from " + file.getPath());
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        return l;
    }

    private static void testForGlyph(int codePoint, File file) {
        try {
            Font font = VerifyGlyphExists.loadFont(file.getCanonicalPath());
            if (font == null) {
                VerifyGlyphExists.error("Could not load font at path: " + file.getPath());
            } else if (font.canDisplay('\u0000')) {
                System.out.println("FOUND    &#" + codePoint + "; for " + font + " from " + file.getPath());
            } else {
                System.out.println("NO GLYPH &#" + codePoint + "; for " + font + " from " + file.getPath());
            }
        }
        catch (IOException e) {
            VerifyGlyphExists.error("Can't load font at path " + file.getPath() + ", err: " + e.getMessage());
        }
    }

    private static Font loadFont(String fontPath) throws IOException {
        try {
            int format = 0;
            Font font = Font.createFont(format, new File(fontPath).toURL().openStream());
            return font.deriveFont(0, 12.0f);
        }
        catch (FontFormatException e) {
            System.err.println(fontPath + " INVALID FONT FORMAT " + e.getMessage());
            return null;
        }
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(-1);
    }
}

