/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import org.xerial.snappy.BitShuffleNative;
import org.xerial.snappy.SnappyLoader;

public class BitShuffle {
    private static BitShuffleNative impl;

    public static byte[] bitShuffle(short[] sArray) throws IOException {
        byte[] byArray = new byte[sArray.length * 2];
        int n = impl.bitShuffle(sArray, 0, 2, sArray.length * 2, byArray, 0);
        assert (n == sArray.length * 2);
        return byArray;
    }

    public static byte[] bitShuffle(int[] nArray) throws IOException {
        byte[] byArray = new byte[nArray.length * 4];
        int n = impl.bitShuffle(nArray, 0, 4, nArray.length * 4, byArray, 0);
        assert (n == nArray.length * 4);
        return byArray;
    }

    public static byte[] bitShuffle(long[] lArray) throws IOException {
        byte[] byArray = new byte[lArray.length * 8];
        int n = impl.bitShuffle(lArray, 0, 8, lArray.length * 8, byArray, 0);
        assert (n == lArray.length * 8);
        return byArray;
    }

    public static byte[] bitShuffle(float[] fArray) throws IOException {
        byte[] byArray = new byte[fArray.length * 4];
        int n = impl.bitShuffle(fArray, 0, 4, fArray.length * 4, byArray, 0);
        assert (n == fArray.length * 4);
        return byArray;
    }

    public static byte[] bitShuffle(double[] dArray) throws IOException {
        byte[] byArray = new byte[dArray.length * 8];
        int n = impl.bitShuffle(dArray, 0, 8, dArray.length * 8, byArray, 0);
        assert (n == dArray.length * 8);
        return byArray;
    }

    public static short[] bitUnShuffleShortArray(byte[] byArray) throws IOException {
        short[] sArray = new short[byArray.length / 2];
        int n = impl.bitUnShuffle(byArray, 0, 2, byArray.length, sArray, 0);
        assert (n == byArray.length);
        return sArray;
    }

    public static int[] bitUnShuffleIntArray(byte[] byArray) throws IOException {
        int[] nArray = new int[byArray.length / 4];
        int n = impl.bitUnShuffle(byArray, 0, 4, byArray.length, nArray, 0);
        assert (n == byArray.length);
        return nArray;
    }

    public static long[] bitUnShuffleLongArray(byte[] byArray) throws IOException {
        long[] lArray = new long[byArray.length / 8];
        int n = impl.bitUnShuffle(byArray, 0, 8, byArray.length, lArray, 0);
        assert (n == byArray.length);
        return lArray;
    }

    public static float[] bitUnShuffleFloatArray(byte[] byArray) throws IOException {
        float[] fArray = new float[byArray.length / 4];
        int n = impl.bitUnShuffle(byArray, 0, 4, byArray.length, fArray, 0);
        assert (n == byArray.length);
        return fArray;
    }

    public static double[] bitUnShuffleDoubleArray(byte[] byArray) throws IOException {
        double[] dArray = new double[byArray.length / 8];
        int n = impl.bitUnShuffle(byArray, 0, 8, byArray.length, dArray, 0);
        assert (n == byArray.length);
        return dArray;
    }

    static {
        try {
            impl = SnappyLoader.loadBitShuffleApi();
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

