/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyCodec;
import org.xerial.snappy.SnappyException;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyInputStream
extends InputStream {
    protected final InputStream in;
    private boolean finishedReading = false;
    private int blockSize = 0x400000;
    private byte[] compressed;
    private byte[] uncompressed;
    private int uncompressedCursor = 0;
    private int uncompressedLimit = 0;
    private byte[] chunkSizeBuf = new byte[4];

    public SnappyInputStream(InputStream input) throws IOException {
        this.in = input;
        this.readHeader();
        if (this.compressed == null) {
            this.compressed = new byte[this.blockSize];
        }
        if (this.uncompressed == null) {
            this.uncompressed = new byte[this.blockSize];
        }
    }

    protected void readHeader() throws IOException {
        byte[] header = new byte[SnappyCodec.headerSize()];
        int readBytes = this.in.read(header, 0, header.length);
        if (header[0] != SnappyCodec.MAGIC_HEADER[0]) {
            this.readFully(header, readBytes);
            return;
        }
        SnappyCodec codec = SnappyCodec.readHeader(new ByteArrayInputStream(header));
        if (codec.isValidMagicHeader()) {
            if (codec.version < 1) {
                throw new IOException(String.format("compressed with imcompatible codec version %d. At least version %d is required", codec.version, 1));
            }
        } else {
            this.readFully(header, readBytes);
            return;
        }
    }

    protected void readFully(byte[] fragment, int fragmentLength) throws IOException {
        this.compressed = new byte[Math.max(8192, fragmentLength)];
        System.arraycopy(fragment, 0, this.compressed, 0, fragmentLength);
        int cursor = fragmentLength;
        int readBytes = 0;
        while ((readBytes = this.in.read(this.compressed, cursor, this.compressed.length - cursor)) != -1) {
            if ((cursor += readBytes) < this.compressed.length) continue;
            byte[] newBuf = new byte[this.compressed.length * 2];
            System.arraycopy(this.compressed, 0, newBuf, 0, this.compressed.length);
            this.compressed = newBuf;
        }
        this.finishedReading = true;
        try {
            int uncompressedLength = Snappy.uncompressedLength(this.compressed, 0, cursor);
            this.uncompressed = new byte[uncompressedLength];
            Snappy.uncompress(this.compressed, 0, cursor, this.uncompressed, 0);
            this.uncompressedCursor = 0;
            this.uncompressedLimit = uncompressedLength;
        }
        catch (SnappyException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int writtenBytes = 0;
        while (writtenBytes < len) {
            if (this.uncompressedCursor >= this.uncompressedLimit) {
                if (this.hasNextChunk()) continue;
                return writtenBytes == 0 ? -1 : writtenBytes;
            }
            int bytesToWrite = Math.min(this.uncompressedLimit - this.uncompressedCursor, len);
            System.arraycopy(this.uncompressed, this.uncompressedCursor, b, off + writtenBytes, bytesToWrite);
            writtenBytes += bytesToWrite;
            this.uncompressedCursor += bytesToWrite;
        }
        return writtenBytes;
    }

    protected boolean hasNextChunk() throws IOException {
        int readBytes;
        if (this.finishedReading) {
            return false;
        }
        this.uncompressedCursor = 0;
        this.uncompressedLimit = 0;
        int chunkSizeDataLen = this.in.read(this.chunkSizeBuf, 0, 4);
        if (chunkSizeDataLen < 4) {
            this.finishedReading = true;
            return false;
        }
        int chunkSize = SnappyOutputStream.readInt(this.chunkSizeBuf, 0);
        if (chunkSize > this.compressed.length) {
            this.compressed = new byte[chunkSize];
        }
        if ((readBytes = this.in.read(this.compressed, 0, chunkSize)) < chunkSize) {
            throw new IOException("failed to read chunk");
        }
        try {
            int actualUncompressedLength;
            int uncompressedLength = Snappy.uncompressedLength(this.compressed, 0, chunkSize);
            if (uncompressedLength > this.uncompressed.length) {
                this.uncompressed = new byte[uncompressedLength];
            }
            if (uncompressedLength != (actualUncompressedLength = Snappy.uncompress(this.compressed, 0, chunkSize, this.uncompressed, 0))) {
                throw new IOException("invalid uncompressed byte size");
            }
            this.uncompressedLimit = actualUncompressedLength;
        }
        catch (SnappyException e) {
            throw new IOException("failed to uncompress the chunk: " + e.getMessage());
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.uncompressedCursor < this.uncompressedLimit) {
            return this.uncompressed[this.uncompressedCursor++];
        }
        if (this.hasNextChunk()) {
            return this.read();
        }
        return -1;
    }
}

