/*
 * Decompiled with CFR 0.152.
 */
package org.xbean.spring.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xbean.spring.generator.AttributeMapping;
import org.xbean.spring.generator.ElementMapping;
import org.xbean.spring.generator.GeneratorPlugin;
import org.xbean.spring.generator.LogFacade;
import org.xbean.spring.generator.NamespaceMapping;
import org.xbean.spring.generator.Type;
import org.xbean.spring.generator.Utils;

public class XsdGenerator
implements GeneratorPlugin {
    private final File destFile;
    private final LogFacade log;

    public XsdGenerator(LogFacade log, File destFile) {
        this.destFile = destFile;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(NamespaceMapping namespaceMapping) throws IOException {
        File file = this.destFile;
        this.log.log("Generating XSD file: " + file + " for namespace: " + namespaceMapping.getNamespace());
        PrintWriter out = new PrintWriter(new FileWriter(file));
        try {
            this.generateSchema(out, namespaceMapping);
        }
        finally {
            out.close();
        }
    }

    private void generateSchema(PrintWriter out, NamespaceMapping namespaceMapping) {
        out.println("<?xml version='1.0'?>");
        out.println("<!-- NOTE: this file is autogenerated by XBeans -->");
        out.println();
        out.println("<xs:schema elementFormDefault='qualified'");
        out.println("           targetNamespace='" + namespaceMapping.getNamespace() + "'");
        out.println("           xmlns:xs='http://www.w3.org/2001/XMLSchema'");
        out.println("           xmlns:tns='" + namespaceMapping.getNamespace() + "'>");
        Iterator iter = namespaceMapping.getElements().iterator();
        while (iter.hasNext()) {
            ElementMapping element = (ElementMapping)iter.next();
            this.generateElementMapping(out, namespaceMapping, element);
        }
        out.println();
        out.println("</xs:schema>");
    }

    private void generateElementMapping(PrintWriter out, NamespaceMapping namespaceMapping, ElementMapping element) {
        AttributeMapping attributeMapping;
        out.println();
        out.println("  <!-- element for type: " + element.getClassName() + " -->");
        String localName = element.getElementName();
        out.println("  <xs:element name='" + localName + "'>");
        out.println("    <xs:complexType>");
        int complexCount = 0;
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            attributeMapping = (AttributeMapping)iterator.next();
            if (Utils.isSimpleType(attributeMapping.getType())) continue;
            ++complexCount;
        }
        if (complexCount > 0) {
            out.println("      <xs:sequence>");
            iterator = element.getAttributes().iterator();
            while (iterator.hasNext()) {
                attributeMapping = (AttributeMapping)iterator.next();
                if (Utils.isSimpleType(attributeMapping.getType())) continue;
                this.generateElementMappingComplexProperty(out, namespaceMapping, attributeMapping);
            }
            out.println("      </xs:sequence>");
        }
        iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            attributeMapping = (AttributeMapping)iterator.next();
            if (Utils.isSimpleType(attributeMapping.getType())) {
                this.generateElementMappingSimpleProperty(out, attributeMapping);
                continue;
            }
            if (attributeMapping.getType().isCollection()) continue;
            this.generateElementMappingComplexPropertyAsRef(out, attributeMapping);
        }
        out.println("      <xs:anyAttribute namespace='##other' processContents='lax'/>");
        out.println("    </xs:complexType>");
        out.println("  </xs:element>");
        out.println();
    }

    private void generateElementMappingSimpleProperty(PrintWriter out, AttributeMapping attributeMapping) {
        out.println("      <xs:attribute name='" + attributeMapping.getAttributeName() + "' type='" + Utils.getXsdType(attributeMapping.getType()) + "'/>");
    }

    private void generateElementMappingComplexPropertyAsRef(PrintWriter out, AttributeMapping attributeMapping) {
        out.println("      <xs:attribute name='" + attributeMapping.getAttributeName() + "' type='xs:string'/>");
    }

    private void generateElementMappingComplexProperty(PrintWriter out, NamespaceMapping namespaceMapping, AttributeMapping attributeMapping) {
        Type type = attributeMapping.getType();
        List types = type.isCollection() ? Utils.findImplementationsOf(namespaceMapping, type.getNestedType()) : Utils.findImplementationsOf(namespaceMapping, type);
        types = Collections.EMPTY_LIST;
        String maxOccurs = type.isCollection() ? "unbounded" : "1";
        out.println("        <xs:element name='" + attributeMapping.getAttributeName() + "' minOccurs='0' maxOccurs='1'>");
        out.println("          <xs:complexType>");
        if (types.isEmpty()) {
            out.println("            <xs:sequence minOccurs='0' maxOccurs='" + maxOccurs + "'><xs:any/></xs:sequence>");
        } else {
            out.println("            <xs:choice minOccurs='0' maxOccurs='" + maxOccurs + "'>");
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                ElementMapping element = (ElementMapping)iterator.next();
                out.println("              <xs:element ref='tns:" + element.getElementName() + "'/>");
            }
            out.println("            </xs:choice>");
        }
        out.println("          </xs:complexType>");
        out.println("        </xs:element>");
    }
}

