/*
 * Decompiled with CFR 0.152.
 */
package org.xbean.spring.generator;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xbean.spring.generator.ElementMapping;
import org.xbean.spring.generator.NamespaceMapping;
import org.xbean.spring.generator.Type;

public final class Utils {
    public static final String XBEAN_ANNOTATION = "org.xbean.XBean";
    public static final String PROPERTY_ANNOTATION = "org.xbean.Property";
    public static final Map XSD_TYPES;
    static /* synthetic */ Class class$org$xbean$spring$generator$Utils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;

    private Utils() {
    }

    public static String decapitalise(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static boolean isSimpleType(Type type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isCollection()) {
            return false;
        }
        String name = type.getName();
        if (name.equals("java.lang.Class") || name.equals("javax.xml.namespace.QName")) {
            return true;
        }
        return Utils.hasPropertyEditor(name);
    }

    private static boolean hasPropertyEditor(String type) {
        Class theClass;
        try {
            theClass = Utils.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Warning, could not load class: " + type);
            return false;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(theClass);
        return editor != null;
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return (class$org$xbean$spring$generator$Utils == null ? (class$org$xbean$spring$generator$Utils = Utils.class$("org.xbean.spring.generator.Utils")) : class$org$xbean$spring$generator$Utils).getClassLoader().loadClass(name);
    }

    public static String getXsdType(Type type) {
        String name = type.getName();
        String xsdType = (String)XSD_TYPES.get(name);
        if (xsdType == null) {
            xsdType = "xsd:string";
        }
        return xsdType;
    }

    public static List findImplementationsOf(NamespaceMapping namespaceMapping, Type type) {
        ArrayList<ElementMapping> elements = new ArrayList<ElementMapping>();
        String nestedTypeName = type.getName();
        Iterator iter = namespaceMapping.getElements().iterator();
        while (iter.hasNext()) {
            ElementMapping element = (ElementMapping)iter.next();
            if (!nestedTypeName.equals(element.getClassName())) continue;
            elements.add(element);
        }
        return elements;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put((class$java$lang$String == null ? (class$java$lang$String = Utils.class$("java.lang.String")) : class$java$lang$String).getName(), "xs:string");
        map.put((class$java$lang$Boolean == null ? (class$java$lang$Boolean = Utils.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), "xs:boolean");
        map.put(Boolean.TYPE.getName(), "xs:boolean");
        map.put((class$java$lang$Byte == null ? (class$java$lang$Byte = Utils.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), "xs:byte");
        map.put(Byte.TYPE.getName(), "xs:byte");
        map.put((class$java$lang$Short == null ? (class$java$lang$Short = Utils.class$("java.lang.Short")) : class$java$lang$Short).getName(), "xs:short");
        map.put(Short.TYPE.getName(), "xs:short");
        map.put((class$java$lang$Integer == null ? (class$java$lang$Integer = Utils.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), "xs:integer");
        map.put(Integer.TYPE.getName(), "xs:integer");
        map.put((class$java$lang$Long == null ? (class$java$lang$Long = Utils.class$("java.lang.Long")) : class$java$lang$Long).getName(), "xs:long");
        map.put(Long.TYPE.getName(), "xs:long");
        map.put((class$java$lang$Float == null ? (class$java$lang$Float = Utils.class$("java.lang.Float")) : class$java$lang$Float).getName(), "xs:float");
        map.put(Float.TYPE.getName(), "xs:float");
        map.put((class$java$lang$Double == null ? (class$java$lang$Double = Utils.class$("java.lang.Double")) : class$java$lang$Double).getName(), "xs:double");
        map.put(Double.TYPE.getName(), "xs:double");
        map.put((class$java$util$Date == null ? (class$java$util$Date = Utils.class$("java.util.Date")) : class$java$util$Date).getName(), "xs:date");
        map.put((class$java$sql$Date == null ? (class$java$sql$Date = Utils.class$("java.sql.Date")) : class$java$sql$Date).getName(), "xs:date");
        map.put("javax.xml.namespace.QName", "xs:QName");
        XSD_TYPES = Collections.unmodifiableMap(map);
    }
}

