/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.sql.analyzer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.util.ChainingOps$;
import scala.util.package;
import wvlet.airframe.sql.SQLErrorCode$ColumnNotFound$;
import wvlet.airframe.sql.SQLErrorCode$InvalidArgument$;
import wvlet.airframe.sql.SQLErrorCode$SyntaxError$;
import wvlet.airframe.sql.SQLErrorCode$TableNotFound$;
import wvlet.airframe.sql.analyzer.AnalyzerContext;
import wvlet.airframe.sql.analyzer.CTEResolver$;
import wvlet.airframe.sql.analyzer.TypeResolver$;
import wvlet.airframe.sql.catalog.Catalog;
import wvlet.airframe.sql.model.Attribute;
import wvlet.airframe.sql.model.CTERelationRef;
import wvlet.airframe.sql.model.Expression;
import wvlet.airframe.sql.model.Expression$QName$;
import wvlet.airframe.sql.model.LogicalPlan;
import wvlet.airframe.sql.model.NodeLocation;
import wvlet.airframe.sql.model.ResolvedAttribute;
import wvlet.airframe.sql.model.TableScan;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class TypeResolver$
implements LogSupport {
    public static final TypeResolver$ MODULE$ = new TypeResolver$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        TypeResolver$ typeResolver$ = this;
        synchronized (typeResolver$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public List<Function1<AnalyzerContext, PartialFunction<LogicalPlan, LogicalPlan>>> typerRules() {
        Function1 & Serializable intersect = (Function1 & Serializable)context -> MODULE$.resolveCTETableRef((AnalyzerContext)context);
        Function1 & Serializable intersect2 = (Function1 & Serializable)context -> MODULE$.resolveAggregationIndexes((AnalyzerContext)context);
        Function1 & Serializable intersect3 = (Function1 & Serializable)context -> MODULE$.resolveAggregationKeys((AnalyzerContext)context);
        Function1 & Serializable intersect4 = (Function1 & Serializable)context -> MODULE$.resolveSortItemIndexes((AnalyzerContext)context);
        Function1 & Serializable intersect5 = (Function1 & Serializable)context -> MODULE$.resolveSortItems((AnalyzerContext)context);
        Function1 & Serializable intersect6 = (Function1 & Serializable)context -> MODULE$.resolveTableRef((AnalyzerContext)context);
        Function1 & Serializable intersect7 = (Function1 & Serializable)context -> MODULE$.resolveJoinUsing((AnalyzerContext)context);
        Function1 & Serializable intersect8 = (Function1 & Serializable)context -> MODULE$.resolveSubquery((AnalyzerContext)context);
        Function1 & Serializable intersect9 = (Function1 & Serializable)context -> MODULE$.resolveRegularRelation((AnalyzerContext)context);
        Function1 & Serializable intersect10 = (Function1 & Serializable)context -> MODULE$.resolveColumns((AnalyzerContext)context);
        return Nil$.MODULE$.$colon$colon((Object)intersect10).$colon$colon((Object)intersect9).$colon$colon((Object)intersect8).$colon$colon((Object)intersect7).$colon$colon((Object)intersect6).$colon$colon((Object)intersect5).$colon$colon((Object)intersect4).$colon$colon((Object)intersect3).$colon$colon((Object)intersect2).$colon$colon((Object)intersect);
    }

    public LogicalPlan resolve(AnalyzerContext analyzerContext, LogicalPlan plan) {
        return this.resolve(analyzerContext, plan, this.typerRules());
    }

    public LogicalPlan resolve(AnalyzerContext analyzerContext, LogicalPlan plan, List<Function1<AnalyzerContext, PartialFunction<LogicalPlan, LogicalPlan>>> rules) {
        LogicalPlan resolvedPlan = (LogicalPlan)rules.foldLeft((Object)plan, (Function2 & Serializable)(targetPlan, rule) -> {
            PartialFunction r = (PartialFunction)rule.apply((Object)analyzerContext);
            LogicalPlan resolved = targetPlan.transformUp((PartialFunction<LogicalPlan, LogicalPlan>)r);
            return resolved;
        });
        return resolvedPlan;
    }

    public LogicalPlan.Relation resolveRelation(AnalyzerContext analyzerContext, LogicalPlan plan) {
        LogicalPlan resolvedPlan = this.resolve(analyzerContext, plan);
        LogicalPlan logicalPlan = resolvedPlan;
        if (logicalPlan instanceof LogicalPlan.Relation) {
            LogicalPlan.Relation relation = (LogicalPlan.Relation)logicalPlan;
            return relation;
        }
        throw SQLErrorCode$InvalidArgument$.MODULE$.newException(new StringBuilder(17).append(plan).append(" isn't a relation").toString(), plan.nodeLocation());
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveAggregationIndexes(AnalyzerContext context) {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Aggregate) {
                    LogicalPlan.Aggregate aggregate = (LogicalPlan.Aggregate)A1;
                    LogicalPlan.Relation child = aggregate.child();
                    List<Attribute> selectItems = aggregate.selectItems();
                    List<Expression.GroupingKey> groupingKeys = aggregate.groupingKeys();
                    Option<Expression> having = aggregate.having();
                    List resolvedGroupingKeys = groupingKeys.map((Function1 & Serializable)x0$1 -> {
                        Expression.LongLiteral longLiteral;
                        long i;
                        Expression expression;
                        Expression.GroupingKey groupingKey = x0$1;
                        if (groupingKey != null && (expression = groupingKey.child()) instanceof Expression.LongLiteral && (i = (longLiteral = (Expression.LongLiteral)expression).value()) <= (long)selectItems.length()) {
                            Expression expression2;
                            Attribute attribute = (Attribute)selectItems.apply((int)i - 1);
                            if (attribute instanceof Expression.SingleColumn) {
                                Expression.SingleColumn singleColumn = (Expression.SingleColumn)attribute;
                                Expression expr = singleColumn.expr();
                                expression2 = expr;
                            } else {
                                expression2 = attribute;
                            }
                            Attribute keyItem = expression2;
                            return new Expression.GroupingKey(keyItem, groupingKey.nodeLocation());
                        }
                        return groupingKey;
                    });
                    return (B1)new LogicalPlan.Aggregate(child, selectItems, (List<Expression.GroupingKey>)resolvedGroupingKeys, having, aggregate.nodeLocation());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Aggregate;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.collection.immutable.List wvlet.airframe.sql.model.Expression$GroupingKey )}, serializedLambda);
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveAggregationKeys(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            public final AnalyzerContext context$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Aggregate) {
                    LogicalPlan.Aggregate aggregate = (LogicalPlan.Aggregate)A1;
                    LogicalPlan.Relation child = aggregate.child();
                    List<Attribute> selectItems = aggregate.selectItems();
                    List<Expression.GroupingKey> groupingKeys = aggregate.groupingKeys();
                    Option<Expression> having = aggregate.having();
                    LogicalPlan.Relation resolvedChild = TypeResolver$.MODULE$.resolveRelation(this.context$1, child);
                    Seq<Attribute> inputAttributes = resolvedChild.outputAttributes();
                    List resolvedGroupingKeys = groupingKeys.map((Function1 & Serializable)x -> {
                        Expression e = TypeResolver$.MODULE$.resolveExpression($this.context$1, x.child(), inputAttributes);
                        return new Expression.GroupingKey(e, e.nodeLocation());
                    });
                    Option resolvedHaving = having.map((Function1 & Serializable)x$1 -> x$1.transformUpExpression((PartialFunction<Expression, Expression>)new Serializable(this, aggregate){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.resolveAggregationKeys.1 $outer;
                        private final LogicalPlan.Aggregate x2$1;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 != null) {
                                A1 A12 = A1;
                                return (B1)TypeResolver$.MODULE$.resolveExpression(this.$outer.context$1, A12, this.x2$1.outputAttributes());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression = x1;
                            return expression != null;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$1 = x2$1;
                        }
                    }));
                    return (B1)new LogicalPlan.Aggregate(resolvedChild, selectItems, (List<Expression.GroupingKey>)resolvedGroupingKeys, (Option<Expression>)resolvedHaving, aggregate.nodeLocation());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Aggregate;
            }
            {
                this.context$1 = context$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(wvlet.airframe.sql.analyzer.TypeResolver$$anonfun$resolveAggregationKeys$1 scala.collection.immutable.Seq wvlet.airframe.sql.model.Expression$GroupingKey ), $anonfun$applyOrElse$3(wvlet.airframe.sql.analyzer.TypeResolver$$anonfun$resolveAggregationKeys$1 wvlet.airframe.sql.model.LogicalPlan$Aggregate wvlet.airframe.sql.model.Expression )}, serializedLambda);
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveSortItemIndexes(AnalyzerContext context) {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Sort) {
                    Seq resolvedSortItems;
                    LogicalPlan.Sort sort = (LogicalPlan.Sort)A1;
                    LogicalPlan.Relation child = sort.child();
                    Seq<Expression.SortItem> sortItems = sort.orderBy();
                    Seq x$1 = resolvedSortItems = (Seq)sortItems.map((Function1 & Serializable)x0$1 -> {
                        Expression expression;
                        Expression.SortItem sortItem = x0$1;
                        if (sortItem != null && (expression = sortItem.sortKey()) instanceof Expression.LongLiteral) {
                            Expression expression2;
                            Expression.LongLiteral longLiteral = (Expression.LongLiteral)expression;
                            long i = longLiteral.value();
                            Attribute attribute = (Attribute)child.outputAttributes().apply((int)i - 1);
                            if (attribute instanceof Expression.SingleColumn) {
                                Expression.SingleColumn singleColumn = (Expression.SingleColumn)attribute;
                                Expression expr = singleColumn.expr();
                                expression2 = expr;
                            } else {
                                expression2 = attribute;
                            }
                            Attribute sortKey = expression2;
                            return sortItem.copy(sortKey, sortItem.copy$default$2(), sortItem.copy$default$3(), sortItem.copy$default$4());
                        }
                        return sortItem;
                    });
                    LogicalPlan.Relation x$2 = sort.copy$default$1();
                    Option<NodeLocation> x$3 = sort.copy$default$3();
                    return (B1)sort.copy(x$2, (Seq<Expression.SortItem>)x$1, x$3);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Sort;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(wvlet.airframe.sql.model.LogicalPlan$Relation wvlet.airframe.sql.model.Expression$SortItem )}, serializedLambda);
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveSortItems(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$2;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Sort) {
                    Seq resolvedSortItems;
                    LogicalPlan.Sort sort = (LogicalPlan.Sort)A1;
                    LogicalPlan.Relation child = sort.child();
                    Seq<Expression.SortItem> sortItems = sort.orderBy();
                    LogicalPlan.Relation resolvedChild = TypeResolver$.MODULE$.resolveRelation(this.context$2, child);
                    Seq<Attribute> inputAttributes = resolvedChild.outputAttributes();
                    Seq x$1 = resolvedSortItems = (Seq)sortItems.map((Function1 & Serializable)sortItem -> {
                        Expression e = TypeResolver$.MODULE$.resolveExpression($this.context$2, sortItem.sortKey(), inputAttributes);
                        return sortItem.copy(e, sortItem.copy$default$2(), sortItem.copy$default$3(), sortItem.copy$default$4());
                    });
                    LogicalPlan.Relation x$2 = sort.copy$default$1();
                    Option<NodeLocation> x$3 = sort.copy$default$3();
                    return (B1)sort.copy(x$2, (Seq<Expression.SortItem>)x$1, x$3);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Sort;
            }
            {
                this.context$2 = context$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(wvlet.airframe.sql.analyzer.TypeResolver$$anonfun$resolveSortItems$1 scala.collection.immutable.Seq wvlet.airframe.sql.model.Expression$SortItem )}, serializedLambda);
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveCTETableRef(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$3;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Query) {
                    LogicalPlan.Query query = (LogicalPlan.Query)A1;
                    return (B1)CTEResolver$.MODULE$.resolveCTE(this.context$3, query);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Query;
            }
            {
                this.context$3 = context$3;
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveTableRef(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$4;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.TableRef) {
                    LogicalPlan.TableRef tableRef = (LogicalPlan.TableRef)A1;
                    Expression.QName qname = tableRef.name();
                    Option<Catalog.Table> option = this.context$4.catalog().findFromQName(this.context$4.database(), qname);
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        Catalog.Table dbTable = (Catalog.Table)some.value();
                        if (TypeResolver$.MODULE$.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                            TypeResolver$.MODULE$.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "TypeResolver.scala", 160, 14), (Object)new StringBuilder(6).append("Found ").append(dbTable).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return (B1)new TableScan(dbTable, dbTable.schema().columns(), tableRef.nodeLocation());
                    }
                    if (None$.MODULE$.equals(option)) {
                        Option option2 = this.context$4.outerQueries().get((Object)qname.fullName());
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            LogicalPlan cte = (LogicalPlan)some.value();
                            return (B1)new CTERelationRef(qname.fullName(), (Seq<Attribute>)((Seq)cte.outputAttributes().map((Function1 & Serializable)x$2 -> x$2.withQualifier(qname.fullName()))), tableRef.nodeLocation());
                        }
                        if (None$.MODULE$.equals(option2)) {
                            throw SQLErrorCode$TableNotFound$.MODULE$.newException(new StringBuilder(17).append("Table ").append(this.context$4.database()).append(".").append(qname).append(" not found").toString(), tableRef.nodeLocation());
                        }
                        throw new MatchError((Object)option2);
                    }
                    throw new MatchError(option);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.TableRef;
            }
            {
                this.context$4 = context$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(wvlet.airframe.sql.model.Expression$QName wvlet.airframe.sql.model.Attribute )}, serializedLambda);
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveJoinUsing(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$5;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                LogicalPlan.Join join = null;
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Join) {
                    bl = true;
                    join = (LogicalPlan.Join)A1;
                    LogicalPlan.JoinType joinType = join.joinType();
                    LogicalPlan.Relation left = join.left();
                    LogicalPlan.Relation right = join.right();
                    Expression.JoinCriteria u = join.cond();
                    if (u instanceof Expression.JoinUsing) {
                        Expression.JoinUsing joinUsing = (Expression.JoinUsing)u;
                        Seq<Expression.Identifier> joinKeys = joinUsing.columns();
                        LogicalPlan.Join resolvedJoin = new LogicalPlan.Join(joinType, TypeResolver$.MODULE$.resolveRelation(this.context$5, left), TypeResolver$.MODULE$.resolveRelation(this.context$5, right), joinUsing, join.nodeLocation());
                        Seq resolvedJoinKeys = (Seq)joinKeys.flatMap((Function1 & Serializable)k -> {
                            List<Expression> list = TypeResolver$.MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes($this.context$5, (Expression)k, resolvedJoin.inputAttributes());
                            if (Nil$.MODULE$.equals(list)) {
                                throw SQLErrorCode$ColumnNotFound$.MODULE$.newException(new StringBuilder(30).append("join key column: ").append(k.sqlExpr()).append(" is not found").toString(), k.nodeLocation());
                            }
                            return list;
                        });
                        LogicalPlan.Join updated = resolvedJoin.withCond(new Expression.JoinOnEq((Seq<Expression>)resolvedJoinKeys, joinUsing.nodeLocation()));
                        return (B1)updated;
                    }
                }
                if (bl) {
                    Expression.JoinOn joinOn;
                    Expression expression;
                    LogicalPlan.JoinType joinType = join.joinType();
                    LogicalPlan.Relation left = join.left();
                    LogicalPlan.Relation right = join.right();
                    Expression.JoinCriteria u = join.cond();
                    if (u instanceof Expression.JoinOn && (expression = (joinOn = (Expression.JoinOn)u).expr()) instanceof Expression.Eq) {
                        Expression.Eq eq = (Expression.Eq)expression;
                        Expression leftKey = eq.left();
                        Expression rightKey = eq.right();
                        LogicalPlan.Join resolvedJoin = new LogicalPlan.Join(joinType, TypeResolver$.MODULE$.resolveRelation(this.context$5, left), TypeResolver$.MODULE$.resolveRelation(this.context$5, right), joinOn, join.nodeLocation());
                        Seq resolvedJoinKeys = (Seq)new .colon.colon((Object)leftKey, (List)new .colon.colon((Object)rightKey, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable)k -> {
                            List<Expression> list = TypeResolver$.MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes($this.context$5, (Expression)k, resolvedJoin.inputAttributes());
                            if (Nil$.MODULE$.equals(list)) {
                                throw SQLErrorCode$ColumnNotFound$.MODULE$.newException(new StringBuilder(30).append("join key column: ").append(k.sqlExpr()).append(" is not found").toString(), k.nodeLocation());
                            }
                            return list;
                        });
                        LogicalPlan.Join updated = resolvedJoin.withCond(new Expression.JoinOnEq((Seq<Expression>)resolvedJoinKeys, joinOn.expr().nodeLocation()));
                        return (B1)updated;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Expression.JoinOn joinOn;
                Expression expression;
                Expression.JoinCriteria u;
                boolean bl = false;
                LogicalPlan.Join join = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof LogicalPlan.Join) {
                    bl = true;
                    join = (LogicalPlan.Join)logicalPlan;
                    Expression.JoinCriteria u2 = join.cond();
                    if (u2 instanceof Expression.JoinUsing) {
                        return true;
                    }
                }
                return bl && (u = join.cond()) instanceof Expression.JoinOn && (expression = (joinOn = (Expression.JoinOn)u).expr()) instanceof Expression.Eq;
            }
            {
                this.context$5 = context$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(wvlet.airframe.sql.analyzer.TypeResolver$$anonfun$resolveJoinUsing$1 wvlet.airframe.sql.model.LogicalPlan$Join wvlet.airframe.sql.model.Expression$Identifier ), $anonfun$applyOrElse$8(wvlet.airframe.sql.analyzer.TypeResolver$$anonfun$resolveJoinUsing$1 wvlet.airframe.sql.model.LogicalPlan$Join wvlet.airframe.sql.model.Expression )}, serializedLambda);
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveSubquery(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            public final AnalyzerContext context$6;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Filter) {
                    LogicalPlan.Filter filter = (LogicalPlan.Filter)A1;
                    return (B1)filter.transformUpExpressions((PartialFunction<Expression, Expression>)new Serializable(this){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.resolveSubquery.1 $outer;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof Expression.InSubQuery) {
                                Expression.InSubQuery inSubQuery = (Expression.InSubQuery)A1;
                                LogicalPlan.Relation x$1 = TypeResolver$.MODULE$.resolveRelation(this.$outer.context$6, inSubQuery.in());
                                Expression x$2 = inSubQuery.copy$default$1();
                                Option<NodeLocation> x$3 = inSubQuery.copy$default$3();
                                return (B1)inSubQuery.copy(x$2, x$1, x$3);
                            }
                            if (A1 instanceof Expression.NotInSubQuery) {
                                Expression.NotInSubQuery notInSubQuery = (Expression.NotInSubQuery)A1;
                                LogicalPlan.Relation x$4 = TypeResolver$.MODULE$.resolveRelation(this.$outer.context$6, notInSubQuery.in());
                                Expression x$5 = notInSubQuery.copy$default$1();
                                Option<NodeLocation> x$6 = notInSubQuery.copy$default$3();
                                return (B1)notInSubQuery.copy(x$5, x$4, x$6);
                            }
                            if (A1 instanceof Expression.SubQueryExpression) {
                                Expression.SubQueryExpression subQueryExpression = (Expression.SubQueryExpression)A1;
                                return (B1)subQueryExpression.copy(TypeResolver$.MODULE$.resolveRelation(this.$outer.context$6, subQueryExpression.query()), subQueryExpression.copy$default$2());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression = x1;
                            if (expression instanceof Expression.InSubQuery) {
                                return true;
                            }
                            if (expression instanceof Expression.NotInSubQuery) {
                                return true;
                            }
                            return expression instanceof Expression.SubQueryExpression;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Filter;
            }
            {
                this.context$6 = context$6;
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveRegularRelation(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            public final AnalyzerContext context$7;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Filter) {
                    LogicalPlan.Filter filter = (LogicalPlan.Filter)A1;
                    return (B1)filter.transformUpExpressions((PartialFunction<Expression, Expression>)new Serializable(this, filter){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.resolveRegularRelation.1 $outer;
                        private final LogicalPlan.Filter x2$2;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 != null) {
                                A1 A12 = A1;
                                return (B1)TypeResolver$.MODULE$.resolveExpression(this.$outer.context$7, A12, this.x2$2.inputAttributes());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression = x1;
                            return expression != null;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$2 = x2$2;
                        }
                    });
                }
                if (A1 instanceof LogicalPlan.Union) {
                    LogicalPlan.Union union = (LogicalPlan.Union)A1;
                    return (B1)union;
                }
                if (A1 instanceof LogicalPlan.Intersect) {
                    LogicalPlan.Intersect intersect = (LogicalPlan.Intersect)A1;
                    return (B1)intersect;
                }
                if (A1 instanceof LogicalPlan.Relation) {
                    LogicalPlan.Relation relation = (LogicalPlan.Relation)A1;
                    return (B1)relation.transformUpExpressions((PartialFunction<Expression, Expression>)new Serializable(this, relation){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.resolveRegularRelation.1 $outer;
                        private final LogicalPlan.Relation x6$1;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            if (A1 != null) {
                                A1 A12 = A1;
                                return (B1)TypeResolver$.MODULE$.resolveExpression(this.$outer.context$7, A12, this.x6$1.inputAttributes());
                            }
                            return (B1)function1.apply(x2);
                        }

                        public final boolean isDefinedAt(Expression x2) {
                            Expression expression = x2;
                            return expression != null;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x6$1 = x6$1;
                        }
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof LogicalPlan.Filter) {
                    return true;
                }
                if (logicalPlan instanceof LogicalPlan.Union) {
                    return true;
                }
                if (logicalPlan instanceof LogicalPlan.Intersect) {
                    return true;
                }
                return logicalPlan instanceof LogicalPlan.Relation;
            }
            {
                this.context$7 = context$7;
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveColumns(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$8;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Project) {
                    LogicalPlan.Project project = (LogicalPlan.Project)A1;
                    LogicalPlan.Relation child = project.child();
                    Seq<Attribute> columns = project.selectItems();
                    Seq<Attribute> resolvedColumns = TypeResolver$.MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$resolveOutputColumns(this.context$8, child.outputAttributes(), columns);
                    LogicalPlan.Project resolved = new LogicalPlan.Project(child, resolvedColumns, project.nodeLocation());
                    return (B1)resolved;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Project;
            }
            {
                this.context$8 = context$8;
            }
        };
    }

    public Seq<Attribute> wvlet$airframe$sql$analyzer$TypeResolver$$resolveOutputColumns(AnalyzerContext context, Seq<Attribute> inputAttributes, Seq<Attribute> outputColumns) {
        Builder resolvedColumns = package$.MODULE$.Seq().newBuilder();
        outputColumns.map((Function1 & Serializable)x0$1 -> {
            Attribute attribute = x0$1;
            if (attribute instanceof Expression.AllColumns) {
                return (Builder)resolvedColumns.$plus$plus$eq((IterableOnce)inputAttributes);
            }
            if (attribute instanceof Expression.SingleColumn) {
                Expression.SingleColumn singleColumn = (Expression.SingleColumn)attribute;
                Expression expr = singleColumn.expr();
                Option<String> alias = singleColumn.alias();
                Option<NodeLocation> nodeLocation = singleColumn.nodeLocation();
                boolean bl = false;
                ResolvedAttribute resolvedAttribute = null;
                Expression expression = MODULE$.resolveExpression(context, expr, inputAttributes);
                if (expression instanceof ResolvedAttribute) {
                    bl = true;
                    resolvedAttribute = (ResolvedAttribute)expression;
                    if (alias.isEmpty()) {
                        return (Builder)resolvedColumns.$plus$eq((Object)resolvedAttribute);
                    }
                }
                if (bl && alias.nonEmpty()) {
                    return (Builder)resolvedColumns.$plus$eq((Object)resolvedAttribute.withAlias((String)alias.get()));
                }
                return (Builder)resolvedColumns.$plus$eq((Object)new Expression.SingleColumn(expression, alias, (Option<String>)None$.MODULE$, nodeLocation));
            }
            return (Builder)resolvedColumns.$plus$eq((Object)attribute);
        });
        Seq output = (Seq)resolvedColumns.result();
        return output;
    }

    public Attribute resolveAttribute(Attribute attribute) {
        Attribute attribute2 = attribute;
        if (attribute2 instanceof Expression.SingleColumn) {
            Expression.SingleColumn singleColumn = (Expression.SingleColumn)attribute2;
            Expression r = singleColumn.expr();
            Option<String> alias = singleColumn.alias();
            Option<String> qualifier = singleColumn.qualifier();
            if (r instanceof ResolvedAttribute) {
                ResolvedAttribute resolvedAttribute = (ResolvedAttribute)r;
                return (Attribute)ChainingOps$.MODULE$.pipe$extension(package.chaining$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.pipe$extension(package.chaining$.MODULE$.scalaUtilChainingOps((Object)resolvedAttribute), (Function1 & Serializable)attr -> {
                    Option option = alias;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String x = (String)some.value();
                        return attr.withAlias(x);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return attr;
                    }
                    throw new MatchError((Object)option);
                })), (Function1 & Serializable)attr -> {
                    Option option = qualifier;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String x = (String)some.value();
                        return attr.withQualifier(x);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return attr;
                    }
                    throw new MatchError((Object)option);
                });
            }
        }
        return attribute2;
    }

    public List<Expression> wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes(AnalyzerContext context, Expression expr, Seq<Attribute> inputAttributes) {
        Expression.AllColumns allColumns;
        Option<Seq<Catalog.Table>> option;
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "TypeResolver.scala", 300, 10), (Object)new StringBuilder(47).append("findMatchInInputAttributes: ").append(expr).append(", inputAttributes: ").append(inputAttributes).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Seq resolvedAttributes = (Seq)inputAttributes.map((Function1 & Serializable)attribute -> MODULE$.resolveAttribute((Attribute)attribute));
        Expression expression = expr;
        if (expression instanceof Expression.Identifier) {
            Expression.Identifier identifier = (Expression.Identifier)expression;
            return TypeResolver$.lookup$1(identifier.value(), context, resolvedAttributes);
        }
        if (expression instanceof Expression.UnresolvedAttribute) {
            Expression.UnresolvedAttribute unresolvedAttribute = (Expression.UnresolvedAttribute)expression;
            String name = unresolvedAttribute.name();
            return TypeResolver$.lookup$1(name, context, resolvedAttributes);
        }
        if (expression instanceof Expression.AllColumns && None$.MODULE$.equals(option = (allColumns = (Expression.AllColumns)expression).sourceTables())) {
            Seq sourceTables = (Seq)((SeqOps)((IterableOps)inputAttributes.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof ResolvedAttribute) {
                        ResolvedAttribute resolvedAttribute = (ResolvedAttribute)A1;
                        return (B1)resolvedAttribute.sourceColumns().map((Function1 & Serializable)x$3 -> x$3.table());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Attribute x1) {
                    Attribute attribute = x1;
                    return attribute instanceof ResolvedAttribute;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$12(wvlet.airframe.sql.model.SourceColumn )}, serializedLambda);
                }
            })).flatten(Predef$.MODULE$.$conforms())).distinct();
            Some x$1 = new Some((Object)sourceTables);
            Option<Expression.QName> x$2 = allColumns.copy$default$1();
            Option<NodeLocation> x$3 = allColumns.copy$default$3();
            return new .colon.colon((Object)allColumns.copy(x$2, (Option<Seq<Catalog.Table>>)x$1, x$3), (List)Nil$.MODULE$);
        }
        return new .colon.colon((Object)expr, (List)Nil$.MODULE$);
    }

    public Expression resolveExpression(AnalyzerContext context, Expression expr, Seq<Attribute> inputAttributes) {
        List<Expression> list = this.wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes(context, expr, inputAttributes);
        if (list.length() > 1) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "TypeResolver.scala", 347, 14), (Object)new StringBuilder(4).append(expr).append(" -> ").append(list).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw SQLErrorCode$SyntaxError$.MODULE$.newException(new StringBuilder(13).append(expr.sqlExpr()).append(" is ambiguous").toString(), expr.nodeLocation());
        }
        return (Expression)list.headOption().getOrElse((Function0 & Serializable)() -> expr);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TypeResolver$.class);
    }

    private static final List lookup$1(String name, AnalyzerContext context$10, Seq resolvedAttributes$1) {
        SeqOps seqOps;
        List<String> list;
        SeqOps seqOps2;
        List<String> list2;
        SeqOps seqOps3;
        List<String> list3;
        Expression.QName qName = Expression$QName$.MODULE$.apply(name, (Option<NodeLocation>)None$.MODULE$);
        if (qName != null && (list3 = qName.parts()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq(list3)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 3) == 0) {
            String db = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
            String t1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
            String c1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2);
            String string = context$10.database();
            String string2 = db;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return ((IterableOnceOps)resolvedAttributes$1.collect((PartialFunction)new Serializable(t1, c1){
                    private static final long serialVersionUID = 0L;
                    private final String t1$1;
                    private final String c1$1;

                    public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Expression.SingleColumn singleColumn;
                        ResolvedAttribute resolvedAttribute;
                        A1 A1 = x1;
                        if (A1 instanceof ResolvedAttribute && (resolvedAttribute = (ResolvedAttribute)A1).matchesWith(this.t1$1, this.c1$1)) {
                            return (B1)resolvedAttribute;
                        }
                        if (A1 instanceof Expression.SingleColumn && (singleColumn = (Expression.SingleColumn)A1).matchesWith(this.t1$1, this.c1$1)) {
                            return (B1)singleColumn.expr();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Attribute x1) {
                        Expression.SingleColumn singleColumn;
                        ResolvedAttribute resolvedAttribute;
                        Attribute attribute = x1;
                        if (attribute instanceof ResolvedAttribute && (resolvedAttribute = (ResolvedAttribute)attribute).matchesWith(this.t1$1, this.c1$1)) {
                            return true;
                        }
                        return attribute instanceof Expression.SingleColumn && (singleColumn = (Expression.SingleColumn)attribute).matchesWith(this.t1$1, this.c1$1);
                    }
                    {
                        this.t1$1 = t1$1;
                        this.c1$1 = c1$1;
                    }
                })).toList();
            }
        }
        if (qName != null && (list2 = qName.parts()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
            String t1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            String c1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            return ((IterableOnceOps)resolvedAttributes$1.collect((PartialFunction)new Serializable(t1, c1){
                private static final long serialVersionUID = 0L;
                private final String t1$2;
                private final String c1$2;

                public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Expression.SingleColumn singleColumn;
                    ResolvedAttribute resolvedAttribute;
                    A1 A1 = x2;
                    if (A1 instanceof ResolvedAttribute && (resolvedAttribute = (ResolvedAttribute)A1).matchesWith(this.t1$2, this.c1$2)) {
                        return (B1)resolvedAttribute;
                    }
                    if (A1 instanceof Expression.SingleColumn && (singleColumn = (Expression.SingleColumn)A1).matchesWith(this.t1$2, this.c1$2)) {
                        return (B1)singleColumn.expr();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Attribute x2) {
                    Expression.SingleColumn singleColumn;
                    ResolvedAttribute resolvedAttribute;
                    Attribute attribute = x2;
                    if (attribute instanceof ResolvedAttribute && (resolvedAttribute = (ResolvedAttribute)attribute).matchesWith(this.t1$2, this.c1$2)) {
                        return true;
                    }
                    return attribute instanceof Expression.SingleColumn && (singleColumn = (Expression.SingleColumn)attribute).matchesWith(this.t1$2, this.c1$2);
                }
                {
                    this.t1$2 = t1$2;
                    this.c1$2 = c1$2;
                }
            })).toList();
        }
        if (qName != null && (list = qName.parts()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            String c1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return ((IterableOnceOps)resolvedAttributes$1.collect((PartialFunction)new Serializable(c1){
                private static final long serialVersionUID = 0L;
                private final String c1$3;

                public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    Expression.SingleColumn singleColumn;
                    A1 A1 = x3;
                    if (A1 instanceof ResolvedAttribute) {
                        ResolvedAttribute resolvedAttribute = (ResolvedAttribute)A1;
                        String string = resolvedAttribute.name();
                        String string2 = this.c1$3;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return (B1)resolvedAttribute;
                        }
                    }
                    if (A1 instanceof Expression.SingleColumn && (singleColumn = (Expression.SingleColumn)A1).matchesWith(this.c1$3)) {
                        return (B1)singleColumn.expr();
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(Attribute x3) {
                    Expression.SingleColumn singleColumn;
                    Attribute attribute = x3;
                    if (attribute instanceof ResolvedAttribute) {
                        ResolvedAttribute resolvedAttribute = (ResolvedAttribute)attribute;
                        String string = resolvedAttribute.name();
                        String string2 = this.c1$3;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return true;
                        }
                    }
                    return attribute instanceof Expression.SingleColumn && (singleColumn = (Expression.SingleColumn)attribute).matchesWith(this.c1$3);
                }
                {
                    this.c1$3 = c1$3;
                }
            })).toList();
        }
        return package$.MODULE$.List().empty();
    }

    private TypeResolver$() {
    }
}

