/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.sql.analyzer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import wvlet.airframe.sql.SQLErrorCode$ColumnNotFound$;
import wvlet.airframe.sql.SQLErrorCode$InvalidArgument$;
import wvlet.airframe.sql.SQLErrorCode$SyntaxError$;
import wvlet.airframe.sql.SQLErrorCode$TableNotFound$;
import wvlet.airframe.sql.analyzer.AnalyzerContext;
import wvlet.airframe.sql.analyzer.CTEResolver$;
import wvlet.airframe.sql.analyzer.TypeResolver$;
import wvlet.airframe.sql.catalog.Catalog;
import wvlet.airframe.sql.model.Attribute;
import wvlet.airframe.sql.model.CTERelationRef;
import wvlet.airframe.sql.model.Expression;
import wvlet.airframe.sql.model.Expression$QName$;
import wvlet.airframe.sql.model.LogicalPlan;
import wvlet.airframe.sql.model.NodeLocation;
import wvlet.airframe.sql.model.ResolvedAttribute;
import wvlet.airframe.sql.model.TableScan;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class TypeResolver$
implements LogSupport {
    public static final TypeResolver$ MODULE$ = new TypeResolver$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        TypeResolver$ typeResolver$ = this;
        synchronized (typeResolver$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public List<Function1<AnalyzerContext, PartialFunction<LogicalPlan, LogicalPlan>>> typerRules() {
        Function1 & Serializable intersect = (Function1 & Serializable)context -> MODULE$.resolveCTETableRef((AnalyzerContext)context);
        Function1 & Serializable intersect2 = (Function1 & Serializable)context -> MODULE$.resolveAggregationIndexes((AnalyzerContext)context);
        Function1 & Serializable intersect3 = (Function1 & Serializable)context -> MODULE$.resolveAggregationKeys((AnalyzerContext)context);
        Function1 & Serializable intersect4 = (Function1 & Serializable)context -> MODULE$.resolveTableRef((AnalyzerContext)context);
        Function1 & Serializable intersect5 = (Function1 & Serializable)context -> MODULE$.resolveJoinUsing((AnalyzerContext)context);
        Function1 & Serializable intersect6 = (Function1 & Serializable)context -> MODULE$.resolveRegularRelation((AnalyzerContext)context);
        Function1 & Serializable intersect7 = (Function1 & Serializable)context -> MODULE$.resolveColumns((AnalyzerContext)context);
        Function1 & Serializable intersect8 = (Function1 & Serializable)context -> MODULE$.resolveUnion((AnalyzerContext)context);
        return Nil$.MODULE$.$colon$colon((Object)intersect8).$colon$colon((Object)intersect7).$colon$colon((Object)intersect6).$colon$colon((Object)intersect5).$colon$colon((Object)intersect4).$colon$colon((Object)intersect3).$colon$colon((Object)intersect2).$colon$colon((Object)intersect);
    }

    public LogicalPlan resolve(AnalyzerContext analyzerContext, LogicalPlan plan) {
        LogicalPlan resolvedPlan = (LogicalPlan)this.typerRules().foldLeft((Object)plan, (Function2 & Serializable)(targetPlan, rule) -> {
            PartialFunction r = (PartialFunction)rule.apply((Object)analyzerContext);
            LogicalPlan resolved = targetPlan.transform((PartialFunction<LogicalPlan, LogicalPlan>)r);
            return resolved;
        });
        return resolvedPlan;
    }

    public LogicalPlan.Relation resolveRelation(AnalyzerContext analyzerContext, LogicalPlan plan) {
        LogicalPlan resolvedPlan = this.resolve(analyzerContext, plan);
        LogicalPlan logicalPlan = resolvedPlan;
        if (logicalPlan instanceof LogicalPlan.Relation) {
            LogicalPlan.Relation relation = (LogicalPlan.Relation)logicalPlan;
            return relation;
        }
        throw SQLErrorCode$InvalidArgument$.MODULE$.newException(new StringBuilder(17).append(plan).append(" isn't a relation").toString(), plan.nodeLocation());
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveAggregationIndexes(AnalyzerContext context) {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Aggregate) {
                    LogicalPlan.Aggregate aggregate = (LogicalPlan.Aggregate)A1;
                    LogicalPlan.Relation child = aggregate.child();
                    List<Attribute> selectItems = aggregate.selectItems();
                    List<Expression.GroupingKey> groupingKeys = aggregate.groupingKeys();
                    Option<Expression> having = aggregate.having();
                    List resolvedGroupingKeys = groupingKeys.map((Function1 & Serializable)x0$1 -> {
                        Expression.LongLiteral longLiteral;
                        long i;
                        Expression expression;
                        Expression.GroupingKey groupingKey = x0$1;
                        if (groupingKey != null && (expression = groupingKey.child()) instanceof Expression.LongLiteral && (i = (longLiteral = (Expression.LongLiteral)expression).value()) <= (long)selectItems.length()) {
                            Expression expression2;
                            Attribute attribute = (Attribute)selectItems.apply((int)i - 1);
                            if (attribute instanceof Expression.SingleColumn) {
                                Expression.SingleColumn singleColumn = (Expression.SingleColumn)attribute;
                                Expression expr = singleColumn.expr();
                                expression2 = expr;
                            } else {
                                expression2 = attribute;
                            }
                            Attribute keyItem = expression2;
                            return new Expression.GroupingKey(keyItem, groupingKey.nodeLocation());
                        }
                        return groupingKey;
                    });
                    return (B1)new LogicalPlan.Aggregate(child, selectItems, (List<Expression.GroupingKey>)resolvedGroupingKeys, having, aggregate.nodeLocation());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Aggregate;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.collection.immutable.List wvlet.airframe.sql.model.Expression$GroupingKey )}, serializedLambda);
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveAggregationKeys(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Aggregate) {
                    LogicalPlan.Aggregate aggregate = (LogicalPlan.Aggregate)A1;
                    LogicalPlan.Relation child = aggregate.child();
                    List<Attribute> selectItems = aggregate.selectItems();
                    List<Expression.GroupingKey> groupingKeys = aggregate.groupingKeys();
                    Option<Expression> having = aggregate.having();
                    LogicalPlan.Relation resolvedChild = TypeResolver$.MODULE$.resolveRelation(this.context$1, child);
                    Seq<Attribute> inputAttributes = resolvedChild.outputAttributes();
                    List resolvedGroupingKeys = groupingKeys.map((Function1 & Serializable)x -> {
                        Expression e = TypeResolver$.MODULE$.resolveExpression($this.context$1, x.child(), inputAttributes);
                        return new Expression.GroupingKey(e, e.nodeLocation());
                    });
                    return (B1)new LogicalPlan.Aggregate(resolvedChild, selectItems, (List<Expression.GroupingKey>)resolvedGroupingKeys, having, aggregate.nodeLocation());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Aggregate;
            }
            {
                this.context$1 = context$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(wvlet.airframe.sql.analyzer.TypeResolver$$anonfun$resolveAggregationKeys$1 scala.collection.immutable.Seq wvlet.airframe.sql.model.Expression$GroupingKey )}, serializedLambda);
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveCTETableRef(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$2;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Query) {
                    LogicalPlan.Query query = (LogicalPlan.Query)A1;
                    return (B1)CTEResolver$.MODULE$.resolveCTE(this.context$2, query);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Query;
            }
            {
                this.context$2 = context$2;
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveTableRef(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$3;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.TableRef) {
                    LogicalPlan.TableRef tableRef = (LogicalPlan.TableRef)A1;
                    Expression.QName qname = tableRef.name();
                    Option<Catalog.Table> option = this.context$3.catalog().findFromQName(this.context$3.database(), qname);
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        Catalog.Table dbTable = (Catalog.Table)some.value();
                        if (TypeResolver$.MODULE$.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                            TypeResolver$.MODULE$.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "TypeResolver.scala", 124, 14), (Object)new StringBuilder(6).append("Found ").append(dbTable).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return (B1)new TableScan(dbTable, dbTable.schema().columns(), tableRef.nodeLocation());
                    }
                    if (None$.MODULE$.equals(option)) {
                        Option option2 = this.context$3.outerQueries().get((Object)qname.fullName());
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            LogicalPlan cte = (LogicalPlan)some.value();
                            return (B1)new CTERelationRef(qname.fullName(), cte.outputAttributes(), tableRef.nodeLocation());
                        }
                        if (None$.MODULE$.equals(option2)) {
                            throw SQLErrorCode$TableNotFound$.MODULE$.newException(new StringBuilder(17).append("Table ").append(this.context$3.database()).append(".").append(qname).append(" not found").toString(), tableRef.nodeLocation());
                        }
                        throw new MatchError((Object)option2);
                    }
                    throw new MatchError(option);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.TableRef;
            }
            {
                this.context$3 = context$3;
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveJoinUsing(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$4;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                LogicalPlan.Join join = null;
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Join) {
                    bl = true;
                    join = (LogicalPlan.Join)A1;
                    LogicalPlan.JoinType joinType = join.joinType();
                    LogicalPlan.Relation left = join.left();
                    LogicalPlan.Relation right = join.right();
                    Expression.JoinCriteria u = join.cond();
                    if (u instanceof Expression.JoinUsing) {
                        Expression.JoinUsing joinUsing = (Expression.JoinUsing)u;
                        Seq<Expression.Identifier> joinKeys = joinUsing.columns();
                        LogicalPlan.Join resolvedJoin = new LogicalPlan.Join(joinType, TypeResolver$.MODULE$.resolveRelation(this.context$4, left), TypeResolver$.MODULE$.resolveRelation(this.context$4, right), joinUsing, join.nodeLocation());
                        Seq resolvedJoinKeys = (Seq)joinKeys.flatMap((Function1 & Serializable)k -> {
                            List<Expression> list = TypeResolver$.MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes($this.context$4, (Expression)k, resolvedJoin.inputAttributes());
                            if (Nil$.MODULE$.equals(list)) {
                                throw SQLErrorCode$ColumnNotFound$.MODULE$.newException(new StringBuilder(30).append("join key column: ").append(k.sqlExpr()).append(" is not found").toString(), k.nodeLocation());
                            }
                            return list;
                        });
                        LogicalPlan.Join updated = resolvedJoin.withCond(new Expression.JoinOnEq((Seq<Expression>)resolvedJoinKeys, joinUsing.nodeLocation()));
                        return (B1)updated;
                    }
                }
                if (bl) {
                    Expression.JoinOn joinOn;
                    Expression expression;
                    LogicalPlan.JoinType joinType = join.joinType();
                    LogicalPlan.Relation left = join.left();
                    LogicalPlan.Relation right = join.right();
                    Expression.JoinCriteria u = join.cond();
                    if (u instanceof Expression.JoinOn && (expression = (joinOn = (Expression.JoinOn)u).expr()) instanceof Expression.Eq) {
                        Expression.Eq eq = (Expression.Eq)expression;
                        Expression leftKey = eq.left();
                        Expression rightKey = eq.right();
                        LogicalPlan.Join resolvedJoin = new LogicalPlan.Join(joinType, TypeResolver$.MODULE$.resolveRelation(this.context$4, left), TypeResolver$.MODULE$.resolveRelation(this.context$4, right), joinOn, join.nodeLocation());
                        Seq resolvedJoinKeys = (Seq)new .colon.colon((Object)leftKey, (List)new .colon.colon((Object)rightKey, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable)k -> {
                            List<Expression> list = TypeResolver$.MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes($this.context$4, (Expression)k, resolvedJoin.inputAttributes());
                            if (Nil$.MODULE$.equals(list)) {
                                throw SQLErrorCode$ColumnNotFound$.MODULE$.newException(new StringBuilder(30).append("join key column: ").append(k.sqlExpr()).append(" is not found").toString(), k.nodeLocation());
                            }
                            return list;
                        });
                        LogicalPlan.Join updated = resolvedJoin.withCond(new Expression.JoinOnEq((Seq<Expression>)resolvedJoinKeys, joinOn.expr().nodeLocation()));
                        return (B1)updated;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Expression.JoinOn joinOn;
                Expression expression;
                Expression.JoinCriteria u;
                boolean bl = false;
                LogicalPlan.Join join = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof LogicalPlan.Join) {
                    bl = true;
                    join = (LogicalPlan.Join)logicalPlan;
                    Expression.JoinCriteria u2 = join.cond();
                    if (u2 instanceof Expression.JoinUsing) {
                        return true;
                    }
                }
                return bl && (u = join.cond()) instanceof Expression.JoinOn && (expression = (joinOn = (Expression.JoinOn)u).expr()) instanceof Expression.Eq;
            }
            {
                this.context$4 = context$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(wvlet.airframe.sql.analyzer.TypeResolver$$anonfun$resolveJoinUsing$1 wvlet.airframe.sql.model.LogicalPlan$Join wvlet.airframe.sql.model.Expression$Identifier ), $anonfun$applyOrElse$4(wvlet.airframe.sql.analyzer.TypeResolver$$anonfun$resolveJoinUsing$1 wvlet.airframe.sql.model.LogicalPlan$Join wvlet.airframe.sql.model.Expression )}, serializedLambda);
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveRegularRelation(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            public final AnalyzerContext context$5;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Filter) {
                    LogicalPlan.Filter filter = (LogicalPlan.Filter)A1;
                    return (B1)filter.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(this, filter){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.resolveRegularRelation.1 $outer;
                        private final LogicalPlan.Filter x2$1;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 != null) {
                                A1 A12 = A1;
                                return (B1)TypeResolver$.MODULE$.resolveExpression(this.$outer.context$5, A12, this.x2$1.inputAttributes());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression = x1;
                            return expression != null;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$1 = x2$1;
                        }
                    });
                }
                if (A1 instanceof LogicalPlan.Relation) {
                    LogicalPlan.Relation relation = (LogicalPlan.Relation)A1;
                    return (B1)relation.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(this, relation){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.resolveRegularRelation.1 $outer;
                        private final LogicalPlan.Relation x4$1;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            if (A1 != null) {
                                A1 A12 = A1;
                                return (B1)TypeResolver$.MODULE$.resolveExpression(this.$outer.context$5, A12, this.x4$1.inputAttributes());
                            }
                            return (B1)function1.apply(x2);
                        }

                        public final boolean isDefinedAt(Expression x2) {
                            Expression expression = x2;
                            return expression != null;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x4$1 = x4$1;
                        }
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof LogicalPlan.Filter) {
                    return true;
                }
                return logicalPlan instanceof LogicalPlan.Relation;
            }
            {
                this.context$5 = context$5;
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveUnion(AnalyzerContext context) {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Union) {
                    LogicalPlan.Union union = (LogicalPlan.Union)A1;
                    return (B1)union;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Union;
            }
        };
    }

    public PartialFunction<LogicalPlan, LogicalPlan> resolveColumns(AnalyzerContext context) {
        return new Serializable(context){
            private static final long serialVersionUID = 0L;
            private final AnalyzerContext context$6;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Project) {
                    LogicalPlan.Project project = (LogicalPlan.Project)A1;
                    LogicalPlan.Relation child = project.child();
                    Seq<Attribute> columns = project.selectItems();
                    Seq<Attribute> resolvedColumns = TypeResolver$.MODULE$.wvlet$airframe$sql$analyzer$TypeResolver$$resolveOutputColumns(this.context$6, child.outputAttributes(), columns);
                    LogicalPlan.Project resolved = new LogicalPlan.Project(child, resolvedColumns, project.nodeLocation());
                    return (B1)resolved;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalPlan.Project;
            }
            {
                this.context$6 = context$6;
            }
        };
    }

    public Seq<Attribute> wvlet$airframe$sql$analyzer$TypeResolver$$resolveOutputColumns(AnalyzerContext context, Seq<Attribute> inputAttributes, Seq<Attribute> outputColumns) {
        Builder resolvedColumns = package$.MODULE$.Seq().newBuilder();
        outputColumns.map((Function1 & Serializable)x0$1 -> {
            Attribute attribute = x0$1;
            if (attribute instanceof Expression.AllColumns) {
                return (Builder)resolvedColumns.$plus$plus$eq((IterableOnce)inputAttributes);
            }
            if (attribute instanceof Expression.SingleColumn) {
                Expression.SingleColumn singleColumn = (Expression.SingleColumn)attribute;
                Expression expr = singleColumn.expr();
                Option<Expression> alias = singleColumn.alias();
                Option<NodeLocation> nodeLocation = singleColumn.nodeLocation();
                boolean bl = false;
                ResolvedAttribute resolvedAttribute = null;
                Expression expression = MODULE$.resolveExpression(context, expr, inputAttributes);
                if (expression instanceof ResolvedAttribute) {
                    bl = true;
                    resolvedAttribute = (ResolvedAttribute)expression;
                    if (alias.isEmpty()) {
                        return (Builder)resolvedColumns.$plus$eq((Object)resolvedAttribute);
                    }
                }
                if (bl && alias.nonEmpty()) {
                    return (Builder)resolvedColumns.$plus$eq((Object)new ResolvedAttribute(((Expression)alias.get()).sqlExpr(), resolvedAttribute.dataType(), resolvedAttribute.qualifier(), resolvedAttribute.sourceTable(), resolvedAttribute.sourceColumn(), resolvedAttribute.nodeLocation()));
                }
                return (Builder)resolvedColumns.$plus$eq((Object)new Expression.SingleColumn(expression, alias, (Option<String>)None$.MODULE$, nodeLocation));
            }
            return (Builder)resolvedColumns.$plus$eq((Object)attribute);
        });
        Seq output = (Seq)resolvedColumns.result();
        return output;
    }

    public Attribute resolveAttribute(Attribute attribute) {
        boolean bl = false;
        Expression.SingleColumn singleColumn = null;
        Attribute attribute2 = attribute;
        if (attribute2 instanceof Expression.SingleColumn) {
            bl = true;
            singleColumn = (Expression.SingleColumn)attribute2;
            Expression r = singleColumn.expr();
            Option<Expression> option = singleColumn.alias();
            if (r instanceof ResolvedAttribute) {
                ResolvedAttribute resolvedAttribute = (ResolvedAttribute)r;
                if (None$.MODULE$.equals(option)) {
                    return resolvedAttribute;
                }
            }
        }
        if (bl) {
            Expression r = singleColumn.expr();
            Option<Expression> option = singleColumn.alias();
            if (r instanceof ResolvedAttribute) {
                Some some;
                Expression alias;
                ResolvedAttribute resolvedAttribute = (ResolvedAttribute)r;
                if (option instanceof Some && (alias = (Expression)(some = (Some)option).value()) instanceof Expression.Identifier) {
                    Expression.Identifier identifier = (Expression.Identifier)alias;
                    return resolvedAttribute.withAlias(identifier.value());
                }
            }
        }
        return attribute2;
    }

    public List<Expression> wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes(AnalyzerContext context, Expression expr, Seq<Attribute> inputAttributes) {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "TypeResolver.scala", 257, 10), (Object)new StringBuilder(47).append("findMatchInInputAttributes: ").append(expr).append(", inputAttributes: ").append(inputAttributes).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Expression expression = expr;
        if (expression instanceof Expression.Identifier) {
            Expression.Identifier identifier = (Expression.Identifier)expression;
            return TypeResolver$.lookup$1(identifier.value(), context, inputAttributes);
        }
        if (expression instanceof Expression.UnresolvedAttribute) {
            Expression.UnresolvedAttribute unresolvedAttribute = (Expression.UnresolvedAttribute)expression;
            String name = unresolvedAttribute.name();
            return TypeResolver$.lookup$1(name, context, inputAttributes);
        }
        return new .colon.colon((Object)expr, (List)Nil$.MODULE$);
    }

    public Expression resolveExpression(AnalyzerContext context, Expression expr, Seq<Attribute> inputAttributes) {
        List<Expression> list = this.wvlet$airframe$sql$analyzer$TypeResolver$$findMatchInInputAttributes(context, expr, inputAttributes);
        if (list.length() > 1) {
            throw SQLErrorCode$SyntaxError$.MODULE$.newException(new StringBuilder(13).append(expr.sqlExpr()).append(" is ambiguous").toString(), expr.nodeLocation());
        }
        return (Expression)list.headOption().getOrElse((Function0 & Serializable)() -> expr);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TypeResolver$.class);
    }

    private static final List lookup$1(String name, AnalyzerContext context$8, Seq inputAttributes$3) {
        SeqOps seqOps;
        List<String> list;
        SeqOps seqOps2;
        List<String> list2;
        SeqOps seqOps3;
        List<String> list3;
        Expression.QName qName = Expression$QName$.MODULE$.apply(name, (Option<NodeLocation>)None$.MODULE$);
        if (qName != null && (list3 = qName.parts()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq(list3)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 3) == 0) {
            String db = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
            String t1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
            String c1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2);
            String string = context$8.database();
            String string2 = db;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return ((IterableOnceOps)inputAttributes$3.collect((PartialFunction)new Serializable(t1, c1){
                    private static final long serialVersionUID = 0L;
                    private final String t1$1;
                    private final String c1$1;

                    public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        ResolvedAttribute resolvedAttribute;
                        A1 A1 = x1;
                        if (A1 instanceof ResolvedAttribute && (resolvedAttribute = (ResolvedAttribute)A1).matchesWith(this.t1$1, this.c1$1)) {
                            return (B1)resolvedAttribute;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Attribute x1) {
                        ResolvedAttribute resolvedAttribute;
                        Attribute attribute = x1;
                        return attribute instanceof ResolvedAttribute && (resolvedAttribute = (ResolvedAttribute)attribute).matchesWith(this.t1$1, this.c1$1);
                    }
                    {
                        this.t1$1 = t1$1;
                        this.c1$1 = c1$1;
                    }
                })).toList();
            }
        }
        if (qName != null && (list2 = qName.parts()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
            String t1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            String c1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            return ((IterableOnceOps)inputAttributes$3.collect((PartialFunction)new Serializable(t1, c1){
                private static final long serialVersionUID = 0L;
                private final String t1$2;
                private final String c1$2;

                public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    ResolvedAttribute resolvedAttribute;
                    A1 A1 = x2;
                    if (A1 instanceof ResolvedAttribute && (resolvedAttribute = (ResolvedAttribute)A1).matchesWith(this.t1$2, this.c1$2)) {
                        return (B1)resolvedAttribute;
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Attribute x2) {
                    ResolvedAttribute resolvedAttribute;
                    Attribute attribute = x2;
                    return attribute instanceof ResolvedAttribute && (resolvedAttribute = (ResolvedAttribute)attribute).matchesWith(this.t1$2, this.c1$2);
                }
                {
                    this.t1$2 = t1$2;
                    this.c1$2 = c1$2;
                }
            })).toList();
        }
        if (qName != null && (list = qName.parts()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            String c1 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return ((IterableOnceOps)inputAttributes$3.collect((PartialFunction)new Serializable(c1){
                private static final long serialVersionUID = 0L;
                private final String c1$3;

                public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof ResolvedAttribute) {
                        ResolvedAttribute resolvedAttribute = (ResolvedAttribute)A1;
                        String string = resolvedAttribute.name();
                        String string2 = this.c1$3;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return (B1)resolvedAttribute;
                        }
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(Attribute x3) {
                    Attribute attribute = x3;
                    if (attribute instanceof ResolvedAttribute) {
                        ResolvedAttribute resolvedAttribute = (ResolvedAttribute)attribute;
                        String string = resolvedAttribute.name();
                        String string2 = this.c1$3;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return true;
                        }
                    }
                    return false;
                }
                {
                    this.c1$3 = c1$3;
                }
            })).toList();
        }
        return package$.MODULE$.List().empty();
    }

    private TypeResolver$() {
    }
}

