/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients.axis2client;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.security.WSPasswordCallback;
import org.testng.Assert;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.esb.integration.common.utils.clients.axis2client.ConfigurationContextProvider;

public class SecureAxisServiceClient
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(SecureAxisServiceClient.class);

    private static OMElement buildResponse(OMElement omElement) {
        omElement.build();
        return omElement;
    }

    public OMElement sendReceive(String userName, String password, String endpointReference, String operation, OMElement payload, int securityScenarioNo) throws Exception {
        OMElement result;
        if (securityScenarioNo == 1) {
            Assert.assertTrue((boolean)endpointReference.startsWith("https:"), (String)"Endpoint reference should be https");
        }
        String keyPath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "keystores" + File.separator + "products";
        String securityPolicyPath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "security" + File.separator + "policiesscenario" + securityScenarioNo + "-policy.xml";
        ServiceClient sc = this.getServiceClient(userName, password, endpointReference, operation, securityPolicyPath, "wso2carbon", "wso2carbon", keyPath, "wso2carbon");
        if (log.isDebugEnabled()) {
            log.debug((Object)("payload :" + payload));
            log.debug((Object)("Security Scenario No :" + securityScenarioNo));
            log.debug((Object)("Operation :" + operation));
            log.debug((Object)("username :" + userName));
            log.debug((Object)("password :" + password));
        }
        log.info((Object)("Endpoint reference :" + endpointReference));
        try {
            result = SecureAxisServiceClient.buildResponse(sc.sendReceive(payload));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response :" + result));
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)("AxisFault : " + axisFault.getMessage()));
            throw axisFault;
        }
        finally {
            sc.cleanupTransport();
        }
        Assert.assertNotNull((Object)result);
        return result;
    }

    public OMElement sendReceive(String userName, String password, String endpointReference, String operation, OMElement payload, String securityPolicyPath, String userCertAlias, String encryptionUser, String keyStorePath, String keyStorePassword) throws Exception {
        OMElement result;
        ServiceClient sc = this.getServiceClient(userName, password, endpointReference, operation, securityPolicyPath, userCertAlias, encryptionUser, keyStorePath, keyStorePassword);
        if (log.isDebugEnabled()) {
            log.debug((Object)("payload :" + payload));
            log.debug((Object)("Policy Path :" + securityPolicyPath));
            log.debug((Object)("Operation :" + operation));
            log.debug((Object)("username :" + userName));
            log.debug((Object)("password :" + password));
        }
        log.info((Object)("Endpoint reference :" + endpointReference));
        try {
            result = SecureAxisServiceClient.buildResponse(sc.sendReceive(payload));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response :" + result));
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)("AxisFault : " + axisFault.getMessage()));
            throw axisFault;
        }
        finally {
            sc.cleanupTransport();
        }
        Assert.assertNotNull((Object)result);
        return result;
    }

    public void sendRobust(String userName, String password, String endpointReference, String operation, OMElement payload, int securityScenarioNo) throws Exception {
        if (securityScenarioNo == 1) {
            Assert.assertTrue((boolean)endpointReference.startsWith("https:"), (String)"Endpoint reference should be https");
        }
        String keyPath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "keystores" + File.separator + "products";
        String securityPolicyPath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "security" + File.separator + "policiesscenario" + securityScenarioNo + "-policy.xml";
        ServiceClient sc = this.getServiceClient(userName, password, endpointReference, operation, securityPolicyPath, "wso2carbon", "wso2carbon", keyPath, "wso2carbon");
        try {
            sc.sendRobust(payload);
            log.info((Object)"Request Sent");
        }
        catch (AxisFault axisFault) {
            log.error((Object)("AxisFault : " + axisFault.getMessage()));
            throw axisFault;
        }
        finally {
            sc.cleanupTransport();
        }
    }

    public void sendRobust(String userName, String password, String endpointReference, String operation, OMElement payload, String securityPolicyPath, String userCertAlias, String encryptionUser, String keyStorePath, String keyStorePassword) throws Exception {
        ServiceClient sc = this.getServiceClient(userName, password, endpointReference, operation, securityPolicyPath, userCertAlias, encryptionUser, keyStorePath, keyStorePassword);
        if (log.isDebugEnabled()) {
            log.debug((Object)("payload :" + payload));
            log.debug((Object)("Security Policy Path :" + securityPolicyPath));
            log.debug((Object)("Operation :" + operation));
            log.debug((Object)("username :" + userName));
            log.debug((Object)("password :" + password));
        }
        log.info((Object)("Endpoint reference :" + endpointReference));
        try {
            sc.sendRobust(payload);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("AxisFault : " + axisFault.getMessage()));
            throw axisFault;
        }
        finally {
            sc.cleanupTransport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy loadPolicy(String userName, String securityPolicyPath, String keyStorePath, String keyStorePassword, String userCertAlias, String encryptionUser) throws Exception {
        Policy policy = null;
        try (StAXOMBuilder builder = null;){
            builder = new StAXOMBuilder(securityPolicyPath);
            policy = PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
            RampartConfig rc = new RampartConfig();
            rc.setUser(userName);
            rc.setUserCertAlias(userCertAlias);
            rc.setEncryptionUser(encryptionUser);
            rc.setPwCbClass(SecureAxisServiceClient.class.getName());
            CryptoConfig sigCryptoConfig = new CryptoConfig();
            sigCryptoConfig.setProvider("org.apache.ws.security.components.crypto.Merlin");
            Properties prop1 = new Properties();
            prop1.put("org.apache.ws.security.crypto.merlin.keystore.type", "JKS");
            prop1.put("org.apache.ws.security.crypto.merlin.file", keyStorePath);
            prop1.put("org.apache.ws.security.crypto.merlin.keystore.password", keyStorePassword);
            sigCryptoConfig.setProp(prop1);
            CryptoConfig encrCryptoConfig = new CryptoConfig();
            encrCryptoConfig.setProvider("org.apache.ws.security.components.crypto.Merlin");
            Properties prop2 = new Properties();
            prop2.put("org.apache.ws.security.crypto.merlin.keystore.type", "JKS");
            prop2.put("org.apache.ws.security.crypto.merlin.file", keyStorePath);
            prop2.put("org.apache.ws.security.crypto.merlin.keystore.password", keyStorePassword);
            encrCryptoConfig.setProp(prop2);
            rc.setSigCryptoConfig(sigCryptoConfig);
            rc.setEncrCryptoConfig(encrCryptoConfig);
            policy.addAssertion((Assertion)rc);
        }
        Assert.assertNotNull((Object)policy, (String)"Policy cannot be null");
        return policy;
    }

    private ServiceClient getServiceClient(String userName, String password, String endpointReference, String operation, String securityPolicyPath, String userCertAlias, String encryptionUser, String keyStorePath, String keyStorePassword) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Key_Path :" + keyStorePath));
            if (securityPolicyPath != null) {
                log.debug((Object)("securityPolicyPath :" + securityPolicyPath));
            }
        }
        System.setProperty("javax.net.ssl.trustStore", keyStorePath);
        System.setProperty("javax.net.ssl.trustStorePassword", keyStorePassword);
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.net.ssl.trustStore :" + System.getProperty("javax.net.ssl.trustStore")));
            log.debug((Object)("javax.net.ssl.trustStorePassword :" + System.getProperty("javax.net.ssl.trustStorePassword")));
        }
        ServiceClient sc = null;
        try {
            sc = new ServiceClient(ConfigurationContextProvider.getInstance().getConfigurationContext(), null);
            if (securityPolicyPath != null) {
                sc.engageModule("rampart");
                sc.engageModule("addressing");
            }
            Options opts = new Options();
            try {
                if (securityPolicyPath != null) {
                    opts.setProperty("rampartPolicy", (Object)this.loadPolicy(userName, securityPolicyPath, keyStorePath, keyStorePassword, userCertAlias, encryptionUser));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new Exception(e.getMessage(), e);
            }
            opts.setTo(new EndpointReference(endpointReference));
            opts.setAction("urn:" + operation);
            opts.setUserName(userName);
            opts.setPassword(password);
            sc.setOptions(opts);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("AxisFault : " + axisFault.getMessage()));
            throw axisFault;
        }
        finally {
            if (sc != null) {
                sc.cleanupTransport();
            }
        }
        Assert.assertNotNull((Object)("ServiceClient object is null" + sc));
        return sc;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        WSPasswordCallback pwcb = (WSPasswordCallback)callbacks[0];
        String id = pwcb.getIdentifer();
        int usage = pwcb.getUsage();
        if (usage == 3 || usage == 1) {
            if ("client".equals(id)) {
                pwcb.setPassword("automation");
            } else if ("service".equals(id)) {
                pwcb.setPassword("automation");
            } else if ("wso2carbon".equals(id)) {
                pwcb.setPassword("wso2carbon");
            } else if ("alice".equals(id)) {
                pwcb.setPassword("password");
            } else if ("bob".equals(id)) {
                pwcb.setPassword("password");
            }
        }
    }
}

