/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadbalanceFailoverClient {
    private static final Log log = LogFactory.getLog(LoadbalanceFailoverClient.class);
    private static final String COOKIE = "Cookie";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String DEFAULT_CLIENT_REPO = "client_repo";
    private ConfigurationContext cfgCtx;
    private ServiceClient serviceClient;

    public LoadbalanceFailoverClient() {
        String repositoryPath = System.getProperty("carbon.home") + File.separator + "samples" + File.separator + "axis2Client" + File.separator + DEFAULT_CLIENT_REPO;
        File repository = new File(repositoryPath);
        log.info((Object)("Using the Axis2 repository path: " + repository.getAbsolutePath()));
        try {
            this.cfgCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repository.getCanonicalPath(), null);
            this.serviceClient = new ServiceClient(this.cfgCtx, null);
            log.info((Object)"Sample clients initialized successfully...");
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing the StockQuoteClient", (Throwable)e);
        }
    }

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public void sendLoadBalanceRequests() throws Exception {
        new LoadbalanceFailoverClient().sessionlessClient();
    }

    public String sessionlessClient() throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement value = fac.createOMElement("Value", null);
        value.setText("Sample string");
        Options options = new Options();
        options.setTo(new EndpointReference("http://localhost:8480/services/LBService1"));
        options.setAction("urn:sampleOperation");
        long timeout = Integer.parseInt(LoadbalanceFailoverClient.getProperty("timeout", "10000000"));
        System.out.println("timeout=" + timeout);
        options.setTimeOutInMilliSeconds(timeout);
        this.serviceClient.engageModule("addressing");
        options.setTo(new EndpointReference("http://localhost:8480"));
        this.serviceClient.setOptions(options);
        String testString = "";
        long i = 0L;
        while (i < 100L) {
            this.serviceClient.getOptions().setManageSession(true);
            OMElement responseElement = this.serviceClient.sendReceive(value);
            String response = responseElement.getText();
            System.out.println("Request: " + ++i + " ==> " + response);
            testString = testString.concat(":" + i + ">" + response + ":");
        }
        return testString;
    }

    public String sendLoadBalanceRequest(String proxyURL, String serviceURL) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement value = fac.createOMElement("Value", null);
        value.setText("Sample string");
        Options options = new Options();
        if (proxyURL != null && !"null".equals(proxyURL)) {
            options.setTo(new EndpointReference(proxyURL));
        }
        options.setAction("urn:sampleOperation");
        long timeout = Integer.parseInt(LoadbalanceFailoverClient.getProperty("timeout", "10000000"));
        System.out.println("timeout=" + timeout);
        options.setTimeOutInMilliSeconds(timeout);
        if (serviceURL != null && !"null".equals(serviceURL)) {
            this.serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(serviceURL));
        }
        this.serviceClient.setOptions(options);
        this.serviceClient.getOptions().setManageSession(true);
        OMElement responseElement = this.serviceClient.sendReceive(value);
        String response = responseElement.getText();
        return response;
    }

    public String sendLoadBalanceRequest(String proxyURL, String serviceURL, String clientTimeoutInMilliSeconds) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement value = fac.createOMElement("Value", null);
        value.setText("Sample string");
        Options options = new Options();
        if (proxyURL != null && !"null".equals(proxyURL)) {
            options.setTo(new EndpointReference(proxyURL));
        }
        options.setAction("urn:sampleOperation");
        long timeout = Integer.parseInt(LoadbalanceFailoverClient.getProperty("timeout", clientTimeoutInMilliSeconds));
        System.out.println("timeout=" + timeout);
        options.setTimeOutInMilliSeconds(timeout);
        if (serviceURL != null && !"null".equals(serviceURL)) {
            this.serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(serviceURL));
        }
        this.serviceClient.setOptions(options);
        this.serviceClient.getOptions().setManageSession(true);
        OMElement responseElement = this.serviceClient.sendReceive(value);
        String response = responseElement.getText();
        return response;
    }

    public String sendSleepRequest(String proxyURL, String sleepTimeInMilliSeconds, String clientTimeoutInMilliSeconds) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement sleepOperation = fac.createOMElement("sleepOperation", omNs);
        OMElement load = fac.createOMElement("load", null);
        load.setText(sleepTimeInMilliSeconds);
        sleepOperation.addChild((OMNode)load);
        Options options = new Options();
        if (proxyURL != null && !"null".equals(proxyURL)) {
            options.setTo(new EndpointReference(proxyURL));
        }
        options.setAction("urn:sleepOperation");
        long timeout = Integer.parseInt(LoadbalanceFailoverClient.getProperty("timeout", clientTimeoutInMilliSeconds));
        System.out.println("timeout=" + timeout);
        options.setTimeOutInMilliSeconds(timeout);
        this.serviceClient.setOptions(options);
        this.serviceClient.getOptions().setManageSession(true);
        OMElement responseElement = this.serviceClient.sendReceive(sleepOperation);
        String response = responseElement.getText();
        return response;
    }

    public String sendLoadBalanceFailoverRequest(String URL2) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement value = fac.createOMElement("Value", null);
        value.setText("Sample string");
        Options options = new Options();
        options.setTo(new EndpointReference(URL2));
        options.setAction("urn:sampleOperation");
        long timeout = Integer.parseInt(LoadbalanceFailoverClient.getProperty("timeout", "10000000"));
        System.out.println("timeout=" + timeout);
        options.setTimeOutInMilliSeconds(timeout);
        this.serviceClient.engageModule("addressing");
        options.setTo(new EndpointReference("http://localhost:8280"));
        this.serviceClient.setOptions(options);
        this.serviceClient.getOptions().setManageSession(true);
        this.serviceClient.getOptions().setTo(new EndpointReference(URL2));
        OMElement responseElement = this.serviceClient.sendReceive(value);
        String response = responseElement.getText();
        return response;
    }

    private void sessionfullClient() {
        String synapsePort = "8480";
        int iterations = 100;
        boolean infinite = true;
        String pPort = LoadbalanceFailoverClient.getProperty("port", synapsePort);
        String pIterations = LoadbalanceFailoverClient.getProperty("i", null);
        String addUrl = LoadbalanceFailoverClient.getProperty("addurl", null);
        String trpUrl = LoadbalanceFailoverClient.getProperty("trpurl", null);
        String prxUrl = LoadbalanceFailoverClient.getProperty("prxurl", null);
        String sleep = LoadbalanceFailoverClient.getProperty("sleep", null);
        String session = LoadbalanceFailoverClient.getProperty("session", null);
        long sleepTime = -1L;
        if (sleep != null) {
            try {
                sleepTime = Long.parseLong(sleep);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (pPort != null) {
            try {
                Integer.parseInt(pPort);
                synapsePort = pPort;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (pIterations != null) {
            try {
                iterations = Integer.parseInt(pIterations);
                if (iterations != -1) {
                    infinite = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Options options = new Options();
        options.setTo(new EndpointReference("http://localhost:" + synapsePort + "/services/LBService1"));
        options.setAction("urn:sampleOperation");
        options.setTimeOutInMilliSeconds(10000000L);
        try {
            boolean httpSession;
            SOAPEnvelope env1 = this.buildSoapEnvelope("c1", "v1");
            SOAPEnvelope env2 = this.buildSoapEnvelope("c2", "v1");
            SOAPEnvelope env3 = this.buildSoapEnvelope("c3", "v1");
            SOAPEnvelope[] envelopes = new SOAPEnvelope[]{env1, env2, env3};
            String repoLocationProperty = System.getProperty("repository");
            String repo = repoLocationProperty != null ? repoLocationProperty : DEFAULT_CLIENT_REPO;
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
            ServiceClient client = new ServiceClient(configContext, null);
            if (addUrl != null && !"null".equals(addUrl)) {
                client.engageModule("addressing");
                options.setTo(new EndpointReference(addUrl));
            }
            if (trpUrl != null && !"null".equals(trpUrl)) {
                options.setProperty("TransportURL", (Object)trpUrl);
            } else {
                client.engageModule("addressing");
            }
            if (prxUrl != null && !"null".equals(prxUrl)) {
                HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
                try {
                    URL url = new URL(prxUrl);
                    proxyProperties.setProxyName(url.getHost());
                    proxyProperties.setProxyPort(url.getPort());
                    proxyProperties.setUserName("");
                    proxyProperties.setPassWord("");
                    proxyProperties.setDomain("");
                    options.setProperty("PROXY", (Object)proxyProperties);
                }
                catch (MalformedURLException e) {
                    throw new AxisFault("Error creating proxy URL", (Throwable)e);
                }
            }
            client.setOptions(options);
            int i = 0;
            String[] cookies = new String[3];
            boolean bl = httpSession = session != null && "http".equals(session);
            while (i < iterations || infinite) {
                ++i;
                if (sleepTime != -1L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                MessageContext messageContext = new MessageContext();
                int sessionNumber = this.getSessionTurn(envelopes.length);
                messageContext.setEnvelope(envelopes[sessionNumber]);
                int cookieNumber = this.getSessionTurn(cookies.length);
                String cookie = cookies[cookieNumber];
                if (httpSession) {
                    this.setSessionID(messageContext, cookie);
                }
                try {
                    OperationClient op = client.createClient(ServiceClient.ANON_OUT_IN_OP);
                    op.addMessageContext(messageContext);
                    op.execute(true);
                    MessageContext responseContext = op.getMessageContext("In");
                    String receivedCookie = this.extractSessionID(responseContext);
                    String receivedSetCookie = this.getSetCookieHeader(responseContext);
                    if (httpSession && receivedSetCookie != null && !"".equals(receivedSetCookie)) {
                        cookies[cookieNumber] = receivedCookie;
                    }
                    SOAPEnvelope responseEnvelope = responseContext.getEnvelope();
                    OMElement vElement = responseEnvelope.getBody().getFirstChildWithName(new QName("Value"));
                    System.out.println("Request: " + i + " with Session ID: " + (httpSession ? cookie : Integer.valueOf(sessionNumber)) + " ---- Response : with  " + (httpSession && receivedCookie != null ? (receivedSetCookie != null ? receivedSetCookie : receivedCookie) : " ") + " " + vElement.getText());
                }
                catch (AxisFault axisFault) {
                    System.out.println("Request with session id " + (httpSession ? cookie : Integer.valueOf(sessionNumber)) + " - Get a Fault : " + axisFault.getMessage());
                }
            }
        }
        catch (AxisFault axisFault) {
            System.out.println(axisFault.getMessage());
        }
    }

    private int getSessionTurn(int max) {
        Random random = new Random();
        return random.nextInt(max);
    }

    protected String extractSessionID(MessageContext axis2MessageContext) {
        Object o = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            Map headerMap = (Map)o;
            String cookie = (String)headerMap.get(SET_COOKIE);
            cookie = cookie == null ? (String)headerMap.get(COOKIE) : cookie.split(";")[0];
            return cookie;
        }
        return null;
    }

    protected String getSetCookieHeader(MessageContext axis2MessageContext) {
        Object o = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            Map headerMap = (Map)o;
            return (String)headerMap.get(SET_COOKIE);
        }
        return null;
    }

    protected void setSessionID(MessageContext axis2MessageContext, String value) {
        if (value == null) {
            return;
        }
        HashMap<String, String> map = (HashMap<String, String>)axis2MessageContext.getProperty("HTTP_HEADERS");
        if (map == null) {
            map = new HashMap<String, String>();
            axis2MessageContext.setProperty("HTTP_HEADERS", map);
        }
        map.put(COOKIE, value);
    }

    private SOAPEnvelope buildSoapEnvelope(String clientID, String value) {
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope envelope = soapFactory.createSOAPEnvelope();
        SOAPHeader header = soapFactory.createSOAPHeader();
        envelope.addChild((OMNode)header);
        OMNamespace synNamespace = soapFactory.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
        OMElement clientIDElement = soapFactory.createOMElement("ClientID", synNamespace);
        clientIDElement.setText(clientID);
        header.addChild((OMNode)clientIDElement);
        SOAPBody body = soapFactory.createSOAPBody();
        envelope.addChild((OMNode)body);
        OMElement valueElement = soapFactory.createOMElement("Value", null);
        valueElement.setText(value);
        body.addChild((OMNode)valueElement);
        return envelope;
    }
}

