/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.stringparser.jackson2;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.List;
import org.wiremock.stringparser.ParsedString;
import org.wiremock.stringparser.StringParser;
import org.wiremock.stringparser.jackson2.ParsedStringDeserializer;

public class ParsedStringModule
extends SimpleModule {
    private final List<StringParser<?>> stringParsers;

    public ParsedStringModule(List<StringParser<?>> stringParsers) {
        this.stringParsers = stringParsers;
    }

    public List<StringParser<?>> getStringParsers() {
        return this.stringParsers;
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)new SimpleSerializers(List.of(new ToStringSerializer(ParsedString.class))));
        SimpleDeserializers deserializers = new SimpleDeserializers();
        for (StringParser<?> deserializer : this.stringParsers) {
            this.addDeserializer(deserializers, new ParsedStringDeserializer(deserializer));
        }
        context.addDeserializers((Deserializers)deserializers);
    }

    private <T extends ParsedString> void addDeserializer(SimpleDeserializers deserializers, ParsedStringDeserializer<T> deserializer) {
        deserializers.addDeserializer(deserializer.getStringParser().getType(), deserializer);
    }
}

