/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.diff;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import wiremock.org.xmlunit.diff.XPathContext;
import wiremock.org.xmlunit.util.Mapper;

class ChildNodeXPathContextProvider
implements Mapper<Node, XPathContext> {
    private final XPathContext xpathContext;
    private final Map<Node, Integer> childIndex;

    ChildNodeXPathContextProvider(XPathContext parentContext, Iterable<Node> children) {
        this.xpathContext = parentContext.clone();
        HashMap<Node, Integer> index = new HashMap<Node, Integer>();
        int i2 = 0;
        for (Node n : children) {
            index.put(n, i2++);
        }
        this.childIndex = Collections.unmodifiableMap(index);
    }

    @Override
    public XPathContext apply(Node n) {
        XPathContext ctx = this.xpathContext.clone();
        Integer idx = this.childIndex.get(n);
        if (idx == null) {
            throw new NoSuchElementException(n + " is not a known child node");
        }
        ctx.navigateToChild(idx);
        return ctx;
    }
}

