/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.Locale;
import wiremock.jakarta.servlet.GenericServlet;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.ServletRequest;
import wiremock.jakarta.servlet.ServletResponse;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.servlet.ServletHandler;
import wiremock.org.eclipse.jetty.servlet.ServletHolder;
import wiremock.org.eclipse.jetty.servlet.ServletMapping;
import wiremock.org.eclipse.jetty.util.URIUtil;
import wiremock.org.eclipse.jetty.util.resource.Resource;

public class JspPropertyGroupServlet
extends GenericServlet {
    private static final long serialVersionUID = 3681783214726776945L;
    public static final String NAME = "__org.eclipse.jetty.servlet.JspPropertyGroupServlet__";
    private final ServletHandler _servletHandler;
    private final ContextHandler _contextHandler;
    private ServletHolder _dftServlet;
    private ServletHolder _jspServlet;
    private boolean _starJspMapped;

    public JspPropertyGroupServlet(ContextHandler context, ServletHandler servletHandler) {
        this._contextHandler = context;
        this._servletHandler = servletHandler;
    }

    @Override
    public void init() throws ServletException {
        String jspName = "jsp";
        ServletMapping servletMapping = this._servletHandler.getServletMapping("*.jsp");
        if (servletMapping != null) {
            ServletMapping[] mappings;
            this._starJspMapped = true;
            for (ServletMapping m4 : mappings = this._servletHandler.getServletMappings()) {
                String[] paths = m4.getPathSpecs();
                if (paths == null) continue;
                for (String path : paths) {
                    if (!"*.jsp".equals(path) || NAME.equals(m4.getServletName())) continue;
                    servletMapping = m4;
                }
            }
            jspName = servletMapping.getServletName();
        }
        this._jspServlet = this._servletHandler.getServlet(jspName);
        String defaultName = "default";
        ServletMapping defaultMapping = this._servletHandler.getServletMapping("/");
        if (defaultMapping != null) {
            defaultName = defaultMapping.getServletName();
        }
        this._dftServlet = this._servletHandler.getServlet(defaultName);
    }

    @Override
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        String pathInContext;
        HttpServletRequest request2 = null;
        if (!(req instanceof HttpServletRequest)) {
            throw new ServletException("Request not HttpServletRequest");
        }
        request2 = (HttpServletRequest)req;
        String servletPath = null;
        String pathInfo = null;
        if (request2.getAttribute("wiremock.jakarta.servlet.include.request_uri") != null) {
            servletPath = (String)request2.getAttribute("wiremock.jakarta.servlet.include.servlet_path");
            pathInfo = (String)request2.getAttribute("wiremock.jakarta.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request2.getServletPath();
                pathInfo = request2.getPathInfo();
            }
        } else {
            servletPath = request2.getServletPath();
            pathInfo = request2.getPathInfo();
        }
        if ((pathInContext = URIUtil.addPaths(servletPath, pathInfo)).endsWith("/")) {
            this._dftServlet.getServlet().service(req, res);
        } else if (this._starJspMapped && pathInContext.toLowerCase(Locale.ENGLISH).endsWith(".jsp")) {
            this._jspServlet.getServlet().service(req, res);
        } else {
            Resource resource = this._contextHandler.getResource(pathInContext);
            if (resource != null && resource.isDirectory()) {
                this._dftServlet.getServlet().service(req, res);
            } else {
                this._jspServlet.getServlet().service(req, res);
            }
        }
    }
}

