/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.nio.support;

import wiremock.org.apache.hc.core5.function.Decorator;
import wiremock.org.apache.hc.core5.function.Supplier;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpRequestMapper;
import wiremock.org.apache.hc.core5.http.MisdirectedRequestException;
import wiremock.org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import wiremock.org.apache.hc.core5.http.nio.HandlerFactory;
import wiremock.org.apache.hc.core5.http.nio.support.ImmediateResponseExchangeHandler;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.util.Args;

public final class DefaultAsyncResponseExchangeHandlerFactory
implements HandlerFactory<AsyncServerExchangeHandler> {
    private final HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> mapper;
    private final Decorator<AsyncServerExchangeHandler> decorator;

    public DefaultAsyncResponseExchangeHandlerFactory(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> mapper, Decorator<AsyncServerExchangeHandler> decorator) {
        this.mapper = Args.notNull(mapper, "Request handler mapper");
        this.decorator = decorator;
    }

    public DefaultAsyncResponseExchangeHandlerFactory(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> mapper) {
        this(mapper, null);
    }

    private AsyncServerExchangeHandler createHandler(HttpRequest request2, HttpContext context) throws HttpException {
        try {
            Supplier<AsyncServerExchangeHandler> supplier = this.mapper.resolve(request2, context);
            return supplier != null ? supplier.get() : new ImmediateResponseExchangeHandler(404, "Resource not found");
        }
        catch (MisdirectedRequestException ex) {
            return new ImmediateResponseExchangeHandler(421, "Not authoritative");
        }
    }

    @Override
    public AsyncServerExchangeHandler create(HttpRequest request2, HttpContext context) throws HttpException {
        AsyncServerExchangeHandler handler = this.createHandler(request2, context);
        if (handler != null) {
            return this.decorator != null ? this.decorator.decorate(handler) : handler;
        }
        return null;
    }
}

