/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpRequestFactory;
import wiremock.org.apache.hc.core5.http.MessageConstraintException;
import wiremock.org.apache.hc.core5.http.RequestHeaderFieldsTooLargeException;
import wiremock.org.apache.hc.core5.http.config.Http1Config;
import wiremock.org.apache.hc.core5.http.impl.nio.AbstractMessageParser;
import wiremock.org.apache.hc.core5.http.message.LineParser;
import wiremock.org.apache.hc.core5.http.message.RequestLine;
import wiremock.org.apache.hc.core5.http.nio.SessionInputBuffer;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpRequestParser<T extends HttpRequest>
extends AbstractMessageParser<T> {
    private final HttpRequestFactory<T> requestFactory;

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, LineParser parser, Http1Config http1Config) {
        super(parser, http1Config);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, Http1Config http1Config) {
        this(requestFactory, null, http1Config);
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory) {
        this(requestFactory, null);
    }

    @Override
    public T parse(SessionInputBuffer sessionBuffer, boolean endOfStream) throws IOException, HttpException {
        try {
            return (T)((HttpRequest)super.parse(sessionBuffer, endOfStream));
        }
        catch (MessageConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected T createMessage(CharArrayBuffer buffer) throws HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        T request2 = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request2.setVersion(requestLine.getProtocolVersion());
        return request2;
    }
}

