/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.protocol;

import java.io.IOException;
import java.util.Collection;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.EntityDetails;
import wiremock.org.apache.hc.core5.http.Header;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpRequestInterceptor;
import wiremock.org.apache.hc.core5.http.Method;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    public static final RequestDefaultHeaders INSTANCE = new RequestDefaultHeaders();
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request2, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        String method = request2.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        if (this.defaultHeaders != null) {
            for (Header header : this.defaultHeaders) {
                if (request2.containsHeader(header.getName())) continue;
                request2.addHeader(header);
            }
        }
    }
}

