/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl.async;

import java.util.concurrent.Future;
import wiremock.org.apache.hc.client5.http.async.HttpAsyncClient;
import wiremock.org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import wiremock.org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import wiremock.org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import wiremock.org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import wiremock.org.apache.hc.client5.http.protocol.HttpClientContext;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.concurrent.FutureCallback;
import wiremock.org.apache.hc.core5.function.Supplier;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import wiremock.org.apache.hc.core5.http.nio.AsyncRequestProducer;
import wiremock.org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import wiremock.org.apache.hc.core5.http.nio.HandlerFactory;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.io.ModalCloseable;
import wiremock.org.apache.hc.core5.reactor.IOReactorStatus;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.STATELESS)
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
ModalCloseable {
    public abstract void start();

    public abstract IOReactorStatus getStatus();

    public abstract void awaitShutdown(TimeValue var1) throws InterruptedException;

    public abstract void initiateShutdown();

    protected abstract <T> Future<T> doExecute(HttpHost var1, AsyncRequestProducer var2, AsyncResponseConsumer<T> var3, HandlerFactory<AsyncPushConsumer> var4, HttpContext var5, FutureCallback<T> var6);

    public final <T> Future<T> execute(HttpHost target, AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        return this.doExecute(target, requestProducer, responseConsumer, pushHandlerFactory, context, callback);
    }

    @Override
    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        return this.doExecute(null, requestProducer, responseConsumer, pushHandlerFactory, context, callback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        return this.execute(requestProducer, responseConsumer, null, context, callback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        return this.execute(requestProducer, responseConsumer, HttpClientContext.create(), callback);
    }

    public final Future<SimpleHttpResponse> execute(SimpleHttpRequest request2, HttpContext context, FutureCallback<SimpleHttpResponse> callback) {
        Args.notNull(request2, "Request");
        return this.execute(SimpleRequestProducer.create(request2), SimpleResponseConsumer.create(), context, callback);
    }

    public final Future<SimpleHttpResponse> execute(SimpleHttpRequest request2, FutureCallback<SimpleHttpResponse> callback) {
        return this.execute(request2, HttpClientContext.create(), callback);
    }

    public abstract void register(String var1, String var2, Supplier<AsyncPushConsumer> var3);

    public final void register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        this.register(null, uriPattern, supplier);
    }
}

