/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import wiremock.net.javacrumbs.jsonunit.core.Configuration;
import wiremock.net.javacrumbs.jsonunit.core.internal.JsonUtils;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;
import wiremock.net.javacrumbs.jsonunit.core.internal.Path;

class Context {
    private final Node expectedNode;
    private final Node actualNode;
    private final Path expectedPath;
    private final Path actualPath;
    private final Configuration configuration;

    Context(Node expectedNode, Node actualNode, Path expectedPath, Path actualPath, Configuration configuration) {
        this.expectedNode = expectedNode;
        this.actualNode = actualNode;
        this.expectedPath = expectedPath;
        this.actualPath = actualPath;
        this.configuration = configuration;
    }

    Node getExpectedNode() {
        return this.expectedNode;
    }

    Node getActualNode() {
        return this.actualNode;
    }

    Path getExpectedPath() {
        return this.expectedPath;
    }

    Path getActualPath() {
        return this.actualPath;
    }

    Context inField(String key) {
        return new Context(this.expectedNode.get(key), this.actualNode.get(key), this.expectedPath.toField(key), this.actualPath.toField(key), this.configuration);
    }

    Context toElement(int i2) {
        return new Context(this.expectedNode.element(i2), this.actualNode.element(i2), this.expectedPath.toElement(i2), this.actualPath.toElement(i2), this.configuration);
    }

    Context missingElement(int i2) {
        return new Context(this.expectedNode.element(i2), null, this.expectedPath.toElement(i2), null, this.configuration);
    }

    Context extraElement(int i2) {
        return new Context(null, this.actualNode.element(i2), null, this.actualPath.toElement(i2), this.configuration);
    }

    Context length(Object expectedLength) {
        return new Context(JsonUtils.wrapDeserializedObject(expectedLength), JsonUtils.wrapDeserializedObject(this.actualNode.size()), this.expectedPath.length(), this.actualPath.length(), this.configuration);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

