/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import wiremock.com.github.jknack.handlebars.Context;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.HandlebarsException;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.TagType;
import wiremock.com.github.jknack.handlebars.internal.BaseTemplate;
import wiremock.com.github.jknack.handlebars.internal.Param;
import wiremock.com.github.jknack.handlebars.internal.RefParam;
import wiremock.com.github.jknack.handlebars.internal.VarParam;

abstract class HelperResolver
extends BaseTemplate {
    protected List<Param> params = Collections.emptyList();
    protected Map<String, Param> hash = Collections.emptyMap();
    protected int paramSize;
    protected int hashSize;
    private static final Object[] PARAMS = new Object[0];

    HelperResolver(Handlebars handlebars) {
        super(handlebars);
    }

    protected Map<String, Object> hash(Context context) throws IOException {
        if (this.hashSize == 0) {
            return new HashMap<String, Object>();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Param> entry : this.hash.entrySet()) {
            Param value = entry.getValue();
            result.put(entry.getKey(), value.apply(context));
        }
        return result;
    }

    protected Object[] params(Context ctx) throws IOException {
        if (this.paramSize <= 1) {
            return PARAMS;
        }
        Object[] values = new Object[this.paramSize - 1];
        for (int i2 = 1; i2 < this.paramSize; ++i2) {
            Param value = this.params.get(i2);
            Object resolved = value.apply(ctx);
            values[i2 - 1] = resolved == null && this.handlebars.stringParams() ? value.toString() : resolved;
        }
        return values;
    }

    protected Object[] decoParams(Context ctx) throws IOException {
        Object[] values = new Object[this.paramSize];
        for (int i2 = 0; i2 < this.paramSize; ++i2) {
            Param value = this.params.get(i2);
            Object resolved = value.apply(ctx);
            values[i2] = resolved == null && this.handlebars.stringParams() ? value.toString() : resolved;
        }
        return values;
    }

    protected Object determineContext(Context context) throws IOException {
        if (this.paramSize == 0) {
            return context.model();
        }
        return this.params.get(0).apply(context);
    }

    public static final Object transform(Object candidate) {
        if (candidate != null && candidate.getClass().isArray()) {
            return Arrays.asList((Object[])candidate);
        }
        return candidate;
    }

    protected Helper<Object> helper(String name) {
        Helper<Object> helper = this.handlebars.helper(name);
        if (helper == null && (this.paramSize > 0 || this.hashSize > 0)) {
            Helper helperMissing = this.handlebars.helper("helperMissing");
            if (helperMissing == null) {
                throw new HandlebarsException(new IllegalArgumentException("could not find helper: '" + name + "'"));
            }
            helper = helperMissing;
        }
        return helper;
    }

    public HelperResolver hash(Map<String, Param> hash) {
        this.hash = hash == null || hash.size() == 0 ? Collections.emptyMap() : hash;
        this.hashSize = hash.size();
        return this;
    }

    public HelperResolver params(List<Param> params) {
        this.params = params == null || params.size() == 0 ? Collections.emptyList() : params;
        this.paramSize = this.params.size();
        return this;
    }

    protected String paramsToString(List<?> params) {
        if (this.paramSize > 0) {
            StringBuilder buffer = new StringBuilder();
            String sep = " ";
            for (Object param : params) {
                if (param instanceof BaseTemplate) {
                    buffer.append(((BaseTemplate)param).text()).append(sep);
                    continue;
                }
                buffer.append(param).append(sep);
            }
            buffer.setLength(buffer.length() - sep.length());
            return buffer.toString();
        }
        return "";
    }

    protected String hashToString() {
        if (this.hashSize > 0) {
            StringBuilder buffer = new StringBuilder();
            String sep = " ";
            for (Map.Entry<String, Param> hash : this.hash.entrySet()) {
                Param hashValue = hash.getValue();
                String hashText = hashValue.toString();
                buffer.append(hash.getKey()).append("=").append(hashText).append(sep);
            }
            buffer.setLength(buffer.length() - sep.length());
            return buffer.toString();
        }
        return "";
    }

    @Override
    protected void collect(Collection<String> result, TagType tagType) {
        for (Param param : this.params) {
            if (!(param instanceof VarParam)) continue;
            ((VarParam)param).fn.collect(result, tagType);
        }
    }

    @Override
    protected void collectReferenceParameters(Collection<String> result) {
        for (Param param : this.params) {
            if (param instanceof VarParam) {
                ((VarParam)param).fn.collectReferenceParameters(result);
                continue;
            }
            if (!(param instanceof RefParam)) continue;
            result.add(param.toString());
        }
        for (Param hashValue : this.hash.values()) {
            if (!(hashValue instanceof RefParam)) continue;
            result.add(hashValue.toString());
        }
    }
}

