/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.helper;

import java.io.IOException;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.TagType;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class LogHelper
implements Helper<Object> {
    public static final Helper<Object> INSTANCE = new LogHelper();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "log";

    @Override
    public Object apply(Object context, Options options2) throws IOException {
        StringBuilder sb = new StringBuilder();
        String level = (String)options2.hash("level", "info");
        TagType tagType = options2.tagType;
        if (tagType.inline()) {
            sb.append(context);
            for (int i2 = 0; i2 < options2.params.length; ++i2) {
                sb.append(" ").append(options2.param(i2));
            }
        } else {
            sb.append(options2.fn());
        }
        switch (level) {
            case "error": {
                this.log.error(sb.toString().trim());
                break;
            }
            case "debug": {
                this.log.debug(sb.toString().trim());
                break;
            }
            case "warn": {
                this.log.warn(sb.toString().trim());
                break;
            }
            case "trace": {
                this.log.trace(sb.toString().trim());
                break;
            }
            default: {
                this.log.info(sb.toString().trim());
            }
        }
        return null;
    }
}

